/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.Installer;
import com.maplesoft.mapleta.hotfix.installer.Platform;
import com.maplesoft.mapleta.hotfix.installer.UpdateLogger;
import com.maplesoft.mapleta.hotfix.installer.WindowsRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TomcatFolderFinder {
    private static final String tomcatInstallKey = "Software\\Apache Software Foundation\\Tomcat";
    private static final int REVISITED_FOLDER_MESSAGE_MAX = 10;
    private static final int CANONICAL_PATH_ERROR_MESSAGE_MAX = 10;
    private boolean detectCircularityPlease = false;
    private boolean detectMultipleVisitsPlease = false;
    private List<String> startFolders = new ArrayList<String>();
    private List<String> tomcatFolders = new ArrayList<String>();
    private Set<String> visitedFolders;
    private Set<String> revisitedFolders;
    private int folderVisitCount;
    private int duplicateCount;
    private int circularityCount;
    private int canonicalPathErrorCount;
    private Pattern deploymentPattern = Pattern.compile("^(.*)(\\\\|/)webapps(\\\\|/)" + Installer.getHotfixDef().getContextName());

    public List<String> getTomcatFolders() {
        return this.tomcatFolders;
    }

    public TomcatFolderFinder() {
        ArrayList<String> startFolderCandidates = new ArrayList<String>();
        if (Platform.IsWindows()) {
            String[] envVars;
            String[] stringArray = envVars = new String[]{"ProgramFiles"};
            int n = envVars.length;
            int n2 = 0;
            while (n2 < n) {
                String envVar = stringArray[n2];
                String envValue = System.getenv(envVar);
                if (envValue != null) {
                    startFolderCandidates.add(envValue);
                }
                ++n2;
            }
        } else {
            startFolderCandidates.add("/usr");
            startFolderCandidates.add("/opt");
            this.detectCircularityPlease = true;
            this.detectMultipleVisitsPlease = true;
        }
        for (String candidate : startFolderCandidates) {
            File file = new File(candidate);
            if (!file.isDirectory()) continue;
            this.startFolders.add(candidate);
        }
    }

    public String findFromRegistry() {
        String tomcatFolder = "";
        try {
            WindowsRegistry registry = new WindowsRegistry();
            List<String> tomcatVersionKeys = registry.listKeys(-2147483646, tomcatInstallKey);
            for (String tomcatVersionKey : tomcatVersionKeys) {
                File taDeploymentFolderFile;
                int installKeyHandle = registry.openKey(-2147483646, String.format("%s\\%s", tomcatInstallKey, tomcatVersionKey));
                String installPath = registry.getValue(installKeyHandle, "InstallPath");
                registry.closeKey(installKeyHandle);
                if (installPath == null || installPath.length() <= 0 || !(taDeploymentFolderFile = new File(String.valueOf(installPath) + File.separator + "webapps" + File.separator + Installer.getHotfixDef().getContextName())).exists() || this.tomcatFolders.contains(installPath)) continue;
                this.tomcatFolders.add(installPath);
            }
        }
        catch (Exception ex) {
            UpdateLogger.getLogger().Log(String.format("Warning, error encountered while attempting to locate Tomcat via the registry: %s.", ex.getMessage()));
        }
        if (this.tomcatFolders.size() == 1) {
            tomcatFolder = this.tomcatFolders.get(0);
        }
        return tomcatFolder;
    }

    public String find() {
        String tomcatFolder = "";
        this.visitedFolders = new HashSet<String>();
        this.revisitedFolders = new HashSet<String>();
        this.folderVisitCount = 0;
        this.duplicateCount = 0;
        this.circularityCount = 0;
        this.canonicalPathErrorCount = 0;
        for (String startFolder : this.startFolders) {
            UpdateLogger.getLogger().Log(String.format("Searching '%s'. This may take several minutes.", startFolder));
            this.folderVisitCount = 1;
            File folderFile = new File(startFolder);
            this.visitedFolders.add(this.computeCanonicalPath(folderFile));
            this._find(folderFile);
        }
        if (Installer.getCommandLineInfo().isDebug()) {
            UpdateLogger.getLogger().Log(String.format("Folders tested: %d", this.folderVisitCount));
            if (this.detectMultipleVisitsPlease) {
                UpdateLogger.getLogger().Log(String.format("Circularities found: %d", this.circularityCount));
            }
            if (this.detectMultipleVisitsPlease) {
                UpdateLogger.getLogger().Log(String.format("Unique folder tests: %d", this.visitedFolders.size()));
                UpdateLogger.getLogger().Log(String.format("Repeat folder visits (caused by links): %d", this.duplicateCount));
            }
            if (this.canonicalPathErrorCount > 0) {
                UpdateLogger.getLogger().Log(String.format("Errors while computing real paths for links: %d", this.canonicalPathErrorCount));
            }
        }
        if (this.tomcatFolders.size() == 1) {
            tomcatFolder = this.tomcatFolders.get(0);
        }
        return tomcatFolder;
    }

    private void _find(File folderFile) {
        this.LogSearchTest(folderFile);
        Matcher matcher = this.deploymentPattern.matcher(folderFile.getAbsolutePath());
        if (matcher.find()) {
            String candidateFolder = matcher.group(1);
            if (!this.tomcatFolders.contains(candidateFolder)) {
                this.tomcatFolders.add(candidateFolder);
            }
            return;
        }
        File[] childFiles = folderFile.listFiles();
        if (childFiles != null) {
            File[] fileArray = childFiles;
            int n = childFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                if (childFile.isDirectory()) {
                    ++this.folderVisitCount;
                    if (this.detectCircularityPlease && this.isCircularDescent(folderFile, childFile)) {
                        this.LogCircularitySkip(childFile);
                    } else if (this.detectMultipleVisitsPlease && !this.isFirstVisit(childFile)) {
                        this.LogMultiVisitSkip(childFile);
                    } else {
                        this._find(childFile);
                    }
                }
                ++n2;
            }
        }
    }

    private void LogSearchTest(File folderFile) {
        if (Installer.getCommandLineInfo().isDebug()) {
            String absolutePath = folderFile.getAbsolutePath();
            if (Platform.IsWindows()) {
                UpdateLogger.getLogger().Log(String.format("Testing '%s'", absolutePath));
            } else {
                String canonicalPath = this.computeCanonicalPath(folderFile);
                if (canonicalPath.equals(absolutePath)) {
                    UpdateLogger.getLogger().Log(String.format("Testing '%s'", absolutePath));
                } else {
                    UpdateLogger.getLogger().Log(String.format("Testing '%s', real name '%s'", absolutePath, canonicalPath));
                }
            }
        }
    }

    private void LogCircularitySkip(File folderFile) {
        if (Installer.getCommandLineInfo().isDebug()) {
            String absolutePath = folderFile.getAbsolutePath();
            if (Platform.IsWindows()) {
                UpdateLogger.getLogger().Log(String.format("Skipping '%s' (circularity)", absolutePath));
            } else {
                String canonicalPath = this.computeCanonicalPath(folderFile);
                if (canonicalPath.equals(absolutePath)) {
                    UpdateLogger.getLogger().Log(String.format("Skipping '%s' (circularity)", absolutePath));
                } else {
                    UpdateLogger.getLogger().Log(String.format("Skipping '%s', real name '%s' (circularity)", absolutePath, canonicalPath));
                }
            }
        }
    }

    private void LogMultiVisitSkip(File folderFile) {
        if (Installer.getCommandLineInfo().isDebug()) {
            String absolutePath = folderFile.getAbsolutePath();
            if (Platform.IsWindows()) {
                UpdateLogger.getLogger().Log(String.format("Skipping '%s' (already processed)", absolutePath));
            } else {
                String canonicalPath = this.computeCanonicalPath(folderFile);
                if (canonicalPath.equals(absolutePath)) {
                    UpdateLogger.getLogger().Log(String.format("Skipping '%s' (already processed)", absolutePath));
                } else {
                    UpdateLogger.getLogger().Log(String.format("Skipping '%s', real name '%s' (already processed)", absolutePath, canonicalPath));
                }
            }
        }
    }

    private boolean isFirstVisit(File folderFile) {
        String canonicalPath = this.computeCanonicalPath(folderFile);
        if (canonicalPath.length() == 0) {
            return false;
        }
        if (this.visitedFolders.contains(canonicalPath)) {
            ++this.duplicateCount;
            this.revisitedFolders.add(canonicalPath);
            return false;
        }
        this.visitedFolders.add(canonicalPath);
        return true;
    }

    private boolean isCircularDescent(File parent, File child) {
        String parentCanonicalPath = this.computeCanonicalPath(parent);
        if (parentCanonicalPath.length() == 0) {
            return false;
        }
        String childCanonicalPath = this.computeCanonicalPath(child);
        if (childCanonicalPath.length() == 0) {
            return false;
        }
        boolean isCircular = parentCanonicalPath.startsWith(childCanonicalPath);
        if (isCircular) {
            ++this.circularityCount;
            if (this.circularityCount <= 10) {
                UpdateLogger.getLogger().Log(String.format("Warning, '%s' is part of a loop in the directory structure. We have already visited the directory to which it points.", child.getAbsolutePath()));
            } else if (this.revisitedFolders.size() == 11) {
                UpdateLogger.getLogger().Log(String.format("Warning, more than %d possible circularities encountered. No more circularity warning messages will be issued.", 10));
            }
        }
        return isCircular;
    }

    private String computeCanonicalPath(File file) {
        String canonicalPath;
        block3: {
            canonicalPath = "";
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (Exception ex) {
                ++this.canonicalPathErrorCount;
                if (this.canonicalPathErrorCount <= 10) {
                    UpdateLogger.getLogger().Log(String.format("Warning, error encountered while resolving name of '%s': '%s'", file.getAbsolutePath(), ex.getMessage()));
                }
                if (this.canonicalPathErrorCount != 11) break block3;
                UpdateLogger.getLogger().Log(String.format("Warning, more than %d name resolution errors encountered. No more name resolution warning messages will be issued.", 10));
            }
        }
        return canonicalPath;
    }
}

