define([ 'i18n!nls/strings', 'common', 'text!templates/questions/view.html', 'views/widgets/rename', 'collections/questionGroups', 
        'views/questionGroups/simpleList', 'models/questionStatistics', 'views/questions/statistics/questionStatistics',
        'views/questionGroups/selectList', 'views/questionGroups/selectItem', 'collections/subjects', 'collections/questions', 'views/subjects/simpleList',
        'views/subjects/selectList', 'views/subjects/selectItem', 'views/questions/previewWindow',  'views/questions/attributionList', 'views/questions/editDescription',
        'views/questions/selectLanguage', 'views/questions/hints/list', 'views/questions/revisions/list', 'collections/questionRevisions', 'views/questions/publishButton',
        'views/questions/report', 'models/accessInfo', 'views/widgets/editWeight', 'views/questions/inlinePreview', 'views/questions/infoFields/edit'], 
        function( strings, common, questionTemplate, renameView, questionGroupsList, questionGroupsViewListView, questionStatisticsModel, questionStatisticsView, questionGroupSelectListView, questionGroupSelectItemView, subjectsCollection, questionsCollection, subjectsListView, subjectSelectListView, subjectSelectItemView, 
        		questionPreviewView,
        		attributionListView, editDescriptionView, selectLanguageView,  hintsListView, revisionsListView, revisionsCollection, 
        		publishButtonView, reportView, accessInfoModel, editWeightView, inlinePreviewView, editInfoFieldsView) {

	var questionView = Backbone.View.extend({
		events: {
			'click .name': 'rename',
			'click #editDescription': 'editDescription',
			'click #addDescription': 'editDescription',
			'click #preview': 'showPreview',
			'click #editAlgorithm': 'editAlgorithm',
			'click #addAlgorithm': 'editAlgorithm',
			'click #editSolution': 'editSolution',
			'click #addSolution': 'editSolution',
			'click #editFeedback': 'editFeedback',
			'click #addFeedback': 'editFeedback',
			'click #editInfoFields': 'editInfoFields',
			'click #addInfoFields': 'editInfoFields',
			'click #questionGroups .edit': 'editQuestionGroups',
			'click #questionGroups .editDone': 'displayQuestionGroups',
			'click #subjects .edit': 'editSubjects',
			'click #subjects .editDone': 'displaySubjects',
			'click #showPreview': 'showPreview',
			'click #editQuestion': 'editQuestion',
			'click #editSource': 'editSource',
			'click #clone': 'cloneQuestion',
			'change #privacy': 'changePrivacy',
			'change #difficulty': 'changeDifficulty',
			'click #addHint': 'addHint',
			'click #sendReport': 'startReport'
		},
		initialize: function() {
			this.template = _.template(questionTemplate);
		},
		render: function() {
			var self = this;

			this.showEditControls = this.model.get('classId') == currentClassId && rolePrivileges.get('editQuestion');

			self.revisions = new revisionsCollection(null, {
				questionUid: this.model.get('uid')
			});

			self.revisions.fetch({ success: function(){
				// Grab all revisions to be more efficient - only render the latest
				var latestRevision = self.revisions.models[0];

				$(self.el).html(
						self.template({
							header: self.model,
							revision: latestRevision,
							showEditControls: self.showEditControls,
							strings: strings.questions.view,
							common: common
						}));

				self.displayRevisions();
				

				var attributionView = new attributionListView({
					el:   $('#authorList', self.el),
					model: self.model,
					revisions: self.revisions,
					showEditControls: self.showEditControls
				});
				attributionView.render();

				new inlinePreviewView({
					el: $('#preview', this.el),
					model: self.model
				}).render();

				self.setCrumbtrail(strings.questions.view.crumbtrail);

				self.displayQuestionGroups();
				self.displaySubjects();
				self.displayHints(latestRevision);



				if( self.showEditControls ){
					var publishButton = new publishButtonView({
						el: $('#publishButton'),
						model: self.model
					});
					publishButton.render();
				}


				var languageView = new selectLanguageView({
					el: $("#selectLanguage", self.el),
					model: self.model,
					showEditControls: self.showEditControls,
					parentView: self
				});
				languageView.render();


				var statistics = new questionStatisticsModel({
					id: self.model.get('uid')
				});

				var statisticsView = new questionStatisticsView({
					el: $('#statistics', self.el),
					model: statistics
				});

				statistics.fetch({
					success: function() {
						statisticsView.render();
					}
				});
				
				if (self.showEditControls){
					var editWeight = new editWeightView({
						el: $('#weightArea', self.el),
						model: self.model
					});
					editWeight.render();
					
				}


			}});

			return this;
		},
		editAlgorithm: function() {
			window.location = this.getEditUrl() + "&open=algorithm";
		},
		editFeedback: function() {

			window.location = this.getEditUrl() + "&open=feedback";

		},
		editInfoFields: function() {
			var view = new editInfoFieldsView({
				model: this.model,
				el: $('#editInfoFieldsArea', this.el),
				parentView: this
			});
    	
			view.render();
	    	
			// Show the popup
			$('#editInfoFieldsArea', this.el).modal({
				backdrop: false
			});
			$('.menubar').css('z-index', 'inherit');
			
			return false;
		},
		isLegacyQuestionType: function(){
			// Returns true if this question's type hasn't been updated to use Struts instead of CGI
			var revision = this.revisions.models[0];
			
			var modePart = revision.get('mode');

			switch( modePart ){
			case "Clickable Image":
			case "Multipart":
			case "Blanks":
				return true;
			default:
				return false;
			}
		},
		getEditMode: function(){
			var modePart = this.revisions.models[0].get('mode');
			
			if( modePart.toLowerCase().indexOf("formula") >= 0){
				return "Formula";
			}else{
				switch( modePart ){
				case "Ntuple":
				case "Equation":
					return "Formula";
				case "True False":
					return "TrueFalse";
				case "Multiple Choice":
				case "Multiple Selection":
				case "Non Permuting Multiple Choice":
				case "Non Permuting Multiple Selection":
					return "MultipleChoice";
				case "Adaptive Inline":
					return "AdaptiveInline";
				case "Palette-based symbolic editor":
					return "Palette";
				case "Math App":
					return "MathApp";
				case "Clickable Image":
					return "ClickableImage";
				case "Inline":
				case "Essay":
				case "Maple":
				case "Matching":
				case "Numeric":
				case "Palette":
				case "Blanks":
				case "Multipart":
					return modePart.replace(/ /g,' ');
				default:
					return null;
				};	
			}
		},
		getEditUrl: function(){
			var editMode = this.getEditMode();
			
			if( editMode != null ){
				return getBaseURL() + 'qbeditor/Add' + editMode + '.do?uid=' + this.model.get('uid');
			}else{
				return null;
			}
		},
		editQuestion: function() {
			var editUrl = this.getEditUrl();
			
			if( this.isLegacyQuestionType() ){
				common.doAction('Next');
			}else if ( editUrl != null ){
				window.location = editUrl;
			}else{
				// Must be a source only type
				this.editSource();
			}
		},
		editSource: function() {
			window.location = getBaseURL() + 'qbeditor/EditSource.do?uid=' + this.model.get('uid');
		},
		editSubjects: function() {

			$('#subjects .edit').hide();
			$('#subjects .editDone').show();
			var rootSubjects = new subjectsCollection(null, {
				parentUid: null,
				term: null
			});

			var self = this;

			var selectList = new subjectSelectListView({
				itemView: subjectSelectItemView,
				model: rootSubjects,
				toExpandSubjects: this.subjects,
				selectSubjects: this.subjects,
				changeHandler: function(subjectModel, checked) {
					if (checked) {

						$.ajax({
							type: 'POST',
							url: self.model.getSubjectsUrl(),
							contentType: 'application/json',
							data: JSON.stringify(subjectModel.toJSON())
						});
					} else {
						$.ajax({
							type: 'DELETE',
							url: self.model.url().replace("?", '/subjects/' + subjectModel.get('uid') + "?")
						});
					}
				}
			});


			rootSubjects.fetch({
				success: function() {
					$('#subjectList', self.el).html(selectList.render().el);
				}
			});

		},
		editQuestionGroups: function() {

			$('#questionGroups .edit').hide();
			$('#questionGroups .editDone').show();
			var messages = new questionGroupsList(null, {
				parentUid: null,
				term: null
			});

			var self = this;

			var selectList = new questionGroupSelectListView({
				itemView: questionGroupSelectItemView,
				model: messages,
				toExpandGroups: this.questionGroups,
				selectGroups: this.questionGroups,
				inputType: 'checkbox',
				changeHandler: function(groupModel, checked) {
					if (checked) {

						$.ajax({
							type: 'POST',
							url: self.model.getGroupsUrl(),
							contentType: 'application/json',
							data: JSON.stringify(groupModel.toJSON())
						});
					} else {
						$.ajax({
							type: 'DELETE',
							url: self.model.url().replace("?", '/groups/' + groupModel.get('uid') + "?")
						});
					}


				}
			});


			messages.fetch({
				success: function() {
					$('#questionGroupsList', self.el).html(selectList.render().el);

				}
			});


		},
		editDescription: function() {

			var rView = new editDescriptionView({
				model: this.model,
				parentView: this,
				el: $('#description', this.el)
			});

			rView.render();
			
			if( !( $('#collapseDescription').hasClass('in'))){
				$('#collapseDescription').collapse('show');
			}
			
			return false;
		},
		rename: function() {
			if( this.showEditControls ){
				var rView = new renameView({
					model: this.model,
					parentView: this,
					el: $('h1', this.el),
					inputClass: 'span6'
				});
	
				rView.render();
			}
		},
		displaySubjects: function() {
			$('#subjects .edit').show();
			$('#subjects .editDone').hide();

			this.subjects = new subjectsCollection(null, {
				questionUid: this.model.get('uid')
			});

			var listView = new subjectsListView({
				model: this.subjects
			});
			$('#subjectList', this.el).html(listView.render().el);

			this.subjects.fetch({
				success: function() {
					listView.render();
				}
			});

		},
		displayQuestionGroups: function() {
			$('#questionGroups .edit').show();
			$('#questionGroups .editDone').hide();

			this.questionGroups = new questionGroupsList(null, {
				questionUid: this.model.get('uid')
			});

			var listView = new questionGroupsViewListView({
				model: this.questionGroups
			});

			this.questionGroups.fetch({
				success: function() {
					$('#questionGroupsList', this.el).html(listView.render().el);
				}
			});

		},
		setCrumbtrail: function(value){
			var crumbtrail = $('.crumbTrail div');

			var links = $('a:not(.added)', crumbtrail);

			links.push("<a href='qbeditor/Questions.do' class='added'>" + strings.home.index.breadCrumb + "</a>");

			$(crumbtrail).html('');

			_.each(links, function(curLink){
				$(crumbtrail).append(curLink);
				$(crumbtrail).append(' &raquo; ');
			});

			$(crumbtrail).append(value);
		},


		unrender: function() {
			$(this.el).remove();
		},
		showPreview: function(){
			if( browseMode != 'public'){
				var self = this;
	
				var view = new questionPreviewView({
					el: $('#modal'),
					model: self.revisions.models[0]
				});
	
				view.render();
			}

			return false;
		},
		cloneQuestion: function(){
			var viewUrl = $('#clone', this.el).attr('href');

			if( viewUrl == null || viewUrl.length == 0){
				$('#clone', this.el).text(strings.questions.view.copying);



				if( currentSource.get('source') != 'public'){
					this.doExportImport(accessInfo);
				}else{
					this.doExportImport(null);
				}
			}else{
				navigate(viewUrl, true, initialSource);

			}
		},
		doExportImport: function(accessInfo){
			var url = this.model.getExportModuleUrl();


			if( accessInfo != null ){
				url += "?" + accessInfo.getAuthorizationUrlParams();
			}

			var importUrl = localApiBase + '/modules/downloadimport';
			
			$.ajax({
				type: 'POST',
				url: importUrl,
				data:  url,
				contentType: 'application/json',
				dataType: 'json'
					
			}).done( function(returnData){

				var questionUid = returnData.questionUids[0];


				$('#clone').attr('href', '/questions/' + questionUid );

				$('#clone').text(strings.questions.view.copyComplete);
				
			});
			
		},
		changePrivacy: function(){
			var newPrivacy = $('#privacy', this.el).val();

			if( newPrivacy != this.model.get('privacy')){


				var url = formatUrl('/questions/' + this.model.get('uid') + '/privacy');
				var data = {
						questionUid: this.model.get('uid'),
						newPrivacy: newPrivacy
				};

				$.ajax({
					type: 'POST',
					url: url,
					data:  JSON.stringify(data),
					contentType: 'application/json',
					dataType: 'json'

				}).done( function(){
					$('#privacy', this.el).after('<span id="savePrivacy" class="notice">Saved</span>');
					_.delay(function(){
						$("#savePrivacy").fadeOut();
					}, 1000);
				});

			}
		},
		changeDifficulty: function(){

			var newDifficulty = $('#difficulty', this.el).val();

			if( newDifficulty != this.model.get('difficulty')){


				this.model.save({
					difficulty: newDifficulty
				}, {
					success: function(data) {
						var newElement = $('#difficulty', this.el).after('<span id="saveDifficulty" class="notice">Saved</span>');
						_.delay(function(){
							$("#saveDifficulty").fadeOut();
						}, 1000);
					}
				});
			}
		},
		displayHints: function(latestRevision){
			this.hintsListView = new hintsListView({
				el: $('#hintsArea', this.el),
				model: {
					hints: latestRevision.get('hints'),
					showEditControls: this.showEditControls,
					question: this.revisions.models[0]
				}
			});

			this.hintsListView.render();
		},
		displayRevisions: function(){

			var self = this;

			var view = new revisionsListView({
				el: $('#revisionsArea', this.el),
				model: {
					revisions: self.revisions,
					showEditControls: self.showEditControls
				}
			});


			view.render();
		},
		addHint: function() {
			this.hintsListView.addHint();
			
			return false;
		},
		startReport: function(){
			var view = new reportView({
				el: $('#reportArea', this.el),
				model: this.model,
				parentView: this
			});
			
			view.render();
			
			return false;
		}

	});

	return questionView;
});
