CREATE INDEX fki_assignment_advanced_policy_assignment_class_id
  ON assignment_advanced_policy
  USING btree
  (assignment_class_id);

CREATE INDEX fki_assignment_advanced_policy_assignment_id
  ON assignment_advanced_policy
  USING btree
  (assignment_id);
  
CREATE INDEX fki_assignment_class_assignmentid
  ON assignment_class
  USING btree
  (assignmentid);

CREATE INDEX fki_assignment_class_classid
  ON assignment_class
  USING btree
  (classid);

CREATE INDEX fki_assignment_class_parent
  ON assignment_class
  USING btree
  (parent);

CREATE INDEX fki_assignment_mastery_penalty_assignment_class_id
  ON assignment_mastery_penalty
  USING btree
  (assignment_class_id);

CREATE INDEX fki_assignment_mastery_policy_assignment_class_id
  ON assignment_mastery_policy
  USING btree
  (assignment_class_id);
  
CREATE INDEX fki_assignment_policy_assignment_class_id
  ON assignment_policy
  USING btree
  (assignment_class_id);

CREATE INDEX fki_assignment_question_group_assignmentid
  ON assignment_question_group
  USING btree
  (assignmentid);

CREATE INDEX fki_assignment_question_group_map_groupid
  ON assignment_question_group_map
  USING btree
  (groupid);

CREATE INDEX fki_assignment_question_group_map_questionid
  ON assignment_question_group_map
  USING btree
  (questionid);

ALTER TABLE ONLY assignment_class
	ADD CONSTRAINT assignment_class_pkey PRIMARY KEY (id);

ALTER TABLE ONLY assignment_class
	ADD CONSTRAINT fk_assignment_class_assignmentid FOREIGN KEY (assignmentid)
    REFERENCES "assignment" (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_class
	ADD CONSTRAINT fk_assignment_class_classid FOREIGN KEY (classid)
    REFERENCES classes (cid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_class
	ADD CONSTRAINT fk_assignment_class_parent FOREIGN KEY (parent)
    REFERENCES assignment_class (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_advanced_policy
	ADD CONSTRAINT assignment_advanced_policy_pkey PRIMARY KEY (assignment_class_id, and_id, or_id);

ALTER TABLE ONLY assignment_advanced_policy
	ADD CONSTRAINT fk_assignment_advanced_policy_assignment_class_id FOREIGN KEY (assignment_class_id)
    REFERENCES assignment_class (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_advanced_policy
	ADD CONSTRAINT fk_assignment_advanced_policy_assignment_id FOREIGN KEY (assignment_id)
    REFERENCES "assignment" (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_mastery_penalty
	ADD CONSTRAINT assignment_mastery_penalty_pkey PRIMARY KEY (assignment_class_id, group_id);

ALTER TABLE ONLY assignment_mastery_penalty
	ADD CONSTRAINT fk_assignment_mastery_penalty_assignment_class_id FOREIGN KEY (assignment_class_id)
	REFERENCES assignment_class (id) MATCH SIMPLE
	ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_mastery_policy
	ADD CONSTRAINT assignment_mastery_policy_pkey PRIMARY KEY (assignment_class_id, complete_group_id, before_group_id);

ALTER TABLE ONLY assignment_mastery_policy
	ADD CONSTRAINT fk_assignment_mastery_policy_assignment_class_id FOREIGN KEY (assignment_class_id)
    REFERENCES assignment_class (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_policy
	ADD CONSTRAINT assignment_policy_pkey PRIMARY KEY (assignment_class_id);

ALTER TABLE ONLY assignment_policy
	ADD CONSTRAINT fk_assignment_policy_assignment_class_id FOREIGN KEY (assignment_class_id)
    REFERENCES assignment_class (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_question_group
	ADD CONSTRAINT assignment_question_group_pkey PRIMARY KEY (id);

ALTER TABLE ONLY assignment_question_group
	ADD CONSTRAINT fk_assignment_question_group_assignmentid FOREIGN KEY (assignmentid)
    REFERENCES "assignment" (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY question
	ADD CONSTRAINT pk_question PRIMARY KEY (id);

ALTER TABLE ONLY question
	ADD CONSTRAINT fk_question_user FOREIGN KEY (author)
    REFERENCES classes (cid) MATCH SIMPLE
    ON UPDATE RESTRICT ON DELETE RESTRICT;

ALTER TABLE ONLY assignment_question_group_map
	ADD CONSTRAINT assignment_question_group_map_pkey PRIMARY KEY (id);

ALTER TABLE ONLY assignment_question_group_map
	ADD CONSTRAINT fk_assignment_question_group_map_groupid FOREIGN KEY (groupid)
    REFERENCES assignment_question_group (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY assignment_question_group_map
	ADD CONSTRAINT fk_assignment_question_group_map_questionid FOREIGN KEY (questionid)
    REFERENCES question (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY question_group
	ADD CONSTRAINT pk_question_group PRIMARY KEY (id);

ALTER TABLE ONLY question_group
	ADD CONSTRAINT fk_question_group_group FOREIGN KEY (parent)
    REFERENCES question_group (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY question_group
	ADD CONSTRAINT fk_question_group_user FOREIGN KEY (creator)
    REFERENCES classes (cid) MATCH SIMPLE
    ON UPDATE RESTRICT ON DELETE RESTRICT;
    
ALTER TABLE ONLY question_group_map
	ADD CONSTRAINT pk_question_group_map PRIMARY KEY (id);

ALTER TABLE ONLY question_group_map
	ADD CONSTRAINT fk_question_group_map_question FOREIGN KEY (questionid)
    REFERENCES question (id) MATCH SIMPLE
    ON UPDATE RESTRICT ON DELETE RESTRICT;

ALTER TABLE ONLY question_group_map
	ADD CONSTRAINT fk_question_group_map_question_group FOREIGN KEY (questiongroupid)
    REFERENCES question_group (id) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE ONLY question_group_map
	ADD CONSTRAINT unique_question_group_map UNIQUE (questionid, questiongroupid);
