/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.applets;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPresentationFormatter;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMathMLDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.util.Base64Encoder;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class MathMLViewer
extends JApplet {
    private WmiMathDocumentModel doc;
    private WmiMathMLDocumentView view;
    private int verticalOffset = 0;

    public void init() {
        WmiCaret.resetTimer();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    MathMLViewer.this.createGUI();
                }
            });
        }
        catch (Exception exception) {
            WmiErrorLog.log(exception);
        }
    }

    public void start() {
        WmiCaret.resetTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGUI() {
        Cloneable cloneable;
        Object object;
        Object object2;
        block48: {
            this.view = new WmiMathMLDocumentView();
            WmiMathDocumentView.setActiveDocumentView(this.view);
            this.doc = (WmiMathDocumentModel)this.view.getModel();
            this.doc.setReadOnly(true);
            this.getContentPane().add(this.view);
            try {
                if (this.getParameter("VERTICAL_OFFSET") != null) {
                    this.verticalOffset = Integer.parseInt(this.getParameter("VERTICAL_OFFSET"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string = this.getParameter("INPUT_TYPE").toString();
            String string2 = "";
            if (string.equals("MathML Presentation")) {
                string2 = this.getParameter("VALUE");
                if (string2 == null) {
                    return;
                }
                this.parseMathML(string2);
            } else if (string.equals("MathML Content")) {
                string2 = this.getParameter("VALUE");
                if (string2 == null) {
                    return;
                }
                if (string2.indexOf("<semantics>") > -1) {
                    int n = string2.indexOf("<semantics>") + "<semantics>".length();
                    int n2 = string2.indexOf("<annotation");
                    string2 = n != -1 && n2 != -1 ? "<math xmlns='http://www.w3.org/1998/Math/MathML'>" + string2.substring(n, n2) + "</math>" : "<math xmlns='http://www.w3.org/1998/Math/MathML'></math>";
                }
                object2 = this.getParameter("MSTYLE_TAG");
                string2 = this.addStyleTag((String)object2, string2);
                this.parseMathML(string2);
            } else if (string.equals("Maple DotM") && WmiModelLock.writeLock(this.doc, true)) {
                try {
                    object2 = this.getParameter("VALUE");
                    if (object2 == null) {
                        return;
                    }
                    object2 = Base64Encoder.decode((String)object2);
                    Dag dag = DagBuilder.createDag(((String)object2).getBytes());
                    object = WmiMathFactory.createMathModel(this.doc, dag, new WmiMathContext(new WmiFontAttributeSet()));
                    cloneable = new WmiMathWrapperModel(this.doc);
                    ((WmiAbstractArrayCompositeModel)cloneable).appendChild((WmiModel)object);
                    WmiMathMLPresentationFormatter wmiMathMLPresentationFormatter = new WmiMathMLPresentationFormatter(this.view);
                    StringWriter stringWriter = new StringWriter();
                    wmiMathMLPresentationFormatter.format(stringWriter, (WmiModel)((Object)cloneable));
                    String string3 = this.getParameter("MSTYLE_TAG");
                    string2 = this.addStyleTag(string3, stringWriter.toString());
                    int n = string2.indexOf("<math");
                    int n3 = string2.indexOf("</math>") + "</math>".length();
                    this.parseMathML(string2.substring(n, n3));
                }
                catch (IOException iOException) {
                    WmiErrorLog.log(iOException);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                catch (WmiFormatException wmiFormatException) {
                    WmiErrorLog.log(wmiFormatException);
                }
                finally {
                    WmiModelLock.writeUnlock(this.doc);
                }
            }
            if (WmiModelLock.writeLock(this.doc, true)) {
                try {
                    this.formatParagraph();
                    if (!WmiModelLock.updateLock(this.doc, true)) break block48;
                    try {
                        this.doc.update(null);
                    }
                    finally {
                        WmiModelLock.updateUnlock(this.doc);
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                    WmiErrorLog.log(wmiNoUpdateAccessException);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
                finally {
                    WmiModelLock.writeUnlock(this.doc);
                }
            }
        }
        if (WmiModelLock.readLock(this.doc, true)) {
            try {
                this.view.updateView();
                object2 = (WmiParagraphView)this.view.getChild(0);
                WmiInlineView wmiInlineView = (WmiInlineView)((WmiArrayCompositeView)object2).getChild(0);
                object = wmiInlineView.getChild(0);
                if (object != null && object instanceof WmiInlineView) {
                    cloneable = (WmiInlineView)object;
                    ((WmiGenericView)cloneable).setVerticalOffset(this.verticalOffset);
                } else {
                    wmiInlineView.setVerticalOffset(this.verticalOffset);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(this.doc);
            }
        }
    }

    private void formatParagraph() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiParagraphModel wmiParagraphModel = (WmiParagraphModel)this.doc.getChild(0);
        WmiLayoutAttributeSet wmiLayoutAttributeSet = (WmiLayoutAttributeSet)wmiParagraphModel.getAttributes();
        wmiLayoutAttributeSet.addAttribute("alignment", "centred");
        wmiLayoutAttributeSet.addAttribute("linebreak", "space");
        wmiLayoutAttributeSet.addAttribute("layout_style_name", "Maple Output");
        wmiParagraphModel.addAttributes(wmiLayoutAttributeSet);
    }

    private String addStyleTag(String string, String string2) {
        if (string == null) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = stringBuffer.indexOf("<math");
        n = stringBuffer.indexOf(">", n);
        stringBuffer.insert(n + 1, string);
        n = stringBuffer.indexOf("</math>");
        stringBuffer.insert(n, "</mstyle>");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMathML(String string) {
        if (WmiModelLock.writeLock(this.doc, true)) {
            try {
                this.doc.removeChildren(0, this.doc.getChildCount());
                WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
                wmiMathMLImportParser.parse(new StringReader(WmiMathMLImportParser.formatInput(string, null, 0)), (WmiCompositeModel)this.doc, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiParseException wmiParseException) {
                WmiErrorLog.log(wmiParseException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            finally {
                WmiModelLock.writeUnlock(this.doc);
            }
        }
    }
}

