/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.RedirectedKernelListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class KernelProxy {
    private static final int KERNEL_INVALID = 0;
    private static final int KERNEL_STARTING = 1;
    private static final int KERNEL_RUNNING = 2;
    private static final int START_WAIT_QUANTUM = 100;
    private static int idCounter = -1;
    private static KernelProxy instance = null;
    private static int nextTransactionID = 0;
    private HashMap runningConnections;
    private Vector pendingConnections;
    private Object connectionQueue;

    private KernelProxy() {
        instance = this;
        this.runningConnections = new HashMap();
        this.pendingConnections = new Vector();
        this.connectionQueue = new Object();
    }

    public static KernelProxy getInstance() {
        if (instance == null) {
            new KernelProxy();
        }
        return instance;
    }

    public void createKernelConnection(KernelConnectionListener kernelConnectionListener) {
        int n = kernelConnectionListener.getKernelID();
        this.setKernelStarting(n);
        KernelConnection kernelConnection = new KernelConnection(this);
        kernelConnection.startSockets();
        this.setKernelRunning(n, kernelConnection);
        kernelConnectionListener.setConnection(kernelConnection);
        kernelConnection.addKernelConnectionListener(kernelConnectionListener);
        kernelConnectionListener.processConnection(new KernelConnectionEvent(1, 1, kernelConnection, kernelConnectionListener));
    }

    public void shutdownKernelListener(KernelConnectionListener kernelConnectionListener) {
        int n = kernelConnectionListener.getKernelID();
        KernelConnection kernelConnection = KernelProxy.getInstance().getKernelConnection(n);
        kernelConnection.removeKernelConnectionListener(kernelConnectionListener);
        KernelConnectionEvent kernelConnectionEvent = null;
        kernelConnectionEvent = new KernelConnectionEvent(0, 2, kernelConnection, kernelConnectionListener);
        kernelConnectionListener.processDisconnection(kernelConnectionEvent);
        this.setKernelInvalid(n);
    }

    public void createKernelIfNeeded(KernelConnectionListener kernelConnectionListener) {
        KernelConnection kernelConnection;
        int n = kernelConnectionListener.getKernelID();
        if (n < 0 || this.getKernelState(n) == 0) {
            if (n < 0) {
                n = ++idCounter;
            }
            this.createKernelConnection(kernelConnectionListener);
        }
        if ((kernelConnection = this.getKernelConnection(kernelConnectionListener.getKernelID())) != null) {
            kernelConnection.confirmListener(kernelConnectionListener);
        }
    }

    public int getNextConnectionID(boolean bl) {
        if (bl) {
            return ++idCounter;
        }
        return idCounter;
    }

    public void sendCommand(int n, KernelListener kernelListener, String string, int n2) {
        KernelConnection kernelConnection = this.getKernelConnection(n);
        if (kernelConnection != null) {
            kernelConnection.sendCommand(kernelListener, string, n2);
        }
    }

    private void sendUrgentCommand(int n, KernelListener kernelListener, String string, int n2) {
        KernelConnection kernelConnection = this.getKernelConnection(n);
        if (kernelConnection != null) {
            kernelConnection.sendUrgentCommand(kernelListener, string, n2);
        }
    }

    private void sendUrgentInternalCommand(int n, KernelListener kernelListener, String string, int n2) {
        KernelConnection kernelConnection = this.getKernelConnection(n);
        if (kernelConnection != null) {
            kernelConnection.sendUrgentInternalCommand(kernelListener, string, n2);
        }
    }

    private void sendInternalCommand(int n, KernelListener kernelListener, String string, int n2) {
        KernelConnection kernelConnection = this.getKernelConnection(n);
        if (kernelConnection != null) {
            kernelConnection.sendInternalCommand(kernelListener, string, n2);
        }
    }

    public void setRedirectedListener(int n, RedirectedKernelListener redirectedKernelListener) {
        KernelConnection kernelConnection = this.getKernelConnection(n);
        if (kernelConnection != null) {
            kernelConnection.setRedirectedListener(redirectedKernelListener);
        }
    }

    public KernelTransaction createTransaction(KernelListener kernelListener, String string, int n) {
        return new KernelTransaction(nextTransactionID++, kernelListener, string, n);
    }

    public KernelTransaction createTransaction(KernelListener kernelListener, String string, int n, boolean bl) {
        return new KernelTransaction(nextTransactionID, kernelListener, string, n, bl);
    }

    public void evaluate(int n, KernelListener kernelListener, String string) {
        this.sendCommand(n, kernelListener, string, 41);
    }

    public void evaluate(int n, KernelListener kernelListener, String string, int n2) {
        this.sendCommand(n, kernelListener, string, n2);
    }

    public void urgentEvaluate(int n, KernelListener kernelListener, String string) {
        this.sendUrgentCommand(n, kernelListener, string, 41);
    }

    public void urgentEvaluate(int n, KernelListener kernelListener, String string, int n2) {
        this.sendUrgentCommand(n, kernelListener, string, n2);
    }

    public void internalEvaluate(int n, KernelListener kernelListener, String string) {
        this.sendInternalCommand(n, kernelListener, string, 41);
    }

    public void internalEvaluate(int n, KernelListener kernelListener, String string, int n2) {
        this.sendInternalCommand(n, kernelListener, string, n2);
    }

    public void urgentInternalEvaluate(int n, KernelListener kernelListener, String string) {
        this.sendUrgentInternalCommand(n, kernelListener, string, 41);
    }

    public void urgentInternalEvaluate(int n, KernelListener kernelListener, String string, int n2) {
        this.sendUrgentInternalCommand(n, kernelListener, string, n2);
    }

    public void shutdownConnection(int n) {
        KernelConnection kernelConnection = this.getKernelConnection(n);
        this.setKernelInvalid(n);
        if (n == idCounter && idCounter > 0) {
            --idCounter;
        }
        if (kernelConnection != null) {
            kernelConnection.stopSockets();
        }
    }

    public int getPort(int n) {
        int n2 = -1;
        KernelConnection kernelConnection = this.getKernelConnection(n);
        if (kernelConnection != null) {
            n2 = kernelConnection.getPort();
        }
        return n2;
    }

    public void shutdownProxy() {
        int[] nArray = this.getKernelIDs();
        for (int i = 0; i < nArray.length; ++i) {
            this.sendCommand(nArray[i], null, "quit", 41);
            this.shutdownConnection(nArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKernelState(int n) {
        int n2 = 0;
        Integer n3 = new Integer(n);
        Object object = this.connectionQueue;
        synchronized (object) {
            if (this.runningConnections.containsKey(n3)) {
                n2 = 2;
            } else if (this.pendingConnections.contains(n3)) {
                n2 = 1;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKernelStarting(int n) {
        Integer n2 = new Integer(n);
        boolean bl = false;
        Object object = this.connectionQueue;
        synchronized (object) {
            if (this.runningConnections.containsKey(n2)) {
                bl = true;
            } else if (!this.pendingConnections.contains(n2)) {
                this.pendingConnections.add(n2);
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Attempt to change running kernel: " + n + "to starting state.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKernelRunning(int n, KernelConnection kernelConnection) {
        Integer n2 = new Integer(n);
        Object object = this.connectionQueue;
        synchronized (object) {
            this.pendingConnections.remove(n2);
            this.runningConnections.put(n2, kernelConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKernelInvalid(int n) {
        Integer n2 = new Integer(n);
        Object object = this.connectionQueue;
        synchronized (object) {
            this.pendingConnections.remove(n2);
            this.runningConnections.remove(n2);
        }
    }

    public boolean isKernelConnectionValid(int n) {
        return this.getKernelState(n) != 0;
    }

    public KernelConnection getKernelConnection(int n, boolean bl) {
        KernelConnection kernelConnection = null;
        int n2 = this.getKernelState(n);
        if (n2 == 0 && bl) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n2 = this.getKernelState(n);
        }
        if (n2 != 0) {
            while (n2 == 1 && bl) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n2 = this.getKernelState(n);
            }
            if (n2 == 2) {
                kernelConnection = this.getRunningConnection(n);
            }
        }
        return kernelConnection;
    }

    public KernelConnection getKernelConnection(int n) {
        return this.getKernelConnection(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KernelConnection getRunningConnection(int n) {
        KernelConnection kernelConnection = null;
        Integer n2 = new Integer(n);
        Object object = this.connectionQueue;
        synchronized (object) {
            kernelConnection = (KernelConnection)this.runningConnections.get(n2);
        }
        return kernelConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKernelConnections() {
        Collection collection = null;
        Object object = this.connectionQueue;
        synchronized (object) {
            collection = this.runningConnections.values();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getKernelIDs() {
        int[] nArray = new int[this.getNumberKernels()];
        Object object = this.connectionQueue;
        synchronized (object) {
            int n = 0;
            Iterator iterator = this.runningConnections.keySet().iterator();
            while (iterator.hasNext()) {
                nArray[n++] = (Integer)iterator.next();
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberKernels() {
        int n = -1;
        Object object = this.connectionQueue;
        synchronized (object) {
            n = this.runningConnections.size();
        }
        return n;
    }

    public void addKernelId(int n) {
        if (n > idCounter) {
            idCounter = n;
        }
    }

    public static class KernelTransaction {
        protected int transactionID;
        protected KernelListener kernelListener;
        protected String command;
        protected int mrfHow;
        protected boolean noDitto;

        KernelTransaction(int n, KernelListener kernelListener, String string, int n2) {
            this.transactionID = n;
            this.kernelListener = kernelListener;
            this.command = string;
            this.mrfHow = n2;
            this.noDitto = false;
        }

        KernelTransaction(int n, KernelListener kernelListener, String string, int n2, boolean bl) {
            this.transactionID = n;
            this.kernelListener = kernelListener;
            this.command = string;
            this.mrfHow = n2;
            this.noDitto = bl;
        }
    }
}

