/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class MapleSocket
extends Socket {
    private InputStream in;
    private OutputStream out;
    private static boolean libraryAvailable = true;
    int socket;

    private native void nativeConnect(String var1, int var2) throws IOException;

    private native void nativeDisconnect() throws IOException;

    private native void nativeWrite(int var1) throws IOException;

    private native int nativeRead() throws IOException;

    private native void nativeSendOOBData(int var1) throws IOException;

    public MapleSocket(String string, int n) throws UnknownHostException, IOException {
        this.nativeConnect(string, n);
        this.in = new SocketInputStream();
        this.out = new SocketOutputStream();
    }

    public void close() throws IOException {
        this.nativeDisconnect();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public static boolean isLibraryAvailable() {
        return libraryAvailable;
    }

    public void sendInterrupt() throws IOException {
        this.nativeSendOOBData(0);
    }

    public void sendDebugMode() throws IOException {
        this.nativeSendOOBData(1);
    }

    static {
        try {
            System.loadLibrary("MapleSocket");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            libraryAvailable = false;
        }
    }

    private class SocketOutputStream
    extends OutputStream {
        private SocketOutputStream() {
        }

        public void write(int n) throws IOException {
            MapleSocket.this.nativeWrite(n);
        }
    }

    private class SocketInputStream
    extends InputStream {
        private SocketInputStream() {
        }

        public int read() throws IOException {
            return MapleSocket.this.nativeRead();
        }
    }
}

