/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ExpseqDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;

public abstract class AbstractCollectionDagFactory
extends ExpseqDagFactory {
    private static final int ELIDETHRESHOLD = 1000;
    private static final int LEFTSAMPLE = 10;
    private static final int RIGHTSAMPLE = 10;

    public abstract String getLeftBracket();

    public abstract String getRightBracket();

    public abstract int getLeftBracketID();

    public abstract int getRightBracketID();

    public static Dag create(int n, Dag[] dagArray) {
        return Dag.createDag(n, dagArray, null, true);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        stringBuffer.append(this.getLeftBracket());
        int n = dag.getLength();
        for (int i = 0; i < n; ++i) {
            DagBuilder.linePrint(stringBuffer, dag.getChild(i), wmiLPrintOptions);
            if (i >= n - 1) continue;
            stringBuffer.append(this.getStringOperator(wmiLPrintOptions));
        }
        stringBuffer.append(this.getRightBracket());
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        Object object;
        LayoutBox layoutBox = new DefaultLayoutBox();
        int n = dag.getLength();
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(2 * n);
        if (n > 0) {
            object = DagBuilder.createLayout(layoutFormatter, dag.getChild(0));
            inlineLayoutBox.addChild((LayoutBox)object);
            for (int i = 1; i < n; ++i) {
                NotationLayoutBox notationLayoutBox;
                if (n > 1000 && i == 10) {
                    notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, "[..." + (n - 10 - 10) + " terms...]");
                    inlineLayoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 14));
                    inlineLayoutBox.addChild(notationLayoutBox);
                    i = n - 10;
                }
                notationLayoutBox = NotationLayoutBox.createNotationBox(layoutFormatter, 14);
                inlineLayoutBox.addChild(notationLayoutBox);
                LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dag.getChild(i));
                inlineLayoutBox.addChild(layoutBox2);
            }
        }
        inlineLayoutBox.setDag(dag);
        inlineLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)2));
        layoutBox = BracketTemplate.apply(layoutFormatter, (LayoutBox)inlineLayoutBox, this.getLeftBracketID(), this.getRightBracketID());
        object = new SelectionData(1);
        ((SelectionData)object).setStandardEastWestArray(inlineLayoutBox);
        ((SelectionData)object).setStandardNorthSouthArray();
        inlineLayoutBox.setSelectionData((SelectionData)object);
        layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)1));
        return layoutBox;
    }

    public int getPrecedence(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        return this.getPrecedence();
    }
}

