/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;

public class BranchDag
extends Dag {
    protected Dag[] theDags;

    public BranchDag(int n, Dag[] dagArray) {
        super(n);
        this.setChildren(dagArray);
    }

    public void setChildren(Dag[] dagArray) {
        this.theDags = dagArray;
    }

    public void setDags(Dag[] dagArray) {
        this.setChildren(dagArray);
    }

    public Dag[] getChildrenAsArray() {
        Dag[] dagArray = this.theDags;
        int n = this.theDags.length;
        return dagArray;
    }

    public void setData(Object object) {
    }

    public String getData() {
        return null;
    }

    public int computeHashCode() {
        int n = 0;
        if (this.theDags != null) {
            for (int i = 0; i < this.theDags.length; ++i) {
                if (this.theDags[i] == null) continue;
                n ^= this.theDags[i].hashCode();
            }
        }
        return n;
    }

    public void dispose() {
        if (this.theDags != null) {
            for (int i = 0; i < this.theDags.length; ++i) {
                if (this.theDags[i] == null) continue;
                this.theDags[i].dispose();
            }
        }
        this.theDags = null;
    }

    public Dag copy() {
        Dag[] dagArray = new Dag[this.theDags.length];
        System.arraycopy(this.theDags, 0, dagArray, 0, dagArray.length);
        return new BranchDag(this.theType, dagArray);
    }

    public Dag deepCopy() {
        Dag[] dagArray = new Dag[this.theDags.length];
        for (int i = 0; i < dagArray.length; ++i) {
            if (this.theDags[i] == null) continue;
            dagArray[i] = this.theDags[i].deepCopy();
        }
        return new BranchDag(this.theType, dagArray);
    }

    public void insertChild(int n, Dag dag) {
        this.theDags = this.theDags == null ? (this.theDags = new Dag[1]) : this.theDags;
        this.rangeCheck(n);
        Dag[] dagArray = new Dag[this.getLength() + 1];
        dagArray[n] = dag;
        System.arraycopy(this.theDags, 0, dagArray, 0, n);
        System.arraycopy(this.theDags, n, dagArray, n + 1, this.theDags.length - n);
        this.theDags = dagArray;
    }

    public void insertChildren(int n, Dag[] dagArray) {
        this.theDags = this.theDags == null ? (this.theDags = new Dag[1]) : this.theDags;
        this.rangeCheck(n);
        if (dagArray[0] == null) {
            throw new NullPointerException("children argument to insertChildrencannot contain null dags.");
        }
        Dag[] dagArray2 = new Dag[this.getLength() + dagArray.length];
        System.arraycopy(this.theDags, 0, dagArray2, 0, n);
        System.arraycopy(dagArray, 0, dagArray2, n, dagArray.length);
        System.arraycopy(this.theDags, n, dagArray2, n + dagArray.length + 1, this.theDags.length - n);
        this.theDags = dagArray2;
    }

    public void replaceChildren(int n, int n2, Dag dag) {
        this.rangeModifyChildren(n, n2, null);
        this.insertChild(n, dag);
    }

    public void replaceChildren(int n, int n2, Dag[] dagArray) {
        this.rangeModifyChildren(n, n2, dagArray);
    }

    public void removeChild(int n) {
        this.rangeCheck(n);
        Dag[] dagArray = new Dag[this.theDags.length - 1];
        System.arraycopy(this.theDags, 0, dagArray, 0, n);
        System.arraycopy(this.theDags, n + 1, dagArray, n, dagArray.length - n);
        this.theDags = dagArray;
    }

    private void rangeModifyChildren(int n, int n2, Dag[] dagArray) {
        int n3;
        if (n2 < n) {
            throw new IndexOutOfBoundsException("End Argument (" + n2 + ") less then start (" + n + ") in removeChildren.");
        }
        this.rangeCheck(n);
        this.rangeCheck(n2);
        Dag[] dagArray2 = null;
        int n4 = 0;
        if (dagArray == null) {
            dagArray2 = new Dag[this.theDags.length - (n2 - n) - 1];
        } else {
            n4 = dagArray.length;
            dagArray2 = new Dag[this.theDags.length - (n2 - n) - 1 + n4];
        }
        System.arraycopy(this.theDags, 0, dagArray2, 0, n);
        if (dagArray != null) {
            System.arraycopy(dagArray, 0, dagArray2, n, n4);
        }
        n3 = (n3 = this.theDags.length - (n2 - n) - n - 1) < 0 ? 0 : n3;
        n4 = dagArray == null ? 0 : n4;
        System.arraycopy(this.theDags, n2 + 1, dagArray2, n + n4, n3);
        this.theDags = dagArray2;
    }

    public int getLength() {
        int n = this.theDags == null ? 0 : this.theDags.length;
        return n;
    }

    public void setLength(int n) {
        this.theDags = new Dag[n];
    }

    public void setChild(int n, Dag dag) {
        this.rangeCheck(n);
        this.theDags[n] = dag;
    }

    public Dag getChild(int n) {
        this.rangeCheck(n);
        return this.theDags[n];
    }

    private void rangeCheck(int n) {
        if (n < 0 || n > this.getLength()) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.getLength());
        }
    }
}

