/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ExpseqDagFactory;
import com.maplesoft.client.dag.NameDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.ProcLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.AbsTemplate;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.CompositionTemplate;
import com.maplesoft.client.prettyprinter.template.ConjugateTemplate;
import com.maplesoft.client.prettyprinter.template.CurlTemplate;
import com.maplesoft.client.prettyprinter.template.DiffTemplate;
import com.maplesoft.client.prettyprinter.template.DivergenceTemplate;
import com.maplesoft.client.prettyprinter.template.EvalTemplate;
import com.maplesoft.client.prettyprinter.template.ExpTemplate;
import com.maplesoft.client.prettyprinter.template.FactorialTemplate;
import com.maplesoft.client.prettyprinter.template.FloatTemplate;
import com.maplesoft.client.prettyprinter.template.GradientTemplate;
import com.maplesoft.client.prettyprinter.template.InfixNotationTemplate;
import com.maplesoft.client.prettyprinter.template.IntegralTemplate;
import com.maplesoft.client.prettyprinter.template.LimitTemplate;
import com.maplesoft.client.prettyprinter.template.LowerCaseTemplate;
import com.maplesoft.client.prettyprinter.template.MatrixTemplate;
import com.maplesoft.client.prettyprinter.template.ModpTemplate;
import com.maplesoft.client.prettyprinter.template.NeutralOpInfixTemplate;
import com.maplesoft.client.prettyprinter.template.PiecewiseTemplate;
import com.maplesoft.client.prettyprinter.template.ProductTemplate;
import com.maplesoft.client.prettyprinter.template.RootTemplate;
import com.maplesoft.client.prettyprinter.template.RtableTemplate;
import com.maplesoft.client.prettyprinter.template.SeriesTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;
import com.maplesoft.client.prettyprinter.template.SumTemplate;
import com.maplesoft.client.prettyprinter.template.TypesettingTemplate;
import com.maplesoft.client.prettyprinter.template.UnitTemplate;
import com.maplesoft.client.prettyprinter.template.VectorShorthandTemplate;
import com.maplesoft.client.prettyprinter.template.VectorTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class FunctionDagFactory
extends AbstractDagFactory {
    private static HashMap inlineableFunctions = new HashMap();
    private static HashMap translatedInlineFunctions;
    private static HashMap precTable;
    private static HashMap specialFunctionMap;
    static HashMap precedenceMap;
    public static ArrayList KEYWORDS;
    static final SelectionData FUNCTION_SELECTION_DATA;
    static HashSet updatedTemplate;

    private static void fillSpecialFunctionMap() {
        specialFunctionMap = new HashMap();
        specialFunctionMap.put("$", new InfixNotationTemplate(" $ ", 114, 2, 2, 2, 2.0, 0.0));
        specialFunctionMap.put("@", new InfixNotationTemplate("@", 112, 2, 2, Integer.MAX_VALUE, 3.0, 2.0));
        specialFunctionMap.put("@@", new CompositionTemplate());
        specialFunctionMap.put(".", new InfixNotationTemplate(" . ", 120, 1, 2, Integer.MAX_VALUE, 1.0, 1.0));
        specialFunctionMap.put("<,>", new VectorShorthandTemplate(14));
        specialFunctionMap.put("<|>", new VectorShorthandTemplate(15));
        specialFunctionMap.put("`<,>`", new VectorShorthandTemplate(14));
        specialFunctionMap.put("`<|>`", new VectorShorthandTemplate(15));
        specialFunctionMap.put("abs", new AbsTemplate());
        specialFunctionMap.put("conjugate", new ConjugateTemplate());
        specialFunctionMap.put("diff", new DiffTemplate());
        specialFunctionMap.put("Diff", new DiffTemplate());
        specialFunctionMap.put("eval", new EvalTemplate());
        specialFunctionMap.put("Eval", new EvalTemplate());
        specialFunctionMap.put("exp", new ExpTemplate());
        specialFunctionMap.put("Float", new FloatTemplate());
        specialFunctionMap.put("factorial", new FactorialTemplate());
        specialFunctionMap.put("in", new InfixNotationTemplate(" in ", 81, 6, 2, 2, 2.0, 0.0, true));
        specialFunctionMap.put("int", new IntegralTemplate());
        specialFunctionMap.put("Int", new IntegralTemplate());
        specialFunctionMap.put("intersect", new InfixNotationTemplate(" intersect ", 78, 2, 2, 2, 2.0, 0.0));
        specialFunctionMap.put("limit", new LimitTemplate());
        specialFunctionMap.put("TABLE", new LowerCaseTemplate());
        specialFunctionMap.put("Limit", new LimitTemplate());
        specialFunctionMap.put("matrix", new MatrixTemplate());
        specialFunctionMap.put("Matrix", new MatrixTemplate());
        specialFunctionMap.put("MATRIX", new MatrixTemplate());
        specialFunctionMap.put("mod", new InfixNotationTemplate(" mod ", 115, 2, 2, 2));
        specialFunctionMap.put("PIECEWISE", new PiecewiseTemplate());
        specialFunctionMap.put("product", new ProductTemplate());
        specialFunctionMap.put("minus", new InfixNotationTemplate(" minus ", 109, 2, 2, Integer.MAX_VALUE, 3.0, 2.0));
        specialFunctionMap.put("product", new ProductTemplate());
        specialFunctionMap.put("Product", new ProductTemplate());
        specialFunctionMap.put("RTABLE", new RtableTemplate());
        specialFunctionMap.put("subset", new InfixNotationTemplate(" subset ", 79, 2, 2, 2));
        specialFunctionMap.put("sqrt", new RootTemplate());
        specialFunctionMap.put("sum", new SumTemplate());
        specialFunctionMap.put("Sum", new SumTemplate());
        specialFunctionMap.put("union", new InfixNotationTemplate(" union ", 77, 2, 2, 2, 2.0, 0.0));
        specialFunctionMap.put("Unit", new UnitTemplate());
        specialFunctionMap.put("VECTOR", new VectorTemplate());
        specialFunctionMap.put("vector", new VectorTemplate());
        specialFunctionMap.put("Gradient", new GradientTemplate());
        specialFunctionMap.put("Curl", new CurlTemplate());
        specialFunctionMap.put("Divergence", new DivergenceTemplate());
        specialFunctionMap.put("_SERIES", new SeriesTemplate());
        specialFunctionMap.put("modp1", new ModpTemplate());
        specialFunctionMap.put("modp2", new ModpTemplate());
        TypesettingTemplate typesettingTemplate = new TypesettingTemplate();
        specialFunctionMap.put("Typesetting:-mfrac", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mi", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mmultiscripts", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mscripts", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mn", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mo", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mover", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mambiguous", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-maction", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mroot", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mrow", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mspace", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-msqrt", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-ms", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mstyle", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-msub", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-msubsup", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-msup", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mtext", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-merror", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-munder", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mphantom", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-munderover", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mprescripts", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-none", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mfenced", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mtable", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mtr", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mtd", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mprintslash", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mparsed", typesettingTemplate);
        specialFunctionMap.put("Typesetting:-mverbatim", typesettingTemplate);
    }

    public static SpecialFunctionTemplate getSpecialFunction(String string) {
        if (specialFunctionMap == null) {
            FunctionDagFactory.fillSpecialFunctionMap();
        }
        return (SpecialFunctionTemplate)specialFunctionMap.get(string);
    }

    public static Dag createFunctionDag(String string, Dag[] dagArray) {
        Dag dag = ExpseqDagFactory.createExpseqDag(dagArray);
        Dag dag2 = NameDagFactory.createNameDag(string);
        Dag[] dagArray2 = new Dag[]{dag2, dag};
        return Dag.createDag(18, dagArray2, null, false);
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 18, 3);
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 18, false);
    }

    private void prefixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        if (dag2.getType() == 8) {
            if (dag2.getData().equals("RTABLE") && (dag3.getLength() == 3 || wmiLPrintOptions.isLPrintRTableIDForm())) {
                this.lPrintRtable(stringBuffer, dag3, wmiLPrintOptions);
                return;
            }
            String string = dag2.getData();
            if (!(!KEYWORDS.contains(string) || string.startsWith("'") && string.endsWith("'"))) {
                StringBuffer stringBuffer2 = new StringBuffer("`");
                stringBuffer2.append(string);
                stringBuffer2.append("`");
                stringBuffer.append(stringBuffer2);
            } else {
                DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            }
        } else if (dag2.getType() == 10 || dag2.getType() == 9) {
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
        } else if (dag.getType() == 18) {
            stringBuffer.append("(");
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(")");
        } else {
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
        }
        stringBuffer.append("(");
        DagBuilder.linePrint(stringBuffer, dag3, wmiLPrintOptions);
        stringBuffer.append(")");
    }

    private void infixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        Dag dag4 = dag3.getChild(0);
        Dag dag5 = dag3.getChild(1);
        String string = dag2.getData();
        boolean bl = false;
        if (DagBuilder.getPrecedence(dag4, wmiLPrintOptions) > this.getPrecedence(dag, wmiLPrintOptions) || string.equals("^") && DagBuilder.getPrecedence(dag4, wmiLPrintOptions) == this.getPrecedence(dag, wmiLPrintOptions)) {
            stringBuffer.append("(");
            bl = true;
        }
        DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
        if (bl) {
            stringBuffer.append(")");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        DagBuilder.linePrint(stringBuffer2, dag5, wmiLPrintOptions);
        if (string.equals("+") && stringBuffer2.charAt(0) == '-') {
            stringBuffer.append(stringBuffer2);
        } else {
            String string2 = (String)translatedInlineFunctions.get(string);
            if (string2 != null) {
                string = string2;
            }
            stringBuffer.append(string);
            bl = false;
            if (DagBuilder.getPrecedence(dag5, wmiLPrintOptions) > this.getPrecedence(dag, wmiLPrintOptions) || string.equals("^") && DagBuilder.getPrecedence(dag5, wmiLPrintOptions) == this.getPrecedence(dag, wmiLPrintOptions)) {
                stringBuffer.append("(");
                bl = true;
            }
            stringBuffer.append(stringBuffer2);
            if (bl) {
                stringBuffer.append(")");
            }
        }
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2 = dag.getChild(0);
        String string = dag2.getData();
        Dag dag3 = dag.getChild(1);
        boolean bl = false;
        if (wmiLPrintOptions.isInLineIfPossible() && inlineableFunctions.containsKey(string)) {
            if (dag3.getLength() == 2) {
                this.infixLinePrint(stringBuffer, dag, wmiLPrintOptions);
                bl = true;
            } else if ("/".equals(string) && dag3.getLength() == 1) {
                boolean bl2;
                stringBuffer.append("1/");
                Dag dag4 = dag3.getChild(0);
                boolean bl3 = bl2 = DagBuilder.getPrecedence(dag4, wmiLPrintOptions) >= 4;
                if (bl2) {
                    stringBuffer.append("(");
                }
                DagBuilder.linePrint(stringBuffer, dag4, wmiLPrintOptions);
                if (bl2) {
                    stringBuffer.append(")");
                }
                bl = true;
            }
        }
        if (!bl) {
            this.prefixLinePrint(stringBuffer, dag, wmiLPrintOptions);
        }
    }

    private void lPrintRtable(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        DagBuilder.linePrint(stringBuffer, dag.getChild(2), wmiLPrintOptions);
        stringBuffer.append("(");
        DagBuilder.linePrint(stringBuffer, dag.getChild(1).getChild(1), wmiLPrintOptions);
        stringBuffer.append(")");
    }

    public int getPrecedence(Dag dag) {
        return 2;
    }

    public int getPrecedence(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Integer n;
        int n2 = 2;
        Dag dag2 = dag.getChild(0);
        String string = dag2.getData();
        if (wmiLPrintOptions.isInLineIfPossible() && inlineableFunctions.containsKey(string) && (n = (Integer)inlineableFunctions.get(string)) != null) {
            n2 = n;
        }
        if (precTable.containsKey(string) && (n = (Integer)precTable.get(string)) != null) {
            n2 = n;
        }
        return n2;
    }

    public int getPrecedence(Dag dag, LayoutFormatter layoutFormatter) {
        int n;
        int n2 = 2;
        if (dag != null && dag.getType() == 18 && (n = dag.getLength()) == 2) {
            Dag dag2;
            String string = dag.getChild(0).getData();
            Integer n3 = (Integer)precedenceMap.get(string);
            if (n3 != null) {
                n2 = n3;
            } else if (string != null && string.startsWith("&") && (dag2 = dag.getChild(1)) != null && dag2.getLength() == 2) {
                n2 = FunctionDagFactory.getNeutralOperatorPrecedence(string);
            }
        }
        return n2;
    }

    public static int getNeutralOperatorPrecedence(String string) {
        return string.equals("&*") ? 5 : 2;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        LayoutBox layoutBox = null;
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        layoutFormatter.setIsFunctionName(true);
        LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dag2);
        if (layoutBox2.getSelectionData() == null) {
            layoutBox2.setSelectionData(FUNCTION_SELECTION_DATA);
        }
        if (layoutBox2 instanceof ProcLayoutBox) {
            layoutBox2 = BracketTemplate.apply(layoutFormatter, layoutBox2, dag2, -1);
            layoutBox2.setLineBreaker(LineBreakerFactory.newLineBreaker((int)1));
        } else {
            layoutBox2.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
        }
        if (dag3 != null) {
            String string = layoutBox2.getData();
            SpecialFunctionTemplate specialFunctionTemplate = FunctionDagFactory.getSpecialFunction(string);
            if (dag2.getData() != null && dag2.getData().startsWith("&") && dag3.getLength() == 2) {
                layoutBox = NeutralOpInfixTemplate.apply(layoutFormatter, dag2, dag3);
            } else if (specialFunctionTemplate != null && !layoutFormatter.useInLine(dag)) {
                if (specialFunctionTemplate instanceof VectorShorthandTemplate) {
                    int n = updatedTemplate.contains(string) ? 0 : 1;
                    Dag[] dagArray = this.normalizeArguments(dag3, n);
                    layoutBox = specialFunctionTemplate.apply(layoutFormatter, dag, dagArray);
                } else if (!layoutFormatter.isInProc()) {
                    int n = updatedTemplate.contains(string) ? 0 : 1;
                    Dag[] dagArray = this.normalizeArguments(dag3, n);
                    layoutBox = specialFunctionTemplate.apply(layoutFormatter, dag, dagArray);
                } else {
                    layoutBox = null;
                }
                if (layoutBox != null && (specialFunctionTemplate instanceof MatrixTemplate || specialFunctionTemplate instanceof VectorTemplate || specialFunctionTemplate instanceof RtableTemplate)) {
                    layoutBox.setAllDags(dag);
                } else if (layoutBox != null) {
                    layoutBox.setDag(dag);
                }
            } else {
                layoutBox = null;
            }
        }
        if (layoutBox == null) {
            layoutBox = FunctionDagFactory.createGenericLayout(layoutFormatter, dag);
        }
        return layoutBox;
    }

    public static LayoutBox createGenericLayout(LayoutFormatter layoutFormatter, Dag dag) {
        Dag dag2 = dag.getChild(0);
        LayoutBox layoutBox = DagBuilder.createLayout(layoutFormatter, dag2);
        LayoutBox layoutBox2 = FunctionDagFactory.createGenericLayout(layoutFormatter, layoutBox, dag);
        return layoutBox2;
    }

    public static LayoutBox createGenericLayout(LayoutFormatter layoutFormatter, LayoutBox layoutBox, Dag dag) {
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(DagBuilder.ELEMENT_NAME[dag.getType()], 2);
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        LayoutBox layoutBox2 = DagBuilder.createLayout(layoutFormatter, dag3);
        layoutBox2 = BracketTemplate.apply(layoutFormatter, layoutBox2, dag3, -1);
        layoutBox2.setDag(dag3);
        if (layoutBox.getSelectionData() == null) {
            layoutBox.setSelectionData(FUNCTION_SELECTION_DATA);
        }
        if (layoutBox instanceof ProcLayoutBox) {
            layoutBox = BracketTemplate.apply(layoutFormatter, layoutBox, dag2, -1);
            layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)1));
        } else if (dag2 instanceof BranchDag) {
            layoutBox = BracketTemplate.apply(layoutFormatter, layoutBox, dag2, 2);
            layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)1));
        } else {
            layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)8));
        }
        inlineLayoutBox.addChild(layoutBox);
        inlineLayoutBox.addChild(layoutBox2);
        inlineLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)11));
        return inlineLayoutBox;
    }

    Dag[] normalizeArguments(Dag dag, int n) {
        int n2 = dag.getLength();
        Dag[] dagArray = new Dag[n2 + n];
        for (int i = 0; i < n2; ++i) {
            Dag dag2 = dag.getChild(i);
            int n3 = dag2.getType();
            if (n3 == 32 || n3 == 33 || n3 == 31) {
                int n4 = 0;
                try {
                    Dag dag3 = dag2.getChild(0);
                    n4 = Integer.parseInt(dag3.getData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 == 32) {
                    dagArray[i + n] = ProcDagFactory.getParameter(n4);
                    continue;
                }
                if (n3 == 33) {
                    dagArray[i + n] = ProcDagFactory.getLexical(n4);
                    continue;
                }
                if (n3 != 31) continue;
                dagArray[i + n] = ProcDagFactory.getLocal(n4);
                continue;
            }
            dagArray[i + n] = dag2;
        }
        return dagArray;
    }

    static {
        inlineableFunctions.put("+", new Integer(6));
        inlineableFunctions.put("*", new Integer(4));
        inlineableFunctions.put("^", new Integer(3));
        inlineableFunctions.put("/", new Integer(4));
        inlineableFunctions.put("@@", new Integer(2));
        inlineableFunctions.put(">", new Integer(12));
        inlineableFunctions.put(">=", new Integer(12));
        inlineableFunctions.put("<", new Integer(12));
        inlineableFunctions.put("<=", new Integer(12));
        translatedInlineFunctions = new HashMap();
        translatedInlineFunctions.put(">", " > ");
        translatedInlineFunctions.put(">=", " >= ");
        translatedInlineFunctions.put("<", " < ");
        translatedInlineFunctions.put("<=", " <= ");
        precTable = new HashMap();
        precTable.put("exp", new Integer(3));
        precTable.put("limit", new Integer(4));
        precTable.put("Limit", new Integer(4));
        precTable.put("sum", new Integer(6));
        precTable.put("Sum", new Integer(6));
        precTable.put("product", new Integer(4));
        precTable.put("Product", new Integer(4));
        precTable.put("&*", new Integer(5));
        specialFunctionMap = null;
        precedenceMap = new HashMap();
        KEYWORDS = new ArrayList(50);
        FUNCTION_SELECTION_DATA = new StandardSelectionData(2);
        updatedTemplate = new HashSet();
        precedenceMap.put("PIECEWISE", new Integer(9));
        precedenceMap.put("in", new Integer(12));
        precedenceMap.put("intersect", new Integer(4));
        precedenceMap.put("minus", new Integer(6));
        precedenceMap.put("mod", new Integer(7));
        precedenceMap.put("subset", new Integer(8));
        precedenceMap.put("union", new Integer(6));
        precedenceMap.put("eval", new Integer(6));
        precedenceMap.put("Eval", new Integer(6));
        precedenceMap.put("int", new Integer(3));
        precedenceMap.put("Int", new Integer(3));
        precedenceMap.put("limit", new Integer(6));
        precedenceMap.put("Limit", new Integer(6));
        precedenceMap.put("product", new Integer(6));
        precedenceMap.put("Product", new Integer(6));
        precedenceMap.put("sum", new Integer(6));
        precedenceMap.put("Sum", new Integer(6));
        precedenceMap.put("diff", new Integer(6));
        precedenceMap.put("Diff", new Integer(6));
        precedenceMap.put("Gradient", new Integer(6));
        precedenceMap.put("Curl", new Integer(6));
        precedenceMap.put("Divergence", new Integer(6));
        precedenceMap.put(".", new Integer(4));
        precedenceMap.put("exp", new Integer(3));
        precedenceMap.put("_SERIES", new Integer(6));
        precedenceMap.put("@", new Integer(4));
        precedenceMap.put("$", new Integer(13));
        precedenceMap.put("&plusmn;", new Integer(6));
        String[] stringArray = new String[]{"$", "@", "@@", "and", "assuming", "break", "by", "catch", "desription", "do", "done", "elif", "else", "end", "error", "export", "fi", "finally", "for", "from", "global", "if", "implies", "in", "intersect", "local", "minus", "mod", "module", "next", "not", "od", "option", "options", "or", "proc", "quit", "read", "return", "save", "stop", "subset", "then", "to", "try", "union", "use", "while", "xor"};
        for (int i = 0; i < stringArray.length; ++i) {
            KEYWORDS.add(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Unit", "sum", "Sum", "product", "Product", "_SERIES", "VECTOR", "vector", "MATRIX", "Matrix", "matrix", "RTABLE", "sqrt", "PIECEWISE", "modp1", "modp2", "Limit", "limit", "int", "Int", "$", "@", ".", "in", "intersect", "mod", "minus", "subset", "union", "Gradient", "Float", "factorial", "exp", "eval", "Eval", "Divergence", "Curl", "diff", "Diff", "conjugate", "@@", "abs", "<|>", "<,>", "`<|>`", "`<,>`", "Typesetting:-mfrac", "Typesetting:-mi", "Typesetting:-mmultiscripts", "Typesetting:-mscripts", "Typesetting:-mn", "Typesetting:-mo", "Typesetting:-mover", "Typesetting:-mambiguous", "Typesetting:-maction", "Typesetting:-mroot", "Typesetting:-mrow", "Typesetting:-mspace", "Typesetting:-msqrt", "Typesetting:-ms", "Typesetting:-mstyle", "Typesetting:-msub", "Typesetting:-msubsup", "Typesetting:-msup", "Typesetting:-mtext", "Typesetting:-merror", "Typesetting:-munder", "Typesetting:-mphantom", "Typesetting:-munderover", "Typesetting:-mprescripts", "Typesetting:-none", "Typesetting:-mfenced", "Typesetting:-mtable", "Typesetting:-mtr", "Typesetting:-mtd", "Typesetting:-mprintslash", "Typesetting:-mparsed", "Typesetting:-mverbatim"};
        for (int i = 0; i < stringArray2.length; ++i) {
            updatedTemplate.add(stringArray2[i]);
        }
    }
}

