/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.HashDag;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class HashTableDagFactory
extends AbstractBinopDagFactory {
    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        int n = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        int n2 = this.isVariableLength() ? DagBuilder.parseShortInteger(wmiByteArrayInputStream) : 3;
        return this.readDotm(wmiByteArrayInputStream, this.getType(), 2 * n2 + 1, n);
    }

    protected Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        if (n != 57 && n != 56) {
            n4 = DagBuilder.dagCountPlus();
        }
        HashDag hashDag = new HashDag(n);
        hashDag.setSize(n3);
        Dag[] dagArray = new Dag[--n2];
        for (int i = 0; i < n2; ++i) {
            dagArray[i] = DagBuilder.create(wmiByteArrayInputStream);
        }
        hashDag.setChildren(dagArray);
        if (n != 57 && n != 56) {
            DagBuilder.putDag(hashDag, n4);
        }
        return hashDag;
    }

    protected void writeDotm(StringBuffer stringBuffer, Dag dag, int n, boolean bl) {
        HashDag hashDag = (HashDag)dag;
        int n2 = HashTableDagFactory.isABackref(hashDag, n);
        if (n2 > 0) {
            this.writeBackref(stringBuffer, n2);
            return;
        }
        char c = (char)(MapleNumbers.dotMOutputTable[n] + 33 - 1);
        stringBuffer.append(c);
        DagBuilder.writeShortInteger(stringBuffer, hashDag.getSize());
        int n3 = hashDag.getLength();
        if (n3 > 0) {
            if (bl) {
                DagBuilder.writeShortInteger(stringBuffer, n3 / 2);
            }
            for (int i = 0; i < n3; ++i) {
                DagBuilder.writeDotm(stringBuffer, hashDag.getChild(i));
            }
        } else {
            DagBuilder.writeShortInteger(stringBuffer, 0);
        }
    }

    public int getType() {
        return 55;
    }

    public String getStringOperator(WmiLPrintOptions wmiLPrintOptions) {
        return ", ";
    }

    public NotationLayoutBox createNotationBox(LayoutFormatter layoutFormatter) {
        return NotationLayoutBox.createNotationBox(layoutFormatter, 14);
    }

    public boolean isVariableLength() {
        return true;
    }

    public int getPrecedence() {
        return 12;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        stringBuffer.append("table( [");
        for (int i = 0; i < n; i += 2) {
            stringBuffer.append("( ");
            DagBuilder.linePrint(stringBuffer, dag.getChild(i), wmiLPrintOptions);
            stringBuffer.append(" ) = ");
            DagBuilder.linePrint(stringBuffer, dag.getChild(i + 1), wmiLPrintOptions);
            if (i >= n - 2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" ] )");
    }
}

