/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractCommandDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class IfDagFactory
extends AbstractCommandDagFactory {
    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 43, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 43, true);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        boolean bl = this.isEven(n);
        stringBuffer.append("if ");
        DagBuilder.linePrint(stringBuffer, dag.getChild(0), wmiLPrintOptions);
        stringBuffer.append(" then ");
        DagBuilder.linePrint(stringBuffer, dag.getChild(1), wmiLPrintOptions);
        for (int i = 2; i < n - 1; i += 2) {
            stringBuffer.append(" elif ");
            DagBuilder.linePrint(stringBuffer, dag.getChild(i), wmiLPrintOptions);
            stringBuffer.append(" then ");
            DagBuilder.linePrint(stringBuffer, dag.getChild(i + 1), wmiLPrintOptions);
        }
        if (!bl) {
            stringBuffer.append(" else ");
            DagBuilder.linePrint(stringBuffer, dag.getChild(n - 1), wmiLPrintOptions);
        }
        stringBuffer.append(" end if");
    }

    public boolean isEven(int n) {
        return (n & 1) == 0;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        int n = dag.getLength();
        boolean bl = this.isEven(n);
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(5 + (n - 1 + (n - 1) / 2));
        inlineLayoutBox.addChild(this.layout_if_then(layoutFormatter, dag.getChild(0)));
        inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
        inlineLayoutBox.addChild(this.layout_statement(layoutFormatter, dag.getChild(1)));
        for (int i = 2; i < n - 1; i += 2) {
            ProcTemplate.addNeededDelimiter(layoutFormatter, inlineLayoutBox);
            inlineLayoutBox.addChild(this.layout_if_then(layoutFormatter, dag.getChild(i), 40));
            inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
            inlineLayoutBox.addChild(this.layout_statement(layoutFormatter, dag.getChild(i + 1)));
        }
        if (!bl) {
            InlineLayoutBox inlineLayoutBox2 = new InlineLayoutBox(1);
            inlineLayoutBox2.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 41));
            ProcTemplate.addNeededDelimiter(layoutFormatter, inlineLayoutBox);
            inlineLayoutBox.addChild(inlineLayoutBox2);
            inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
            inlineLayoutBox.addChild(this.layout_statement(layoutFormatter, dag.getChild(n - 1)));
        }
        ProcTemplate.addNeededDelimiter(layoutFormatter, inlineLayoutBox);
        inlineLayoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, longForm ? 69 : 42));
        inlineLayoutBox.addChild(ProcTemplate.createSemiColon(layoutFormatter));
        inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
        inlineLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)16));
        return inlineLayoutBox;
    }

    private LayoutBox layout_if_then(LayoutFormatter layoutFormatter, Dag dag) {
        return this.layout_if_then(layoutFormatter, dag, 38);
    }

    private LayoutBox layout_if_then(LayoutFormatter layoutFormatter, Dag dag, int n) {
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(5);
        inlineLayoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, n));
        inlineLayoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, " "));
        inlineLayoutBox.addChild(DagBuilder.createLayout(layoutFormatter, dag));
        inlineLayoutBox.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, " "));
        inlineLayoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 39));
        inlineLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)17));
        return inlineLayoutBox;
    }

    private LayoutBox layout_statement(LayoutFormatter layoutFormatter, Dag dag) {
        return ProcTemplate.layoutStatement(layoutFormatter, dag);
    }
}

