/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractElisionDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class IntDagFactory
extends AbstractElisionDagFactory {
    private int type;
    private String number;
    private static SelectionData sd = null;

    protected IntDagFactory(int n) {
        this.type = n;
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        int n = DagBuilder.dagCountPlus();
        int n2 = DagBuilder.parseShortInteger(wmiByteArrayInputStream);
        this.number = DagBuilder.parseDigits(wmiByteArrayInputStream, n2);
        Dag dag = Dag.createDag(this.type, null, this.number, false);
        DagBuilder.putDag(dag, n);
        return dag;
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        char c = '\u0000';
        int n = IntDagFactory.isABackref(dag, this.type);
        if (n > 0) {
            this.writeBackref(stringBuffer, n);
            return;
        }
        c = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
        stringBuffer.append(c);
        String string = dag.getData();
        DagBuilder.writeShortInteger(stringBuffer, string.length());
        DagBuilder.writeDigits(stringBuffer, string, string.length());
    }

    protected String getElisionThresholdProperty() {
        return "elisiondigitsthreshold";
    }

    protected String getElisionAfterProperty() {
        return "elisiondigitsafter";
    }

    protected String getElisionBeforeProperty() {
        return "elisiondigitsbefore";
    }

    protected int getDefaultElideThreshold() {
        return 10000;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        dag.getType();
        String string = this.type == 2 ? dag.getData() : DagBuilder.lPrint(dag);
        int n = string.length();
        if (n > this.elideThreshold && n > this.leftSample + this.rightSample && this.leftSample + this.rightSample > 0 && this.leftSample < Integer.MAX_VALUE && this.rightSample < Integer.MAX_VALUE && this.rightSample > 0 && this.leftSample > 0) {
            int n2 = n - this.leftSample - this.rightSample;
            String string2 = n2 > 1 ? " digits...]" : " digit...]";
            String string3 = "[..." + n2 + string2;
            string = string.substring(0, this.leftSample) + string3 + string.substring(n - this.rightSample, n);
        }
        NotationLayoutBox notationLayoutBox = layoutFormatter.createNotationBox(this.type, string, 4);
        notationLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)4));
        if (sd == null) {
            sd = new StandardSelectionData(2);
            sd.setContextHelpAvailable(false);
        }
        notationLayoutBox.setSelectionData(sd);
        return notationLayoutBox;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        if (this.type == 1) {
            stringBuffer.append("-");
        }
        stringBuffer.append(dag.getData());
    }
}

