/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ModdefDagFactory
extends AbstractDagFactory {
    public static final int MODDEF_LENGTH = 10;
    public static final int PARAM_INDEX = 0;
    public static final int LOCAL_INDEX = 1;
    public static final int OPTION_INDEX = 2;
    public static final int EXPORT_INDEX = 3;
    public static final int STATSEQ_INDEX = 4;
    public static final int DESCRIPTION_INDEX = 5;
    public static final int GLOBAL_INDEX = 6;
    public static final int LEXICAL_INDEX = 7;
    public static final int NAME_INDEX = 8;

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 39, 10);
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 39, false);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        String string = " ";
        stringBuffer.append("module ");
        Dag dag2 = dag.getChild(8);
        if (ModdefDagFactory.calculateLength(dag2) > 0) {
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(string);
        }
        stringBuffer.append("(");
        stringBuffer.append(") ");
        dag2 = dag.getChild(5);
        if (!DagUtil.isNull(dag2) && dag2.getLength() > 0) {
            stringBuffer.append("description ");
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(";" + string);
        }
        if ((dag2 = dag.getChild(1)).getLength() > 0) {
            stringBuffer.append("local ");
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append("; ");
        }
        if ((dag2 = dag.getChild(3)).getLength() > 0) {
            stringBuffer.append("export ");
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(";");
            stringBuffer.append(string);
        }
        if ((dag2 = dag.getChild(6)).getLength() > 0) {
            stringBuffer.append("global ");
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(";" + string);
        }
        if ((dag2 = dag.getChild(2)).getLength() > 0) {
            stringBuffer.append("option ");
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(";");
            stringBuffer.append(string);
        }
        ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
        dag2 = dag.getChild(4);
        if (dag2.getLength() > 0) {
            stringBuffer.append(" ");
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            stringBuffer.append(" ");
        }
        stringBuffer.append("end module");
        ProcDagFactory.removeStacks();
    }

    public static int calculateLength(Dag dag) {
        int n = 1;
        if (dag.getData() != null) {
            n = dag.getData().startsWith("_m") ? 0 : dag.getData().length();
        } else {
            n = dag.getLength();
            if (n > 0) {
                ++n;
            }
        }
        return n;
    }

    public int getPrecedence() {
        return 1;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        String string = DagBuilder.lPrint(dag, new WmiLPrintOptions());
        NotationLayoutBox notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, string);
        return notationLayoutBox;
    }
}

