/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.dag.PowerDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class SeriesDagFactory
extends AbstractDagFactory {
    private static final int WHERE_NAME_OFFSET = 0;
    private static final int WHERE_NAME_SIGN_OFFSET = 1;
    private static final int WHERE_VALUE_OFFSET = 2;
    private static final int WHERE_VALUE_SIGN_OFFSET = 3;
    private static final int WHERE_VALUE_SHIFT = 2;

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 15, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 15, true);
    }

    public StringBuffer toMathML(Dag dag) {
        return new StringBuffer();
    }

    private static boolean isOrderFunction(Dag dag) {
        Dag dag2;
        String string;
        int n;
        boolean bl = false;
        if (DagUtil.isFunction(dag) && (n = dag.getLength()) > 0 && (string = (dag2 = dag.getChild(0)).getData()) != null && string.equals("O")) {
            bl = true;
        }
        return bl;
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2 = SeriesDagFactory.createSum(dag);
        stringBuffer.append("series(");
        if (dag2 != null) {
            Dag dag3;
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            int n = dag.getLength();
            Dag dag4 = dag.getChild(0);
            Dag dag5 = SeriesDagFactory.createWhereDag(dag4);
            Dag dag6 = dag3 = SeriesDagFactory.hasOrderFunction(dag) ? dag.getChild(n - 1) : null;
            if (dag3 != null) {
                stringBuffer.append("+O(");
                Dag[] dagArray = new Dag[]{dag4, dag3};
                Dag dag7 = Dag.createDag(13, dagArray, null, false);
                DagBuilder.linePrint(stringBuffer, dag7, wmiLPrintOptions);
                stringBuffer.append(")");
            }
            stringBuffer.append(",");
            DagBuilder.linePrint(stringBuffer, dag5, wmiLPrintOptions);
            if (dag3 != null) {
                stringBuffer.append(",");
                DagBuilder.linePrint(stringBuffer, dag3, wmiLPrintOptions);
            }
        }
        stringBuffer.append(")");
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        Dag dag2;
        LayoutBox layoutBox = null;
        Dag dag3 = dag2 = SeriesDagFactory.createSum(dag);
        if (SeriesDagFactory.hasOrderFunction(dag)) {
            Dag dag4 = dag.getChild(0);
            Dag[] dagArray = new Dag[]{DagBuilder.normalize(dag2), dag4, dag.getChild(dag.getLength() - 1)};
            dag3 = FunctionDagFactory.createFunctionDag("_SERIES", dagArray);
        }
        layoutBox = DagBuilder.createLayout(layoutFormatter, dag3);
        return layoutBox;
    }

    public static Dag createWhereDag(Dag dag) {
        Dag dag2 = null;
        int n = dag.getType();
        if (n == 16) {
            Dag dag3 = dag.getChild(0);
            dag.getChild(1);
            Dag[] dagArray = new Dag[2];
            dagArray[0] = dag3;
            if (dag.getLength() == 4) {
                Dag dag4 = dag.getChild(2);
                Dag dag5 = dag.getChild(3);
                if (dag5.equals(DagConstants.ONE)) {
                    Dag[] dagArray2 = new Dag[2];
                    dagArray2[1] = DagConstants.MINUS_ONE;
                    dagArray2[0] = dag4;
                    dagArray[1] = Dag.createDag(16, dagArray2, null, false);
                } else {
                    dagArray[1] = dag4;
                }
            } else {
                int n2 = dag.getLength() - 2;
                Dag[] dagArray3 = new Dag[n2];
                for (int i = 0; i < n2; ++i) {
                    dagArray3[i] = dag.getChild(i + 2);
                }
                Dag dag6 = Dag.createDag(16, dagArray3, null, false);
                dagArray3 = new Dag[]{dag6, DagConstants.MINUS_ONE};
                dagArray[1] = Dag.createDag(16, dagArray3, null, false);
            }
            dag2 = Dag.createDag(20, dagArray, null, false);
        } else {
            dag2 = dag;
        }
        return dag2;
    }

    public static boolean hasOrderFunction(Dag dag) {
        int n;
        boolean bl = false;
        if (dag != null && (n = dag.getLength()) > 0) {
            bl = n > 1 ? SeriesDagFactory.isOrderFunction(dag.getChild(n - 2)) : false;
        }
        return bl;
    }

    public static Dag createSum(Dag dag) {
        Dag dag2 = null;
        try {
            Dag dag3 = DagBuilder.normalize(dag.getChild(0));
            int n = dag.getLength();
            if (SeriesDagFactory.hasOrderFunction(dag)) {
                n -= 2;
            }
            Dag[] dagArray = new Dag[n - 1];
            Dag dag4 = Dag.createDag(16, dagArray, null, false);
            for (int i = 1; i < n; i += 2) {
                SeriesDagFactory.fillTerm(dag, dagArray, dag3, i);
            }
            dag2 = DagBuilder.normalize(dag4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dag2;
    }

    private static void fillTerm(Dag dag, Dag[] dagArray, Dag dag2, int n) {
        Dag dag3 = dag.getChild(n);
        Dag dag4 = dag.getChild(n + 1);
        if (DagUtil.isZero(dag4)) {
            SeriesDagFactory.fillZeroPowerTerm(dag3, dagArray, n);
        } else if (DagUtil.isNumeric(dag3)) {
            if (DagUtil.isOne(dag4)) {
                dagArray[n - 1] = dag2;
                dagArray[n] = dag3;
            } else {
                dagArray[n - 1] = PowerDagFactory.create(dag2, dag4);
                dagArray[n] = dag3;
            }
        } else {
            Dag[] dagArray2 = new Dag[4];
            if (dag3.getType() == 16 && dag3.getLength() == 2) {
                dagArray2[0] = dag3.getChild(0);
                dagArray2[1] = DagConstants.ONE;
                dagArray[n] = dag3.getChild(1);
            } else {
                dagArray2[0] = dag3;
                dagArray2[1] = DagConstants.ONE;
                dagArray[n] = DagConstants.ONE;
            }
            dagArray2[2] = dag2;
            dagArray2[3] = dag4;
            Dag dag5 = Dag.createDag(14, dagArray2, null, false);
            dagArray[n - 1] = DagBuilder.normalize(dag5);
        }
    }

    private static void fillZeroPowerTerm(Dag dag, Dag[] dagArray, int n) {
        if (DagUtil.isNumeric(dag)) {
            if (DagUtil.isNegative(dag)) {
                dag = DagUtil.negate(dag);
                dagArray[n] = DagConstants.MINUS_ONE;
            } else {
                dagArray[n] = DagConstants.ONE;
            }
            dagArray[n - 1] = dag;
        } else if (dag.getType() == 16 && dag.getLength() == 2) {
            dagArray[n - 1] = dag.getChild(0);
            dagArray[n] = dag.getChild(1);
        } else {
            dagArray[n - 1] = DagBuilder.normalize(dag);
            dagArray[n] = DagConstants.ONE;
        }
    }

    public int getPrecedence() {
        return 10;
    }
}

