/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractElisionDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProdDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.client.prettyprinter.template.UnaryOperationTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class SumDagFactory
extends AbstractElisionDagFactory {
    public static Dag create(Dag dag, int n, Dag dag2, int n2) {
        Dag[] dagArray = new Dag[]{dag, n == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE, dag2, n2 == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE};
        return Dag.createDag(16, dagArray, null, false);
    }

    public static Dag addTerm(Dag dag, int n, Dag dag2) {
        Dag dag3 = DagConstants.MINUS_ONE;
        if (n == 1) {
            dag3 = DagConstants.ONE;
        }
        dag.addChild(dag2);
        dag.addChild(dag3);
        return dag;
    }

    public static Dag sumDagToIntegerDag(Dag dag) {
        Dag dag2 = null;
        int n = dag.getType();
        if (n == 2 || n == 1) {
            dag2 = dag;
        } else if (n == 16 && dag.getLength() == 2) {
            Dag dag3 = dag.getChild(0);
            Dag dag4 = dag.getChild(1);
            try {
                int n2 = Integer.parseInt(dag3.getData());
                int n3 = dag4.getType();
                dag2 = Dag.createDag(n3, null, Integer.toString(n2), false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dag2;
    }

    public static Dag create(Dag[] dagArray) {
        return Dag.createDag(16, dagArray, null, false);
    }

    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 16, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 16, true);
    }

    public int getPrecedence() {
        return 6;
    }

    public int getPrecedence(Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        Dag dag2;
        int n = 6;
        if (dag.getLength() == 2 && !DagUtil.isMinusOne(dag2 = dag.getChild(1))) {
            n = DagUtil.isOne(dag2) ? DagBuilder.getPrecedence(dag.getChild(0), wmiLPrintOptions) : 4;
        }
        return n;
    }

    public StringBuffer toMathML(Dag dag) {
        return new StringBuffer();
    }

    private void prefixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        stringBuffer.append("`+`(");
        for (int i = 0; i < n; i += 2) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            Dag dag2 = dag.getChild(i);
            Dag dag3 = dag.getChild(i + 1);
            if (dag3.getType() == 1) {
                stringBuffer.append("`-`(");
            }
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            if (dag3.getType() != 1) continue;
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
    }

    private void infixLinePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            int n3;
            boolean bl;
            boolean bl2;
            Dag dag2 = dag.getChild(i);
            Dag dag3 = dag.getChild(i + 1);
            boolean bl3 = bl2 = dag3.getType() == 2;
            if (bl2) {
                if (n2 > 0) {
                    stringBuffer.append("+");
                }
            } else {
                stringBuffer.append("-");
            }
            boolean bl4 = bl = (n3 = DagBuilder.getPrecedence(dag2, wmiLPrintOptions)) > 6;
            if (n3 == 6) {
                Dag dag4;
                int n4;
                if (dag3.getType() == 2 && dag2.getType() == 16 && (n4 = dag2.getLength()) > 2 && DagUtil.isNegative(dag4 = dag2.getChild(1))) {
                    bl = true;
                }
                if (dag3.getType() == 1) {
                    bl = true;
                }
            }
            if (bl) {
                stringBuffer.append("(");
            }
            DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
            if (bl) {
                stringBuffer.append(")");
            }
            ++n2;
        }
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        if (wmiLPrintOptions.isInLineIfPossible()) {
            this.infixLinePrint(stringBuffer, dag, wmiLPrintOptions);
        } else {
            this.prefixLinePrint(stringBuffer, dag, wmiLPrintOptions);
        }
    }

    public Dag normalize(Dag dag) {
        Dag dag2 = null;
        if (dag != null && dag.getType() == 16) {
            if (!dag.isNormalized()) {
                int n = dag.getLength();
                dag2 = dag.copy();
                for (int i = 0; i < n; i += 2) {
                    Dag dag3;
                    Dag dag4 = dag.getChild(i);
                    Dag dag5 = dag.getChild(i + 1);
                    if (dag4.getType() == 16 && dag4.getLength() == 2 && DagUtil.isMinusOne(dag4.getChild(1))) {
                        dag5 = DagUtil.negate(dag5);
                        dag4 = dag4.getChild(0);
                    }
                    if (dag4.getType() == 14 && (dag3 = dag4.getChild(0)).getType() == 6 && DagUtil.isNegative(dag3)) {
                        dag4 = DagUtil.negate(dag4);
                        dag5 = DagUtil.negate(dag5);
                    }
                    if (DagUtil.isNegative(dag5)) {
                        if (DagUtil.isMinusOne(dag5)) {
                            dag2.setChild(i, dag4);
                            dag2.setChild(i + 1, dag5);
                            continue;
                        }
                        dag2.setChild(i, ProdDagFactory.create(DagUtil.negate(dag5), dag4));
                        dag2.setChild(i + 1, DagConstants.MINUS_ONE);
                        continue;
                    }
                    if (DagUtil.isOne(dag5)) {
                        if (DagUtil.isNegative(dag4)) {
                            dag2.setChild(i, DagUtil.negate(dag4));
                            dag2.setChild(i + 1, DagConstants.MINUS_ONE);
                            continue;
                        }
                        dag2.setChild(i, dag4);
                        dag2.setChild(i + 1, dag5);
                        continue;
                    }
                    dag2.setChild(i, ProdDagFactory.create(dag5, dag4));
                    dag2.setChild(i + 1, DagConstants.ONE);
                }
                dag.setNormalized(dag2);
            } else {
                dag2 = dag.getNormalized();
            }
        }
        return dag2;
    }

    protected String getElisionThresholdProperty() {
        return "elisiontermsthreshold";
    }

    protected String getElisionAfterProperty() {
        return "elisiontermsafter";
    }

    protected String getElisionBeforeProperty() {
        return "elisiontermsbefore";
    }

    protected int getDefaultElideThreshold() {
        return 1000;
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        Object object;
        int n = dag.getLength();
        String string = DagBuilder.ELEMENT_NAME[16];
        SumLayoutBox sumLayoutBox = new SumLayoutBox(string, n + 1);
        if (n == 2) {
            LayoutBox layoutBox;
            object = dag.getChild(0);
            Dag dag2 = dag.getChild(1);
            if (dag2.getType() == 1) {
                layoutBox = ((Dag)object).getType() == 3 || ProdDagFactory.isQuotient((Dag)object) ? NotationLayoutBox.createNotationBox(layoutFormatter, 111) : NotationLayoutBox.createNotationBox(layoutFormatter, 24);
                sumLayoutBox.addChild(layoutBox);
            }
            layoutBox = DagBuilder.createLayout(layoutFormatter, (Dag)object);
            sumLayoutBox.addChild(layoutBox);
        } else {
            boolean bl = false;
            if (this.elideThreshold >= 0 && this.elideThreshold < Integer.MAX_VALUE) {
                bl = n > 2 * this.elideThreshold && n > 2 * (this.leftSample + this.rightSample) && 2 * (this.leftSample + this.rightSample) > 0 && 2 * this.leftSample < Integer.MAX_VALUE && 2 * this.rightSample < Integer.MAX_VALUE && 2 * this.rightSample > 0 && 2 * this.leftSample > 0;
            }
            for (int i = 0; i < n; i += 2) {
                Object object2;
                if (bl && i == this.leftSample * 2) {
                    int n2 = n / 2 - this.leftSample - this.rightSample;
                    object2 = n2 > 1 ? " terms...]" : " term...]";
                    NotationLayoutBox notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, "[..." + n2 + (String)object2);
                    sumLayoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 1));
                    sumLayoutBox.addChild(notationLayoutBox);
                    i = n - this.rightSample * 2;
                    if (i == n) break;
                }
                Dag dag3 = dag.getChild(i);
                object2 = dag.getChild(i + 1);
                if (((Dag)object2).getType() == 2) {
                    BinaryOperationTemplate.apply(layoutFormatter, (LayoutBox)sumLayoutBox, 1, dag3, this.getPrecedence(dag), 0);
                    continue;
                }
                if (sumLayoutBox.numChildren() == 0) {
                    int n3 = dag3.getType() == 3 || ProdDagFactory.isQuotient(dag3) ? 111 : 24;
                    sumLayoutBox.addChild(UnaryOperationTemplate.apply(layoutFormatter, n3, dag3, this.getPrecedence(dag), 0));
                    continue;
                }
                BinaryOperationTemplate.apply(layoutFormatter, (LayoutBox)sumLayoutBox, 2, dag3, this.getPrecedence(dag), 0);
            }
        }
        object = new StandardSelectionData(1);
        sumLayoutBox.setSelectionData((SelectionData)object);
        return sumLayoutBox;
    }

    static class SumLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker((int)7);

        public SumLayoutBox(String string, int n) {
            super(string, n);
        }

        public SumLayoutBox() {
        }

        public void setLineBreaker(LineBreaker lineBreaker) {
        }

        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

