/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractCommandDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class TryDagFactory
extends AbstractCommandDagFactory {
    public Dag readDotm(WmiByteArrayInputStream wmiByteArrayInputStream) throws IOException {
        return this.readDotm(wmiByteArrayInputStream, 49, DagBuilder.parseShortInteger(wmiByteArrayInputStream));
    }

    public void writeDotm(StringBuffer stringBuffer, Dag dag) {
        this.writeDotm(stringBuffer, dag, 49, true);
    }

    public void linePrint(StringBuffer stringBuffer, Dag dag, WmiLPrintOptions wmiLPrintOptions) {
        int n = dag.getLength();
        stringBuffer.append("try ");
        DagBuilder.linePrint(stringBuffer, dag.getChild(0), wmiLPrintOptions);
        stringBuffer.append(" ");
        if (n > 1) {
            for (int i = 2; i < n; i += 2) {
                Dag dag2 = dag.getChild(i - 1);
                stringBuffer.append("catch");
                if (!DagUtil.isNull(dag2)) {
                    stringBuffer.append(" ");
                    DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                }
                stringBuffer.append(": ");
                dag2 = dag.getChild(i);
                DagBuilder.linePrint(stringBuffer, dag2, wmiLPrintOptions);
                stringBuffer.append(" ");
            }
            if ((n & 1) == 0) {
                stringBuffer.append("finally ");
                DagBuilder.linePrint(stringBuffer, dag.getChild(n - 1), wmiLPrintOptions);
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("end try");
    }

    public LayoutBox createLayout(LayoutFormatter layoutFormatter, Dag dag) {
        int n = dag.getLength();
        InlineLayoutBox inlineLayoutBox = new InlineLayoutBox(6 + n + n / 2);
        InlineLayoutBox inlineLayoutBox2 = new InlineLayoutBox(1);
        inlineLayoutBox2.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 58));
        inlineLayoutBox.addChild(inlineLayoutBox2);
        inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
        inlineLayoutBox.addChild(ProcTemplate.layoutStatement(layoutFormatter, dag.getChild(0)));
        inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
        if (n > 1) {
            for (int i = 2; i < n; i += 2) {
                inlineLayoutBox2 = new InlineLayoutBox(2);
                inlineLayoutBox2.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 59));
                Dag dag2 = dag.getChild(i - 1);
                if (!DagUtil.isNull(dag2)) {
                    inlineLayoutBox2.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, " "));
                    inlineLayoutBox2.addChild(DagBuilder.createLayout(layoutFormatter, dag2));
                }
                inlineLayoutBox2.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 60));
                ProcTemplate.addNeededDelimiter(layoutFormatter, inlineLayoutBox);
                inlineLayoutBox.addChild(inlineLayoutBox2);
                inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
                inlineLayoutBox.addChild(ProcTemplate.layoutStatement(layoutFormatter, dag.getChild(i)));
            }
            if ((n & 1) == 0) {
                inlineLayoutBox2 = new InlineLayoutBox(1);
                inlineLayoutBox2.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 61));
                inlineLayoutBox.addChild(inlineLayoutBox2);
                inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
                inlineLayoutBox.addChild(ProcTemplate.layoutStatement(layoutFormatter, dag.getChild(n - 1)));
            }
        }
        ProcTemplate.addNeededDelimiter(layoutFormatter, inlineLayoutBox);
        inlineLayoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, longForm ? 72 : 37));
        inlineLayoutBox.addChild(ProcTemplate.createSemiColon(layoutFormatter));
        inlineLayoutBox.addChild(new ProcTemplate.ProcDelimiter(layoutFormatter));
        inlineLayoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)16));
        return inlineLayoutBox;
    }
}

