/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.PostLayoutJob;
import com.maplesoft.client.prettyprinter.PostLayoutJobQueue;
import com.maplesoft.client.prettyprinter.SubexpressionLabelLayoutBox;

public abstract class AbstractFormatter
implements LayoutFormatter {
    private int procedureCount = 0;
    private boolean isOperatorProc = false;
    private int superscriptCount = 0;
    private boolean funcName = false;
    protected int displayPrecision = -2;
    protected PostLayoutJobQueue postLayoutQueue = new PostLayoutJobQueue();
    protected DagRenderContext renderContext = null;
    protected static DagRenderContext defaultRenderContext = null;
    protected static DagRenderContext activeRenderContext = null;
    private static int[] contextFactories = new int[]{2, 6, 42, 4, 8, 34, 16};

    public static void invalidateContext() {
        activeRenderContext = null;
    }

    public static void setDefaultContext(DagRenderContext dagRenderContext) {
        defaultRenderContext = dagRenderContext;
    }

    public void setContext(DagRenderContext dagRenderContext) {
        this.renderContext = dagRenderContext;
    }

    public DagRenderContext getContext() {
        return this.renderContext != null ? this.renderContext : defaultRenderContext;
    }

    public boolean updateContext() {
        boolean bl = false;
        if (this.renderContext == null) {
            this.renderContext = defaultRenderContext;
            bl = true;
        }
        if (this.renderContext != null && this.renderContext != activeRenderContext) {
            activeRenderContext = this.renderContext;
            for (int i = 0; i < contextFactories.length; ++i) {
                DagBuilder.updateContext(contextFactories[i], this.renderContext);
            }
            bl = true;
        }
        return bl;
    }

    public double getBearingMultiplier() {
        return 1.0;
    }

    public void incProcCount() {
        ++this.procedureCount;
    }

    public void decProcCount() {
        --this.procedureCount;
    }

    public boolean isInProc() {
        return this.procedureCount > 0;
    }

    public int getProcCount() {
        return this.procedureCount;
    }

    public void incSuperscriptCount() {
        ++this.superscriptCount;
    }

    public void decSuperscriptCount() {
        --this.superscriptCount;
    }

    public boolean isInSuperscript() {
        return this.superscriptCount > 0;
    }

    public boolean isInOperatorProc() {
        return this.isOperatorProc;
    }

    public void setInOperatorProc(boolean bl) {
        this.isOperatorProc = bl;
    }

    public void setDisplayPrecision(int n) {
        this.displayPrecision = n;
    }

    public NotationLayoutBox createNotationBox(int n) {
        return new NotationLayoutBox(n);
    }

    public boolean isFunctionName() {
        return this.funcName;
    }

    public void setIsFunctionName(boolean bl) {
        this.funcName = bl;
    }

    public LayoutBox format(Dag dag, String string, double d) {
        Dag dag2;
        if (dag.getType() == 29 && dag.getLength() == 1) {
            dag = dag.getChild(0);
        }
        dag2 = (dag2 = DagBuilder.normalize(dag)) == null ? dag : dag2;
        LayoutBox layoutBox = DagBuilder.createNewLayoutBox(this, dag2);
        layoutBox.applyLayout();
        return layoutBox;
    }

    public void addPostLayoutJob(Object object, PostLayoutJob postLayoutJob) {
        this.postLayoutQueue.addJob(object, postLayoutJob);
    }

    public boolean containsJobForIdentifier(Object object) {
        return this.postLayoutQueue.containsJobForIdentifier(object);
    }

    public PostLayoutJobQueue getPostLayoutJobQueue() {
        return this.postLayoutQueue;
    }

    public double getSafeBreakWidth() {
        return this.getBreakWidth() - (double)this.getColumnSeparator();
    }

    public static class AssumptionLabelJob
    implements PostLayoutJob {
        private LayoutBox labelBox;

        public AssumptionLabelJob(LayoutFormatter layoutFormatter, String string) {
            this.labelBox = string.endsWith("~") ? NotationLayoutBox.createCustomBox(layoutFormatter, string.substring(0, string.length() - 1)) : NotationLayoutBox.createCustomBox(layoutFormatter, string);
        }

        public LayoutBox getVariable() {
            return this.labelBox;
        }
    }

    public static class SubexpressionLabelJob
    implements PostLayoutJob {
        private LayoutBox legendItem;
        private SubexpressionLabelLayoutBox subexpressionBox;

        public SubexpressionLabelJob(LayoutFormatter layoutFormatter, SubexpressionLabelLayoutBox subexpressionLabelLayoutBox) {
            this.subexpressionBox = subexpressionLabelLayoutBox;
            this.buildLegendItem(layoutFormatter, subexpressionLabelLayoutBox);
        }

        public SubexpressionLabelLayoutBox getSubexpressionBox() {
            return this.subexpressionBox;
        }

        public LayoutBox getLegendItem() {
            return this.legendItem;
        }

        private void buildLegendItem(LayoutFormatter layoutFormatter, SubexpressionLabelLayoutBox subexpressionLabelLayoutBox) {
            this.legendItem = new DefaultLayoutBox();
            this.legendItem.addChild(NotationLayoutBox.createCustomBox(layoutFormatter, subexpressionLabelLayoutBox.getLabel()));
            this.legendItem.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 17));
            this.legendItem.addChild(subexpressionLabelLayoutBox.getLabelTarget());
            LayoutAnchor.anchorLeftToRight(this.legendItem, 0, 2);
            this.legendItem.applyLayout();
        }
    }
}

