/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.BoxUtils;
import com.maplesoft.client.prettyprinter.LayoutBox;
import java.util.Iterator;
import java.util.List;

public abstract class LeafBoxIterator
implements Iterator {
    private LayoutBox currentBox;
    private LayoutBox rootBox;
    private List pathToCurrent;
    private boolean justCreated = true;
    private boolean boxUpdated = true;

    protected LeafBoxIterator(LayoutBox layoutBox, LayoutBox layoutBox2) {
        this.rootBox = layoutBox2;
        if (layoutBox != null) {
            this.currentBox = layoutBox;
            this.hasNext();
        } else {
            this.currentBox = this.findFirstLeaf(layoutBox2);
        }
        this.updatePath();
    }

    protected abstract LayoutBox getFirstInTraversal(LayoutBox var1);

    protected abstract int getNextIndexInTraversal(int var1);

    protected LayoutBox getNextAtCurrentLevelInTraversal(LayoutBox layoutBox, LayoutBox layoutBox2) {
        if (this.hasNextInTraversal(layoutBox, layoutBox2)) {
            int n = layoutBox2.indexOf(layoutBox);
            int n2 = this.getNextIndexInTraversal(n);
            return layoutBox2.getChild(n2);
        }
        return null;
    }

    protected boolean hasNextInTraversal(LayoutBox layoutBox, LayoutBox layoutBox2) {
        int n = layoutBox2.indexOf(layoutBox);
        int n2 = this.getNextIndexInTraversal(n);
        return n != -1 && n2 >= 0 && n2 < layoutBox2.numChildren();
    }

    private LayoutBox findFirstLeaf(LayoutBox layoutBox) {
        LayoutBox layoutBox2 = layoutBox;
        LayoutBox layoutBox3 = this.getFirstInTraversal(layoutBox2);
        while (layoutBox3 != null) {
            layoutBox2 = layoutBox3;
            layoutBox3 = this.getFirstInTraversal(layoutBox2);
        }
        return layoutBox2;
    }

    private LayoutBox findParentInList(LayoutBox layoutBox) {
        int n = this.pathToCurrent.indexOf(layoutBox);
        if (n > 0) {
            return (LayoutBox)this.pathToCurrent.get(n - 1);
        }
        return null;
    }

    private void updatePath() {
        this.pathToCurrent = BoxUtils.findPathToBox(this.rootBox, this.currentBox);
        this.pathToCurrent.add(this.currentBox);
    }

    protected LayoutBox getNextInTraversal(LayoutBox layoutBox, LayoutBox layoutBox2) {
        if (layoutBox2 == null) {
            return null;
        }
        LayoutBox layoutBox3 = this.getNextAtCurrentLevelInTraversal(layoutBox, layoutBox2);
        if (layoutBox3 != null) {
            return this.findFirstLeaf(layoutBox3);
        }
        if (layoutBox2 != null) {
            LayoutBox layoutBox4 = this.findParentInList(layoutBox2);
            return this.getNextInTraversal(layoutBox2, layoutBox4);
        }
        return null;
    }

    public boolean hasNext() {
        LayoutBox layoutBox;
        if (this.justCreated) {
            this.justCreated = false;
            return true;
        }
        LayoutBox layoutBox2 = this.findParentInList(this.currentBox);
        this.currentBox = layoutBox = this.getNextInTraversal(this.currentBox, layoutBox2);
        if (this.currentBox != null) {
            this.updatePath();
        }
        this.boxUpdated = true;
        return this.currentBox != null;
    }

    public Object next() {
        if (!this.boxUpdated) {
            this.hasNext();
        }
        this.boxUpdated = false;
        return this.currentBox;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class BackwardLeafBoxIterator
    extends LeafBoxIterator {
        public BackwardLeafBoxIterator(LayoutBox layoutBox, LayoutBox layoutBox2) {
            super(layoutBox, layoutBox2);
        }

        protected LayoutBox getFirstInTraversal(LayoutBox layoutBox) {
            return layoutBox.getChild(layoutBox.numChildren() - 1);
        }

        protected int getNextIndexInTraversal(int n) {
            return n - 1;
        }
    }

    public static class ForwardLeafBoxIterator
    extends LeafBoxIterator {
        public ForwardLeafBoxIterator(LayoutBox layoutBox, LayoutBox layoutBox2) {
            super(layoutBox, layoutBox2);
        }

        protected LayoutBox getFirstInTraversal(LayoutBox layoutBox) {
            return layoutBox.getChild(0);
        }

        protected int getNextIndexInTraversal(int n) {
            return n + 1;
        }
    }
}

