/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.PostLayoutJob;
import com.maplesoft.client.prettyprinter.SubexpressionLabelLayoutBox;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class PostLayoutJobQueue {
    private HashMap jobMap;
    private LinkedList jobList;
    private int subexpressionNumber = 0;
    private boolean labelAllowed = true;
    private int labelWidth = 20;
    private HashSet dupSet;
    private HashSet testSet;
    private boolean[] allowedToLabel = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public PostLayoutJobQueue() {
        this.testSet = new HashSet();
        this.dupSet = new HashSet();
        this.jobMap = new HashMap();
        this.jobList = new LinkedList();
    }

    public void addJob(Object object, PostLayoutJob postLayoutJob) {
        this.jobMap.put(object, postLayoutJob);
        this.jobList.add(postLayoutJob);
    }

    public boolean containsJobForIdentifier(Object object) {
        return this.jobMap.containsKey(object);
    }

    public boolean containsJob(PostLayoutJob postLayoutJob) {
        return this.jobList.indexOf(postLayoutJob) != -1;
    }

    public PostLayoutJob getJob(Object object) {
        return (PostLayoutJob)this.jobMap.get(object);
    }

    public PostLayoutJob getFirstJob() {
        return (PostLayoutJob)this.jobList.get(0);
    }

    public int getJobCount() {
        return this.jobList.size();
    }

    public PostLayoutJob removeFirstJob() {
        PostLayoutJob postLayoutJob = (PostLayoutJob)this.jobList.remove(0);
        Object var2_2 = null;
        Iterator iterator = this.jobMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(postLayoutJob)) continue;
            var2_2 = entry.getKey();
            break;
        }
        this.jobMap.remove(var2_2);
        return postLayoutJob;
    }

    public boolean isEmpty() {
        return this.jobList.isEmpty();
    }

    public int getSubexpressionNumber() {
        return this.subexpressionNumber;
    }

    public void setSubexpressionNumber(int n) {
        this.subexpressionNumber = n;
    }

    public LayoutBox subexpressionLabel(LayoutFormatter layoutFormatter, LayoutBox layoutBox, Dag dag) {
        if (this.labelAllowed && this.isDuplicated(dag)) {
            layoutBox.applyLayout();
            double d = layoutBox.getWidth();
            int n = (int)((double)this.labelWidth * layoutFormatter.getFontWidth(0));
            if (d >= (double)n) {
                layoutBox = new SubexpressionLabelLayoutBox(layoutFormatter, layoutBox, DagBuilder.lPrint(dag));
            }
        }
        return layoutBox;
    }

    public void setLabelAllowed(boolean bl) {
        this.labelAllowed = bl;
    }

    public boolean getLabelAllowed() {
        return this.labelAllowed;
    }

    public void setLabelWidth(int n) {
        this.labelWidth = n;
    }

    public void locateDuplicates(Dag dag) {
        this.dupSet = new HashSet();
        this.internalLocateDuplicates(dag, dag);
        this.testSet = new HashSet();
    }

    private void internalLocateDuplicates(Dag dag, Dag dag2) {
        if (this.allowedToLabel[dag.getType()] && !this.dupSet.contains(dag)) {
            if (this.testSet.contains(dag)) {
                this.dupSet.add(dag);
            } else {
                this.testSet.add(dag);
            }
        }
        for (int i = 0; i < dag.getLength(); ++i) {
            this.internalLocateDuplicates(dag.getChild(i), dag);
        }
    }

    public boolean isDuplicated(Dag dag) {
        return this.dupSet.contains(dag);
    }
}

