/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.BracketLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.template.IntegralTemplate;

public class ResizableNotationBox
extends InlineLayoutBox {
    public static final int HEIGHT_CONSTRAINT = 0;
    public static final int WIDTH_CONSTRAINT = 1;
    public static final int HEIGHT_WIDTH_CONSTRAINT = 2;
    public static final int HEIGHT_SUM_CONSTRAINT = 3;
    public static final int NULL_CONSTRAINT = 4;
    public static final int NESTED_INTEGRAL_CONSTRAINT = 5;
    public static int counter = 0;
    protected LayoutFormatter formatter;
    protected NotationLayoutBox box;
    protected int constraintType;
    protected LayoutBox constraint1;
    protected LayoutBox constraint2;
    protected boolean adjustBaseline;
    protected boolean singleHeight;
    protected double baselineFF;

    public ResizableNotationBox(LayoutFormatter layoutFormatter, int n, int n2, LayoutBox layoutBox) {
        this(layoutFormatter, n, n2, layoutBox, null);
    }

    public ResizableNotationBox(LayoutFormatter layoutFormatter, int n, int n2, LayoutBox layoutBox, LayoutBox layoutBox2) {
        this.box = NotationLayoutBox.createNotationBox(layoutFormatter, n);
        this.addChild(this.box);
        this.formatter = layoutFormatter;
        this.constraintType = n2;
        this.constraint1 = layoutBox;
        this.constraint2 = layoutBox2;
        this.baselineFF = 0.0;
    }

    public void setBaselineAdjustment(boolean bl) {
        this.adjustBaseline = bl;
    }

    public void invalidateAll() {
        this.validLayout = false;
    }

    public LayoutBox getPairEndPointBox() {
        return this.getChild(0).getPairEndPointBox();
    }

    public void setPairEndPointBox(LayoutBox layoutBox) {
        this.getChild(0).setPairEndPointBox(layoutBox);
    }

    public void computeSize() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.constraintType) {
            case 4: {
                this.formatter.resizeNotationBox(this.box);
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 0: {
                d = this.constraint1.getHeight();
                if (this.constraint2 == null) {
                    this.formatter.resizeNotationBox(this.box, d);
                } else {
                    d2 = this.constraint2.getHeight();
                    this.formatter.resizeNotationBox(this.box, d, d2);
                }
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 1: {
                d3 = this.constraint1.getWidth();
                if (this.constraint2 == null) {
                    this.formatter.resizeNotationBox(this.box, d3);
                } else {
                    d4 = this.constraint2.getWidth();
                    this.formatter.resizeNotationBox(this.box, d3, d4);
                }
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 2: {
                d3 = this.constraint1.getWidth();
                d = this.constraint2.getHeight();
                this.formatter.resizeNotationBox(this.box, d3, d);
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
                break;
            }
            case 3: {
                d = this.constraint1.getHeight() + this.constraint2.getHeight();
                this.formatter.resizeNotationBox(this.box, d);
                break;
            }
            case 5: {
                d = 10.0;
                LayoutBox layoutBox = IntegralTemplate.findLastConsecutiveIntegralBox(this.constraint1);
                LayoutBox layoutBox2 = layoutBox.getChild(0).getChild(2);
                d = layoutBox2.getHeight();
                this.formatter.resizeNotationBox(this.box, d);
                if (!this.adjustBaseline) break;
                this.setBaseline(this.box.getBaseline());
            }
        }
        this.setSize(this.box.getWidth(), this.box.getHeight());
        this.box.validate(true);
        this.validate(true);
    }

    public void applyLayout() {
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            if (this.constraint1 != null && !this.constraint1.isLayoutValid()) {
                this.constraint1.applyLayout();
            }
            if (this.constraint2 != null && !this.constraint2.isLayoutValid()) {
                this.constraint2.applyLayout();
            }
            this.computeSize();
        }
    }

    public void setSelectionData(SelectionData selectionData) {
        super.setSelectionData(selectionData);
        if (this.getChild(0) != null) {
            this.getChild(0).setSelectionData(selectionData);
        }
    }

    public void setBaselineFudgeFactor(double d) {
        this.baselineFF = d;
    }

    public void setBaseline(double d) {
        this.baseline = d;
    }

    public NotationLayoutBox getBox() {
        return this.box;
    }

    public LayoutFormatter getFormatter() {
        return this.formatter;
    }

    public LayoutBox getConstraint1() {
        return this.constraint1;
    }

    public int getType() {
        return this.box.getType();
    }

    public void setBoxBaseline(double d) {
        this.box.setBaseline(d);
    }

    public boolean getResize() {
        boolean bl = false;
        if (this.box instanceof BracketLayoutBox) {
            bl = ((BracketLayoutBox)this.box).getResize();
        }
        return bl;
    }

    public void setResize(boolean bl) {
        if (this.box instanceof BracketLayoutBox) {
            ((BracketLayoutBox)this.box).setResize(bl);
        }
    }
}

