/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ProcLayoutBox;
import com.maplesoft.client.prettyprinter.TTYBracketLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class TTYFormatter
extends AbstractFormatter {
    private static final int PRODUCT_WIDTH = 10;
    private static final int PRODUCT_HEIGHT = 5;
    private static final int SUM_WIDTH = 6;
    private static final int SUM_HEIGHT = 5;
    private static final int MIN_INTEGRAL_HEIGHT = 5;
    private static final int ROW_SEPARATOR = 1;
    private static final int COLUMN_SEPARATOR = 2;
    public static final int DEFAULT_BREAK_WIDTH = 79;
    private static final int INLINE_PROD_TEST_LENGTH = 4;
    private static final int INLINE_NUMERATOR_INDEX = 0;
    private static final int INLINE_DENOMINATOR_INDEX = 2;
    private static final int INLINE_RATIONAL_TEST_INDEX = 3;
    private static final HashSet expandedSpecialFunctions = new HashSet();
    private boolean centerIndent = true;
    private int breakWidth = 79;
    private char[][] outputBuffer = null;

    public void setBreakWidth(double d) {
        this.breakWidth = (int)d;
    }

    public double getBreakWidth() {
        return this.breakWidth;
    }

    public double getBearingMultiplier() {
        return 0.0;
    }

    public boolean useSymbolFont() {
        return false;
    }

    public boolean useRootSymbol() {
        return false;
    }

    public void setCenterIndent(boolean bl) {
        this.centerIndent = bl;
    }

    public int getRowSeparator() {
        return 1;
    }

    public int getColumnSeparator() {
        return 2;
    }

    public LayoutBox format(Dag dag, String string, double d) {
        this.updateContext();
        LayoutBox layoutBox = super.format(dag, string, d);
        layoutBox.linebreak(this, d);
        return layoutBox;
    }

    public void display(Dag dag, PrintWriter printWriter) {
        this.display(dag, printWriter, 79.0);
    }

    public void display(Dag dag, PrintWriter printWriter, double d) {
        LayoutBox layoutBox = this.format(dag, "Text Output", d);
        LayoutBox layoutBox2 = layoutBox.getDisplayLayoutBox();
        int n = (int)layoutBox2.getWidth();
        int n2 = Math.max((this.breakWidth - n) / 2 - 1, 0);
        int n3 = n2 = this.centerIndent ? n2 : 0;
        if (layoutBox instanceof LineBreakLayoutBox) {
            Iterator iterator = layoutBox.getChildren();
            while (iterator.hasNext()) {
                this.display((LayoutBox)iterator.next(), printWriter, n2);
            }
        } else if (layoutBox2 instanceof LineBreakLayoutBox) {
            this.display(layoutBox2, printWriter);
        } else if (layoutBox2 instanceof ProcLayoutBox) {
            this.display(layoutBox, printWriter, 0);
        } else {
            this.display(layoutBox, printWriter, n2);
        }
    }

    private void display(LayoutBox layoutBox, PrintWriter printWriter) {
        LayoutBox layoutBox2 = layoutBox.getDisplayLayoutBox();
        int n = (int)layoutBox2.getWidth();
        int n2 = Math.max((this.breakWidth - n) / 2 - 1, 0);
        int n3 = n2 = this.centerIndent ? n2 : 0;
        if (layoutBox instanceof LineBreakLayoutBox) {
            Iterator iterator = layoutBox.getChildren();
            while (iterator.hasNext()) {
                this.display((LayoutBox)iterator.next(), printWriter, n2);
            }
        } else if (layoutBox2 instanceof LineBreakLayoutBox) {
            this.display(layoutBox2, printWriter);
        } else if (layoutBox2 instanceof ProcLayoutBox) {
            this.display(layoutBox, printWriter, 0);
        } else {
            this.display(layoutBox, printWriter, n2);
        }
    }

    public void display(LayoutBox layoutBox, PrintWriter printWriter, int n) {
        LayoutBox layoutBox2 = layoutBox.getDisplayLayoutBox();
        int n2 = (int)layoutBox2.getHeight();
        int n3 = (int)layoutBox2.getWidth();
        if (this.outputBuffer == null || this.outputBuffer.length < n2) {
            this.outputBuffer = new char[n2][];
        }
        int n4 = 0;
        int n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            if (this.outputBuffer[n4] == null || this.outputBuffer[n4].length < n3) {
                this.outputBuffer[n4] = new char[n3];
            }
            Arrays.fill(this.outputBuffer[n4], ' ');
        }
        this.fill(layoutBox2, this.outputBuffer, -layoutBox2.getXorig(), -layoutBox2.getYorig());
        String string = System.getProperty("line.separator");
        for (n4 = 0; n4 < n2; ++n4) {
            if (n3 > 0) {
                for (n5 = 0; n5 < n; ++n5) {
                    printWriter.print(' ');
                }
                char[] cArray = this.outputBuffer[n4];
                for (n5 = 0; n5 < n3; ++n5) {
                    printWriter.print(cArray[n5]);
                }
                printWriter.flush();
            }
            printWriter.print(string);
        }
    }

    private char[][] fill(LayoutBox layoutBox, char[][] cArray, double d, double d2) {
        LayoutPoint layoutPoint = layoutBox.getOrigin();
        d += layoutPoint.getX();
        d2 += layoutPoint.getY();
        if (layoutBox instanceof NotationLayoutBox && ((NotationLayoutBox)layoutBox).isCustomDrawn()) {
            this.drawNotationBox((NotationLayoutBox)layoutBox, cArray, (int)d, (int)d2);
        } else if (layoutBox.hasChildren()) {
            Iterator iterator = layoutBox.getChildren();
            while (iterator.hasNext()) {
                this.fill((LayoutBox)iterator.next(), cArray, d, d2);
            }
        } else {
            this.drawString(layoutBox.getData(), cArray, (int)d, (int)d2);
        }
        return cArray;
    }

    private void drawString(String string, char[][] cArray, int n, int n2) {
        try {
            if (n > -1 && n2 > -1 && cArray.length > 0 && cArray[0].length > 0) {
                int n3 = string.length();
                char[] cArray2 = cArray[n2];
                for (int i = 0; i < n3; ++i) {
                    cArray2[n + i] = string.charAt(i);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean useInLine(Dag dag) {
        boolean bl = false;
        if (dag.getType() == 18) {
            if (dag.getLength() > 0 && dag.getChild(0).getType() == 8) {
                bl = !expandedSpecialFunctions.contains(dag.getChild(0).getData());
            }
        } else if (dag.getType() == 14) {
            if (dag.getLength() == 4 && DagUtil.isMinusOne(dag.getChild(3))) {
                String string = dag.getChild(0).getData();
                String string2 = dag.getChild(2).getData();
                if (string != null && string.length() == 1 && string2 != null && string2.length() == 1) {
                    bl = true;
                }
            }
        } else if (dag.getType() == 10) {
            bl = true;
        }
        return bl;
    }

    private void drawNotationBox(NotationLayoutBox notationLayoutBox, char[][] cArray, int n, int n2) {
        int n3 = (int)notationLayoutBox.getWidth();
        switch (notationLayoutBox.getType()) {
            case 98: 
            case 105: {
                char[] cArray2 = new char[n3];
                Arrays.fill(cArray2, notationLayoutBox.getType() == 98 ? (char)'-' : '_');
                System.arraycopy(cArray2, 0, cArray[n2], n, n3);
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 103: 
            case 104: 
            case 106: {
                ((TTYBracketLayoutBox)notationLayoutBox).drawBracket(cArray, n, n2);
                break;
            }
            case 90: {
                this.drawProduct(cArray, n, n2);
                break;
            }
            case 89: {
                this.drawSum(cArray, n, n2);
                break;
            }
            case 108: {
                this.drawString("/", cArray, n, n2);
                break;
            }
            case 109: {
                this.drawString(" minus ", cArray, n, n2);
            }
        }
    }

    private void drawProduct(char[][] cArray, int n, int n2) {
        int n3 = 0;
        try {
            cArray[n2][n] = 44;
            for (n3 = 1; n3 < 9; ++n3) {
                cArray[n2][n + n3] = 45;
            }
            cArray[n2][n + 10 - 1] = 39;
            ++n2;
            for (n3 = 0; n3 < 4; ++n3) {
                cArray[n2 + n3][n + 3] = 124;
                cArray[n2 + n3][n + 10 - 4] = 124;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    private void drawSum(char[][] cArray, int n, int n2) {
        int n3 = 0;
        try {
            for (n3 = 0; n3 < 5; ++n3) {
                cArray[n2][n + n3] = 45;
                cArray[n2 + 5 - 1][n + n3] = 45;
            }
            for (n3 = 1; n3 < 2; ++n3) {
                cArray[n2 + n3][n + n3] = 92;
                cArray[n2 + 5 - 1 - n3][n + n3] = 47;
            }
            cArray[n2 + 2][n + 2] = 41;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    public void resizeNotationBox(NotationLayoutBox notationLayoutBox) {
        boolean bl = true;
        double d = 1.0;
        double d2 = 1.0;
        switch (notationLayoutBox.getType()) {
            case 90: {
                d = 5.0;
                d2 = 10.0;
                break;
            }
            case 89: {
                d = 5.0;
                d2 = 6.0;
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                d2 = 1.0;
                d = 1.0;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            notationLayoutBox.setSize(d2, d);
        }
    }

    public void resizeNotationBox(NotationLayoutBox notationLayoutBox, double d) {
        boolean bl = true;
        double d2 = 1.0;
        double d3 = 1.0;
        switch (notationLayoutBox.getType()) {
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 103: 
            case 104: 
            case 106: {
                d2 = d;
                break;
            }
            case 93: 
            case 94: {
                d2 = d;
                d2 = (int)d2 | 1;
                d3 = d2 == 1.0 ? 1.0 : 2.0;
                break;
            }
            case 105: {
                d3 = d;
                break;
            }
            case 97: {
                d2 = d;
                if (d2 < 5.0) {
                    d2 = 5.0;
                }
                d3 = 3.0;
                notationLayoutBox.setBaseline(d2 / 2.0);
                break;
            }
            case 108: {
                d3 = 1.0;
                d2 = 1.0;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            notationLayoutBox.setSize(d3, d2);
        }
    }

    public void resizeNotationBox(NotationLayoutBox notationLayoutBox, double d, double d2) {
        boolean bl = true;
        double d3 = 1.0;
        double d4 = 1.0;
        switch (notationLayoutBox.getType()) {
            case 98: {
                d4 = d > d2 ? d : d2;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            notationLayoutBox.setSize(d4, d3);
        }
    }

    public double getFontWidth(int n) {
        return 1.0;
    }

    public double getFontHeight(int n) {
        return 1.0;
    }

    public NotationLayoutBox createNotationBox(int n) {
        NotationLayoutBox notationLayoutBox = null;
        if (NotationLayoutBox.isBracketNotationType(n)) {
            notationLayoutBox = new TTYBracketLayoutBox(n);
        }
        if (notationLayoutBox == null) {
            notationLayoutBox = new TTYTextLayoutBox(n);
        }
        return notationLayoutBox;
    }

    public NotationLayoutBox createNotationBox(int n, String string, int n2) {
        return new TTYTextLayoutBox(n, string, n2);
    }

    static {
        String[] stringArray = new String[]{"abs", "conjugate", "diff", "Diff", "Eval", "Int", "Limit", "matrix", "Matrix", "MATRIX", "PIECEWISE", "product", "Product", "RTABLE", "sum", "Sum", "@", "$", "<,>", "<|>", "vector", "union", "intersect", "minus", "subset", "in", "mod", "series", "_SERIES", "modp1", "modp2", ".", "Typesetting:-mfrac", "Typesetting:-mi", "Typesetting:-mmultiscripts", "Typesetting:-mscripts", "Typesetting:-mn", "Typesetting:-mo", "Typesetting:-mover", "Typesetting:-mambiguous", "Typesetting:-maction", "Typesetting:-mroot", "Typesetting:-mrow", "Typesetting:-mspace", "Typesetting:-msqrt", "Typesetting:-ms", "Typesetting:-mstyle", "Typesetting:-msub", "Typesetting:-msubsup", "Typesetting:-msup", "Typesetting:-mtext", "Typesetting:-merror", "Typesetting:-munder", "Typesetting:-mphantom", "Typesetting:-munderover", "Typesetting:-mprescripts", "Typesetting:-none", "Typesetting:-mfenced", "Typesetting:-mtable", "Typesetting:-mtr", "Typesetting:-mtd", "Typesetting:-mprintslash", "Typesetting:-mparsed", "Typesetting:-mverbatim"};
        for (int i = 0; i < stringArray.length; ++i) {
            expandedSpecialFunctions.add(stringArray[i]);
        }
    }

    private static class TTYTextLayoutBox
    extends NotationLayoutBox {
        TTYTextLayoutBox(int n, String string, int n2) {
            super(n, string, n2);
            this.setSize(string.length(), 1.0);
        }

        TTYTextLayoutBox(int n) {
            super(n);
        }
    }
}

