/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.selection;

import com.maplesoft.client.prettyprinter.selection.EquationSelectionEvent;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionListener;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionRecorder;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;

public class EquationSelectionManager {
    private LinkedList listeners = new LinkedList();

    public EquationSelectionManager() {
        this.addEquationSelectionListener(EquationSelectionRecorder.getInstance());
    }

    public void addEquationSelectionListener(EquationSelectionListener equationSelectionListener) {
        this.listeners.add(equationSelectionListener);
    }

    public void removeEquationSelectionListener(EquationSelectionListener equationSelectionListener) {
        int n = 0;
        n = this.listeners.indexOf(equationSelectionListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void fireActionEvent(EquationSelectionEvent equationSelectionEvent) {
        this.eventDispatch(new ActionDispatch(), equationSelectionEvent);
    }

    public void fireContextEvent(EquationSelectionEvent equationSelectionEvent) {
        this.eventDispatch(new ContextDispatch(), equationSelectionEvent);
    }

    public void fireSelectionEvent(EquationSelectionEvent equationSelectionEvent) {
        this.eventDispatch(new SelectionDispatch(), equationSelectionEvent);
    }

    private void eventDispatch(Dispatcher dispatcher, EquationSelectionEvent equationSelectionEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && !equationSelectionEvent.isConsumed()) {
            try {
                EquationSelectionListener equationSelectionListener = (EquationSelectionListener)iterator.next();
                dispatcher.dispatch(equationSelectionListener, equationSelectionEvent);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                break;
            }
        }
    }

    class SelectionDispatch
    implements Dispatcher {
        SelectionDispatch() {
        }

        public void dispatch(EquationSelectionListener equationSelectionListener, EquationSelectionEvent equationSelectionEvent) {
            equationSelectionListener.selectionChanged(equationSelectionEvent);
        }
    }

    class ActionDispatch
    implements Dispatcher {
        ActionDispatch() {
        }

        public void dispatch(EquationSelectionListener equationSelectionListener, EquationSelectionEvent equationSelectionEvent) {
            equationSelectionListener.actionRequest(equationSelectionEvent);
        }
    }

    class ContextDispatch
    implements Dispatcher {
        ContextDispatch() {
        }

        public void dispatch(EquationSelectionListener equationSelectionListener, EquationSelectionEvent equationSelectionEvent) {
            equationSelectionListener.contextRequest(equationSelectionEvent);
        }
    }

    static interface Dispatcher {
        public void dispatch(EquationSelectionListener var1, EquationSelectionEvent var2);
    }
}

