/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.SumDagFactory;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.PowerLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class FloatTemplate
implements SpecialFunctionTemplate {
    private static final int DEFAULT_DISPLAY_PRECISION = -1;
    private static int displayPrecision = -1;
    private static SelectionData noHelpSD = null;
    public static final int SCIENTIFIC_NOTATION_THRESHOLD = 6;

    public LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag[] dagArray) {
        if (dagArray.length > 1) {
            return FloatTemplate.apply(layoutFormatter, dagArray[0], dagArray[1]);
        }
        return null;
    }

    public static void updateContext(DagRenderContext dagRenderContext) {
        displayPrecision = dagRenderContext.getInterfaceProperty("displayprecision", -1);
    }

    public static LayoutBox buildFloatInfinity(LayoutFormatter layoutFormatter, boolean bl) {
        Dag dag = bl ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
        return DagBuilder.createLayout(layoutFormatter, dag);
    }

    public static LayoutBox apply(LayoutFormatter layoutFormatter, Dag dag, Dag dag2) {
        boolean bl;
        LayoutBox layoutBox = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = dag2.getType() == 8 && dag2.getData().equals("infinity") || dag2.getType() == 16 && dag2.getChild(1).getData().equals("infinity");
        if (bl) {
            return FloatTemplate.buildFloatInfinity(layoutFormatter, DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(dag)));
        }
        if (dag2.getType() == 8) {
            layoutBox = DagUtil.isFloatInfinity(dag2) ? FloatTemplate.buildFloatInfinity(layoutFormatter, DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(dag2))) : DagBuilder.createLayout(layoutFormatter, DagConstants.UNDEFINED);
            return layoutBox;
        }
        if (dag.getType() == 16) {
            dag = SumDagFactory.sumDagToIntegerDag(dag);
        }
        if (dag2.getType() == 16) {
            dag2 = SumDagFactory.sumDagToIntegerDag(dag2);
        }
        boolean bl3 = dag.getType() == 1;
        String string = dag.getData();
        int n = FloatTemplate.calculateExponent(dag2);
        if (string == null) {
            string = "0";
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = n2 + n;
        n3 = n < 0 && Math.abs(n4) >= 5 ? n4 : (n < 0 ? 0 : (n4 == 0 ? n4 : n4));
        int n5 = n3 = Math.abs(n3) < 6 ? 0 : n3;
        if (bl3) {
            stringBuffer.append("-");
        }
        if (noHelpSD == null) {
            noHelpSD = new StandardSelectionData(2);
            noHelpSD.setContextHelpAvailable(false);
        }
        if (n3 != 0) {
            Object object;
            layoutBox = new InlineLayoutBox();
            NotationLayoutBox notationLayoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, "10", 4);
            notationLayoutBox.setSelectionData(noHelpSD);
            NotationLayoutBox notationLayoutBox2 = null;
            int n6 = string.length();
            n6 = displayPrecision >= 0 ? displayPrecision : n6;
            stringBuffer = FloatTemplate.buildFloatString(stringBuffer, string, 0, 0, 1, n6);
            NotationLayoutBox notationLayoutBox3 = NotationLayoutBox.createCustomBox(layoutFormatter, stringBuffer.toString(), 4);
            notationLayoutBox3.setLineBreaker(LineBreakerFactory.newLineBreaker((int)3));
            notationLayoutBox3.setSelectionData(noHelpSD);
            layoutFormatter.incSuperscriptCount();
            notationLayoutBox2 = NotationLayoutBox.createCustomBox(layoutFormatter, "" + (n3 - 1), 4);
            notationLayoutBox2.setSelectionData(noHelpSD);
            layoutFormatter.decSuperscriptCount();
            layoutBox.addChild(notationLayoutBox3);
            if (layoutFormatter.isInProc()) {
                layoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 75));
                layoutBox.addChild(notationLayoutBox);
                layoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 51));
                layoutBox.addChild(notationLayoutBox2);
            } else {
                layoutBox.addChild(NotationLayoutBox.createNotationBox(layoutFormatter, 76));
                object = new PowerLayoutBox(notationLayoutBox, (LayoutBox)notationLayoutBox2, true, (AbstractFormatter)layoutFormatter);
                layoutBox.addChild((LayoutBox)object);
                layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)12));
            }
            object = new SelectionData(2);
            ((SelectionData)object).setContextHelpAvailable(false);
            ((SelectionData)object).setStandardEastWestArray(layoutBox);
            ((SelectionData)object).setStandardNorthSouthArray();
            layoutBox.setSelectionData((SelectionData)object);
        } else {
            int n7 = n2 + n;
            int n8 = displayPrecision >= 0 ? displayPrecision + 1 : n2;
            int n9 = 0;
            int n10 = 0;
            if (n < 0 && Math.abs(n) > n2) {
                n9 = 1;
                n10 = Math.abs(n) - n2;
            }
            if (n2 < n7) {
                for (int i = 0; i < n7 - n2; ++i) {
                    string = string + "0";
                }
            }
            if ((stringBuffer = FloatTemplate.buildFloatString(stringBuffer, string, n9, n10, n7, n8)).toString().indexOf(".") == -1) {
                if (displayPrecision <= 0) {
                    stringBuffer.append(".");
                } else {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(".");
                    for (int i = 1; i <= displayPrecision; ++i) {
                        stringBuffer2.append("0");
                    }
                    stringBuffer.append(stringBuffer2);
                }
            }
            layoutBox = NotationLayoutBox.createCustomBox(layoutFormatter, stringBuffer.toString(), 4);
            layoutBox.setLineBreaker(LineBreakerFactory.newLineBreaker((int)3));
            SelectionData selectionData = new SelectionData(2);
            selectionData.setContextHelpAvailable(false);
            selectionData.setStandardEastWestArray(layoutBox);
            selectionData.setStandardNorthSouthArray();
            layoutBox.setSelectionData(selectionData);
        }
        return layoutBox;
    }

    public static StringBuffer buildFloatString(StringBuffer stringBuffer, String string, int n, int n2, int n3, int n4) {
        int n5;
        char[] cArray = string.toCharArray();
        int n6 = cArray.length;
        int n7 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            stringBuffer.append("0");
        }
        while (n7 < n3) {
            stringBuffer.append(cArray[n7]);
            ++n7;
        }
        if (n6 != n3) {
            stringBuffer.append(".");
            for (n5 = 0; n5 < n2; ++n5) {
                stringBuffer.append("0");
            }
            while (n7 < n4) {
                if (n7 >= n6) {
                    stringBuffer.append("0");
                } else if (n7 == n4 - 1 && cArray.length > n4) {
                    String string2 = "" + cArray[n7 + 1];
                    int n8 = Integer.parseInt(string2);
                    if (n8 > 4) {
                        String string3 = "" + cArray[n7];
                        int n9 = Integer.parseInt(string3);
                        if (++n9 == 10) {
                            stringBuffer.append(0);
                            for (int i = stringBuffer.length() - 2; i > -1; --i) {
                                if (stringBuffer.charAt(i) == '.' && i > 0) {
                                    --i;
                                } else if (stringBuffer.charAt(i) == '.') {
                                    stringBuffer.insert(0, "0");
                                }
                                n9 = Integer.parseInt(stringBuffer.substring(i, i + 1));
                                if (++n9 == 10) {
                                    if (i == 0) {
                                        stringBuffer.insert(0, "10");
                                        continue;
                                    }
                                    stringBuffer.setCharAt(i, '0');
                                    continue;
                                }
                                String string4 = String.valueOf(n9);
                                stringBuffer.replace(i, i + 1, string4);
                                break;
                            }
                        } else {
                            stringBuffer.append(n9);
                        }
                    } else {
                        stringBuffer.append(cArray[n7]);
                    }
                } else {
                    stringBuffer.append(cArray[n7]);
                }
                ++n7;
            }
        }
        if (stringBuffer.charAt(0) == '.') {
            stringBuffer.insert(0, '0');
        }
        if (stringBuffer.indexOf("-.") == 0) {
            stringBuffer.insert(1, '0');
        }
        return stringBuffer;
    }

    public static int calculateExponent(Dag dag) {
        int n = 0;
        try {
            n = Integer.parseInt(dag.getData());
            n = dag.getType() == 1 ? n * -1 : n;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }
}

