/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;

public class WmiMathMLMenuParser {
    public static final String PARSER_RESOURCES = "com.maplesoft.mathdoc.components.resources.palette.parser";
    private static final String INCLUDE_ELEMENT = "<incl";
    private static final String TOOLBAR_ELEMENT = "tb";
    private static final String TOOLBAR_END_ELEMENT = "/tb";
    private static final String BUTTON_ELEMENT = "btn";
    private static final String BUTTON_END_ELEMENT = "/btn";
    private static final String SUBMENU_ELEMENT = "sub";
    private static final String SUBMENU_END_ELEMENT = "/sub";
    private static final String SEPARATOR_ELEMENT = "sep/";
    private static final String SIZE_ATTRIBUTE = "size";
    private static final String COLS_ATTRIBUTE = "cols";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CUE_ATTRIBUTE = "cue";
    private static final int DEFAULT_COLUMN_COUNT = 4;
    private String menuXML = "";
    private WmiMathMLEditorDocumentView view = null;
    private WmiMathMLEditorButtonMenu buttonMenu = null;
    private WmiResourcePackage parserPackage = null;
    private Stack infoStack = null;
    private Stack menuStack = null;
    private int buttonIndex = 0;
    private boolean ignoreSubmenu = false;
    private WmiMathMLEditorPalette currentPalette = null;
    private static ArrayList ignoreButtons = new ArrayList();

    public WmiMathMLMenuParser(WmiMenu wmiMenu, String string, WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView) {
        this.menuXML = string;
        this.view = wmiMathMLEditorDocumentView;
        this.infoStack = new Stack();
        this.menuStack = new Stack();
        MenuInfo menuInfo = new MenuInfo();
        menuInfo.menu = (WmiMathMLEditorButtonMenu)wmiMenu;
        this.menuStack.push(menuInfo);
        this.parserPackage = WmiResourcePackage.getResourcePackage(PARSER_RESOURCES);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        String[] stringArray3 = new String[]{"", "<btn></btn>", "<incl name=#standard/>", "<incl name=\"#standard\"/>", "<incl name='#standard'/>", "<incl name=#standard>", "<incl name=#standard/><incl name=#Greek/>"};
        String[] stringArray4 = new String[]{"", "<tb></tb>", "<tb><btn></btn></tb>", "<tb size=s cols=5></tb>", "<tb size='w'></tb>", "<tb cols=\"3\"></tb>"};
        String[] stringArray5 = stringArray2 = new String[]{"<tb><btn></btn></tb>", "<tb><btn>FENCESPALETTE</btn><sub cols=1><btn>DEFINT</btn></sub></tb>"};
        for (int i = 0; i < stringArray5.length; ++i) {
            WmiMathMLMenuParser wmiMathMLMenuParser = new WmiMathMLMenuParser(new WmiMenu(), stringArray5[i], new WmiMathMLEditorDocumentView());
            wmiMathMLMenuParser.parse();
        }
    }

    public void parse() {
        this.menuXML = this.processIncludes(this.menuXML);
        String[] stringArray = this.menuXML.split("[<>]");
        int n = 0;
        int n2 = stringArray.length;
        String string = stringArray[n];
        while (string.trim().equals("")) {
            string = stringArray[++n];
        }
        while (n < n2 && !string.equals(TOOLBAR_END_ELEMENT)) {
            if (string.startsWith(TOOLBAR_ELEMENT)) {
                this.parseToolbar(string);
            } else if (string.startsWith(BUTTON_ELEMENT)) {
                String string2 = stringArray[++n];
                this.parseButton(stringArray, n, string, string2);
            } else if (string.startsWith(SUBMENU_ELEMENT)) {
                this.parseSubMenu(string);
            } else if (string.startsWith(SUBMENU_END_ELEMENT)) {
                this.parseSubMenuEnd();
            } else if (!string.startsWith(BUTTON_END_ELEMENT) && string.startsWith(SEPARATOR_ELEMENT)) {
                this.addSeparator();
            }
            string = stringArray[++n];
            while (string.trim().equals("")) {
                string = stringArray[++n];
            }
        }
    }

    public String processIncludes(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (!bl) {
            n = stringBuffer.indexOf(INCLUDE_ELEMENT, n);
            n2 = stringBuffer.indexOf("=", n);
            n3 = stringBuffer.indexOf(">", n);
            String string2 = "";
            if (n >= 0 && n3 >= 0) {
                String string3;
                string2 = stringBuffer.substring(n2 + 1, n3);
                if ((string2 = this.stripQuotes(string2.trim())).startsWith("#")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if ((string3 = this.parserPackage.getStringForKey(string2)) != null) {
                    stringBuffer.delete(n, n3 + 1);
                    stringBuffer.insert(n, string3);
                    continue;
                }
                n = n3;
                continue;
            }
            bl = true;
        }
        return stringBuffer.toString();
    }

    private String stripQuotes(String string) {
        String string2 = "";
        string2 = string.replaceAll("\"", "");
        string2 = string2.replaceAll("'", "");
        return string2;
    }

    public void parseToolbar(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        LevelInfo levelInfo = new LevelInfo();
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.equals(SIZE_ATTRIBUTE)) {
                levelInfo.size = this.stripQuotes(string4);
                continue;
            }
            if (!string3.equals(COLS_ATTRIBUTE)) continue;
            try {
                levelInfo.cols = Integer.parseInt(this.stripQuotes(string4));
            }
            catch (NumberFormatException numberFormatException) {
                levelInfo.cols = 4;
            }
        }
        this.infoStack.push(levelInfo);
    }

    public void parseButton(String[] stringArray, int n, String string, String string2) {
        Object object;
        String string3;
        int n2;
        if (string2.equals(BUTTON_END_ELEMENT) || this.ignoreSubmenu) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string4 = "";
        String string5 = "";
        String string6 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            n2 = string4.indexOf("=");
            if (n2 < 0) continue;
            string3 = string4.substring(0, n2).trim();
            object = string4.substring(n2 + 1).trim();
            if (string3.equals(TYPE_ATTRIBUTE)) {
                string5 = this.stripQuotes((String)object).trim();
                continue;
            }
            if (!string3.equals(CUE_ATTRIBUTE)) continue;
            string6 = this.stripQuotes((String)object).trim();
        }
        n2 = n + 3;
        string3 = stringArray[n2];
        while (string3.trim().equals("")) {
            string3 = stringArray[++n2];
        }
        object = (LevelInfo)this.infoStack.peek();
        WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu = ((MenuInfo)this.menuStack.peek()).menu;
        if (((LevelInfo)object).newLevel && !ignoreButtons.contains(string2)) {
            if (string3.startsWith(SUBMENU_ELEMENT)) {
                WmiMathMLEditorPalette wmiMathMLEditorPalette;
                WmiMathMLEditorButtonMenu wmiMathMLEditorButtonMenu2 = new WmiMathMLEditorButtonMenu("MathMLEditorContextMenu", "com.maplesoft.mathdoc.components.resources.palette.Palette", "com/maplesoft/mathdoc/components/resources/palette/", 2, this.view, false, false, "");
                wmiMathMLEditorButtonMenu = ((MenuInfo)this.menuStack.peek()).menu;
                wmiMathMLEditorButtonMenu.replacePaletteWithMenu(wmiMathMLEditorButtonMenu2, this.view);
                MenuInfo menuInfo = new MenuInfo();
                menuInfo.menu = wmiMathMLEditorButtonMenu2;
                this.menuStack.push(menuInfo);
                ((LevelInfo)object).isMenu = true;
                ((LevelInfo)object).newLevel = false;
                ArrayList arrayList = this.currentPalette.getOriginalNameList();
                ArrayList arrayList2 = this.currentPalette.getTooltipList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    wmiMathMLEditorButtonMenu2.createMenuItemButton(arrayList.get(i).toString(), this.parserPackage, arrayList2.get(i).toString());
                }
                wmiMathMLEditorButtonMenu2.buttonMenuWindow = wmiMathMLEditorButtonMenu.buttonMenuWindow;
                ((LevelInfo)object).palette = wmiMathMLEditorPalette = wmiMathMLEditorButtonMenu2.createMenuButton(string2, this.parserPackage, string6);
                this.currentPalette = wmiMathMLEditorPalette;
            } else {
                WmiMathMLEditorPalette wmiMathMLEditorPalette = ((LevelInfo)object).palette;
                wmiMathMLEditorPalette.setColumnCount(((LevelInfo)object).cols);
                wmiMathMLEditorPalette.addItem(string2, this.parserPackage, this.buttonIndex, string6);
                ++this.buttonIndex;
            }
        } else {
            this.buttonIndex = 0;
            if (!ignoreButtons.contains(string2)) {
                if (string3.startsWith(SUBMENU_ELEMENT)) {
                    this.currentPalette = ((LevelInfo)object).palette = wmiMathMLEditorButtonMenu.createMenuButton(string2, this.parserPackage, string6);
                } else {
                    wmiMathMLEditorButtonMenu.createMenuItemButton(string2, this.parserPackage, string6);
                }
            } else if (string3.startsWith(SUBMENU_ELEMENT)) {
                this.ignoreSubmenu = true;
            }
            String string7 = ((LevelInfo)object).size;
        }
    }

    private boolean isBottomMenu(String[] stringArray, int n) {
        boolean bl = true;
        if (stringArray[n - 7].startsWith(SUBMENU_ELEMENT)) {
            return false;
        }
        int n2 = n;
        while (!stringArray[n2].equals(SUBMENU_END_ELEMENT)) {
            if (stringArray[n2].startsWith(SUBMENU_ELEMENT)) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public void parseSubMenu(String string) {
        this.buttonIndex = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        LevelInfo levelInfo = new LevelInfo();
        levelInfo.newLevel = true;
        levelInfo.palette = this.currentPalette;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.equals(SIZE_ATTRIBUTE)) {
                levelInfo.size = this.stripQuotes(string4);
                continue;
            }
            if (!string3.equals(COLS_ATTRIBUTE)) continue;
            try {
                levelInfo.cols = Integer.parseInt(this.stripQuotes(string4));
            }
            catch (NumberFormatException numberFormatException) {
                levelInfo.cols = 4;
            }
        }
        this.infoStack.push(levelInfo);
    }

    public void parseSubMenuEnd() {
        LevelInfo levelInfo = (LevelInfo)this.infoStack.pop();
        if (levelInfo.isMenu) {
            this.menuStack.pop();
        } else if (levelInfo.palette != null) {
            levelInfo.palette.configureSize(levelInfo.cols, this.buttonIndex);
        }
        this.ignoreSubmenu = false;
        this.buttonIndex = 0;
    }

    public void addSeparator() {
    }

    static {
        ignoreButtons.add("HELP");
        ignoreButtons.add("CUT");
        ignoreButtons.add("COPY");
        ignoreButtons.add("PASTE");
        ignoreButtons.add("UNDO");
        ignoreButtons.add("BIGGER");
        ignoreButtons.add("SMALLER");
        ignoreButtons.add("TOOLBOX");
        ignoreButtons.add("CHECKSYNTAX");
    }

    private class MenuInfo {
        WmiMathMLEditorButtonMenu menu;

        private MenuInfo() {
        }
    }

    private class LevelInfo {
        String size = "";
        int cols = 4;
        boolean newLevel = false;
        WmiMathMLEditorPalette palette;
        boolean isMenu = false;

        private LevelInfo() {
        }
    }
}

