/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.JTextField;

public class WmiPointProbeField
extends JTextField
implements WmiComponent {
    private static DecimalFormat formatter = new DecimalFormat();
    private static String ERROR_MESSAGE = "Point_Probe_Error";
    private WmiResourcePackage resources;
    private String errorMessage = null;
    private boolean lastUpdateWasError = false;

    private static String formatValue(double d) {
        String string = String.valueOf(d);
        formatter.applyPattern(WmiPointProbeField.getPattern(d));
        string = formatter.format(d);
        return string;
    }

    private static String getPattern(double d) {
        StringBuffer stringBuffer = new StringBuffer("0.");
        if (Math.abs(d) != 0.0) {
            int n = 2 - (int)(Math.log(d) / Math.log(10.0));
            for (int i = 0; i < Math.min(8, Math.abs(n)); ++i) {
                stringBuffer.append('#');
            }
        }
        return stringBuffer.toString();
    }

    public WmiPointProbeField(String string) {
        super(10);
        this.setEditable(false);
        this.resources = WmiResourcePackage.getResourcePackage(string);
    }

    public void update2dPoint(double d, double d2, boolean bl) {
        if (bl) {
            if (!this.lastUpdateWasError) {
                this.lastUpdateWasError = true;
                if (this.errorMessage == null) {
                    this.errorMessage = this.resources.getStringForKey(ERROR_MESSAGE);
                }
                this.setText(this.errorMessage);
            }
        } else {
            this.lastUpdateWasError = false;
            String string = this.createMessage(WmiPointProbeField.formatValue(d), WmiPointProbeField.formatValue(d2));
            this.setText(string);
        }
        this.setCaretPosition(0);
    }

    public void clear() {
        this.setText("");
        this.lastUpdateWasError = false;
    }

    private String createMessage(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = " , ";
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth("m");
        int n2 = this.getSize().width / n;
        int n3 = (n2 - string3.length()) / 2;
        stringBuffer.append(this.checkLength(string, n3, false));
        stringBuffer.append(string3);
        stringBuffer.append(this.checkLength(string2, n3, true));
        return stringBuffer.toString();
    }

    private String checkLength(String string, int n, boolean bl) {
        String string2 = string;
        int n2 = string.length();
        if (n2 < n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            char[] cArray = new char[n - n2];
            Arrays.fill(cArray, ' ');
            if (bl) {
                stringBuffer.append(cArray);
            } else {
                stringBuffer.insert(0, cArray);
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public void dispose() {
        this.errorMessage = null;
        this.resources = null;
    }
}

