/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiMenu;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class WmiPopupMenu
extends WmiMenu {
    protected JPopupMenu popup = null;

    protected WmiPopupMenu(String string, String string2) {
        super(string, string2);
        this.buildMenu();
    }

    public JPopupMenu getContextMenu() {
        if (this.popup == null) {
            this.popup = this.buildPopupMenu(this.getMenuList());
        }
        return this.popup;
    }

    public void hideContextMenu() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    protected abstract String[] getMenuList();

    public JPopupMenu buildPopupMenu(String[] stringArray) {
        return this.buildPopupMenu(stringArray, null, null);
    }

    public JPopupMenu buildPopupMenu(String[] stringArray, WmiCommand[] wmiCommandArray) {
        return this.buildPopupMenu(stringArray, wmiCommandArray, null);
    }

    public JPopupMenu buildPopupMenu(String[] stringArray, WmiCommand[] wmiCommandArray, String string) {
        this.buildMenuFromStringArray(stringArray, wmiCommandArray, string, this);
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                WmiPopupMenu.this.updateItems();
            }
        });
        return jPopupMenu;
    }

    protected void updateItems() {
        this.updateItems(this.popup);
    }

    protected void updateItems(JComponent jComponent) {
        if (jComponent != null) {
            if (jComponent instanceof JMenuItem) {
                this.updateItem((JMenuItem)jComponent);
            }
            Component[] componentArray = jComponent.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof JMenuItem) {
                    this.updateItem((JMenuItem)componentArray[i]);
                }
                if (!(componentArray[i] instanceof JMenu) && !(componentArray[i] instanceof JPopupMenu)) continue;
                this.updateItems((JComponent)componentArray[i]);
            }
            if (jComponent instanceof JMenu) {
                Component[] componentArray2 = ((JMenu)jComponent).getMenuComponents();
                for (int i = 0; i < componentArray2.length; ++i) {
                    if (componentArray2[i] instanceof JMenuItem) {
                        this.updateItem((JMenuItem)componentArray2[i]);
                    }
                    if (!(componentArray2[i] instanceof JMenu) && !(componentArray2[i] instanceof JPopupMenu)) continue;
                    this.updateItems((JComponent)componentArray2[i]);
                }
            }
        }
    }

    private void updateItem(JMenuItem jMenuItem, WmiCommand wmiCommand) {
        if (wmiCommand != null) {
            jMenuItem.setEnabled(wmiCommand.isEnabled());
            if (wmiCommand.getType() == 1) {
                jMenuItem.setSelected(wmiCommand.isSelected());
            }
        }
    }

    private void updateItem(JMenuItem jMenuItem) {
        WmiCommand wmiCommand = this.getCommandForItem(jMenuItem);
        this.updateItem(jMenuItem, wmiCommand);
    }
}

