/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.Timer;

public class WmiSmoothFadeContainer
extends Container
implements ActionListener {
    protected static final int UPDATE_INTERVAL = 10;
    protected static final float DEF_ALPHA_MIN = 0.0f;
    protected static final float DEF_ALPHA_MAX = 1.0f;
    protected static final float DEF_ALPHA_STEP = 0.2f;
    protected float alphaMin = 0.0f;
    protected float alphaMax = 1.0f;
    protected float alphaStep = 0.2f;
    private float alphaCurrent = 0.0f;
    private float alphaStepCurrent = 0.2f;
    private Timer fadeTimer;
    private boolean detachAfterHide = false;
    private WeakReference myHost = null;

    public WmiSmoothFadeContainer(Container container, boolean bl, float f, float f2, float f3) {
        if (container != null) {
            this.myHost = new WeakReference<Container>(container);
            container.add(this);
        }
        this.fadeTimer = new Timer(10, this);
        this.fadeTimer.setRepeats(true);
        this.detachAfterHide = bl;
        this.alphaMin = f;
        this.alphaMax = f2;
        this.alphaStep = f3;
        this.alphaCurrent = this.alphaMin;
        this.alphaStepCurrent = this.alphaStep;
    }

    public WmiSmoothFadeContainer(Container container, boolean bl, float f, float f2) {
        this(container, bl, f, f2, 0.2f);
    }

    public WmiSmoothFadeContainer(Container container, boolean bl) {
        this(container, bl, 0.0f, 1.0f, 0.2f);
    }

    public WmiSmoothFadeContainer(Container container) {
        this(container, false, 0.0f, 1.0f, 0.2f);
    }

    protected void detach() {
        if (this.myHost != null) {
            Container container;
            Object t = this.myHost.get();
            Container container2 = container = t instanceof Container ? (Container)t : null;
            if (container != null) {
                container.remove(this);
            }
            this.myHost = null;
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.alphaStepCurrent = this.alphaStep;
            super.setVisible(true);
        } else {
            this.alphaStepCurrent = -this.alphaStep;
        }
        if (!this.fadeTimer.isRunning()) {
            this.fadeTimer.start();
        }
    }

    public void setVisibleImmediately(boolean bl) {
        this.fadeTimer.stop();
        if (bl) {
            super.setVisible(bl);
            this.alphaStepCurrent = this.alphaStep;
            this.alphaCurrent = this.alphaMax;
        } else {
            this.alphaStepCurrent = -this.alphaStep;
            this.alphaCurrent = this.alphaMin;
        }
        this.actionPerformed(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.alphaCurrent += this.alphaStepCurrent;
        if (this.alphaCurrent > this.alphaMax && this.alphaStepCurrent > 0.0f) {
            this.alphaCurrent = this.alphaMax;
            this.fadeTimer.stop();
        } else if (this.alphaCurrent < this.alphaMin && this.alphaStepCurrent < 0.0f) {
            this.alphaCurrent = this.alphaMin;
            this.fadeTimer.stop();
            super.setVisible(false);
            if (this.detachAfterHide) {
                this.detach();
            }
        }
        if (this.isVisible()) {
            this.requestRepaint();
        }
    }

    protected void requestRepaint() {
        Container container = this.myHost != null ? (Container)this.myHost.get() : this.getParent();
        Rectangle rectangle = this.getBounds();
        if (container != null && rectangle != null) {
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D;
        boolean bl = true;
        Graphics2D graphics2D2 = graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D != null && graphics2D.getDeviceConfiguration().getColorModel().hasAlpha()) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(10, this.alphaCurrent));
            super.paint(graphics);
            graphics2D.setComposite(composite);
            bl = false;
        }
        if (bl) {
            super.paint(graphics);
        }
    }
}

