/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiStepperTarget;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class WmiStepperControl
extends JLabel
implements WmiComponent {
    public static final int DEFAULT_STEPPER_SIZE = 2;
    private static final String RESOURCE_PATH_ROOT = "com/maplesoft/mathdoc/components/resources/stepper";
    private static final String ENABLED_ICON = "/stepper_enabled.png";
    private static final String INCREMENT_ICON = "/stepper_increment.png";
    private static final String DECREMENT_ICON = "/stepper_decrement.png";
    private static final String DISABLED_ICON = "/stepper_disabled.png";
    private static final long SCROLL_DELAY_TIME = 100L;
    private static final int SCROLL_SPEED_FACTOR = 4;
    private static final String NOTIFY_THREAD_NAME = "Step Control Notifier";
    private int ctrlId = -1;
    private int ctrlSize = 2;
    private Vector targets = new Vector();
    private WmiStepperControlMouseListener mouseListener = new WmiStepperControlMouseListener();
    private boolean mouseButtonDown = false;
    private Thread notificationThread = null;
    private int scrollDirection = 0;
    private ImageIcon disabledImage = null;
    private ImageIcon enabledImage = null;
    private ImageIcon incrementImage = null;
    private ImageIcon decrementImage = null;

    public WmiStepperControl(int n, int n2) {
        this.ctrlId = n;
        this.ctrlSize = n2;
        this.loadControlImages(n2);
        this.setControlAppearance(0);
        this.addMouseListener(this.mouseListener);
    }

    public WmiStepperControl(int n) {
        this(n, 2);
    }

    public WmiStepperControl() {
        this(-1, 2);
    }

    private void setControlAppearance(int n) {
        ImageIcon imageIcon = null;
        if (this.isEnabled()) {
            switch (n) {
                case 1: {
                    imageIcon = this.incrementImage;
                    break;
                }
                case -1: {
                    imageIcon = this.decrementImage;
                    break;
                }
                default: {
                    imageIcon = this.enabledImage;
                    break;
                }
            }
        } else {
            imageIcon = this.disabledImage;
        }
        if (imageIcon != null) {
            this.setIcon(imageIcon);
            this.paintImmediately(this.getBounds());
        }
    }

    private void loadControlImages(int n) {
        String string = RESOURCE_PATH_ROOT + WmiComponentUtil.platformFolderName() + WmiComponentUtil.resourceFolderName(n);
        this.disabledImage = WmiComponentUtil.getImageIcon(string + DISABLED_ICON);
        this.enabledImage = WmiComponentUtil.getImageIcon(string + ENABLED_ICON);
        this.incrementImage = WmiComponentUtil.getImageIcon(string + INCREMENT_ICON);
        this.decrementImage = WmiComponentUtil.getImageIcon(string + DECREMENT_ICON);
    }

    public void addTarget(WmiStepperTarget wmiStepperTarget) {
        if (!this.targets.contains(wmiStepperTarget)) {
            this.targets.add(wmiStepperTarget);
        }
    }

    public void removeTarget(WmiStepperTarget wmiStepperTarget) {
        this.targets.remove(wmiStepperTarget);
    }

    private void notifyTargets() {
        long l = 0L;
        long l2 = 100L;
        while (this.mouseButtonDown) {
            l = System.currentTimeMillis();
            Iterator iterator = this.targets.iterator();
            while (iterator.hasNext()) {
                ((WmiStepperTarget)iterator.next()).stepNotify(this.ctrlId, this.scrollDirection);
            }
            while (l + l2 > System.currentTimeMillis() && this.mouseButtonDown) {
            }
            if (100L - (l2 /= 4L) * 4L <= 8L) continue;
            l2 *= 4L;
        }
    }

    public void dispose() {
        this.targets.clear();
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    private class WmiStepperControlMouseListener
    extends MouseAdapter {
        private WmiStepperControlMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle = WmiStepperControl.this.getBounds();
            int n = (int)(rectangle.getHeight() / 2.0);
            if (mouseEvent.getY() < n) {
                WmiStepperControl.this.scrollDirection = 1;
            } else {
                WmiStepperControl.this.scrollDirection = -1;
            }
            WmiStepperControl.this.setControlAppearance(WmiStepperControl.this.scrollDirection);
            WmiStepperControl.this.notificationThread = new Thread(WmiStepperControl.NOTIFY_THREAD_NAME){

                public void run() {
                    WmiStepperControl.this.notifyTargets();
                }
            };
            WmiStepperControl.this.mouseButtonDown = true;
            WmiStepperControl.this.notificationThread.setPriority(1);
            WmiStepperControl.this.notificationThread.start();
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            WmiStepperControl.this.mouseButtonDown = false;
            WmiStepperControl.this.setControlAppearance(0);
            mouseEvent.consume();
        }
    }
}

