/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.dockingtools.WmiDockException;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockable;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WmiDockableCardButtonPane
extends JPanel
implements WmiDockable {
    public static boolean buttonHighlightEnabled = true;
    public static Color highlightedButtonColor = Color.BLUE;
    public static Color unhighlightedButtonColor = Color.BLACK;
    private static final ActionListener panelSwitcher = new WmiPanelSwitcher();
    private HashMap dockedHere = new HashMap();
    protected WmiDockableTitleButton titleButton;
    protected JPanel buttonPane;
    protected JPanel contentPane;
    protected JPanel cardPane;
    protected String title;
    protected CardLayout cardControl;
    protected JButton selectedButton = null;
    protected Object dockHost;
    private JPanel filler;
    String nowShowing = null;

    public WmiDockableCardButtonPane() {
    }

    public WmiDockableCardButtonPane(String string) {
        this.buildLayout();
        this.setTitle(string);
    }

    protected void buildLayout() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.titleButton = new WmiDockableTitleButton(this);
        this.buttonPane.add((Component)this.titleButton, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.filler = new JPanel();
        this.buttonPane.add((Component)this.filler, gridBagConstraints);
        this.titleButton.setRequestFocusEnabled(false);
        this.titleButton.setFocusable(false);
        this.titleButton.addActionListener(panelSwitcher);
        this.add((Component)this.buttonPane, "North");
        this.contentPane = new WmiContentPane(this.titleButton);
        this.cardPane = new JPanel();
        this.add((Component)this.cardPane, "Center");
        this.cardControl = new CardLayout();
        this.cardPane.setLayout(this.cardControl);
    }

    public String getNameOfTopmostPane() {
        return this.nowShowing;
    }

    public void switchTo(String string) {
        WmiDockableCardButtonPane wmiDockableCardButtonPane = (WmiDockableCardButtonPane)this.dockedHere.get(string);
        wmiDockableCardButtonPane = string.equals(this.getTitle()) ? this : wmiDockableCardButtonPane;
        this.buttonHighlight(wmiDockableCardButtonPane);
        this.nowShowing = string;
        this.cardControl.show(this.cardPane, string);
    }

    protected void buttonHighlight(WmiDockableCardButtonPane wmiDockableCardButtonPane) {
        if (buttonHighlightEnabled) {
            if (this.selectedButton != null) {
                this.selectedButton.setForeground(unhighlightedButtonColor);
            }
            JButton jButton = null;
            jButton = wmiDockableCardButtonPane != null ? wmiDockableCardButtonPane.getButton() : null;
            jButton = this.getTitle().equals(wmiDockableCardButtonPane.getTitle()) ? this.getButton() : jButton;
            jButton.setForeground(highlightedButtonColor);
            this.selectedButton = jButton;
        }
    }

    public static void setButtonHighlightEnabled(boolean bl) {
        buttonHighlightEnabled = bl;
    }

    public static void setButtonHighlightColor(Color color) {
        highlightedButtonColor = color;
    }

    public static void setButtonUnHighlightColor(Color color) {
        unhighlightedButtonColor = color;
    }

    public void addPane(WmiDockableCardButtonPane wmiDockableCardButtonPane) {
        JButton jButton = wmiDockableCardButtonPane.getButton();
        wmiDockableCardButtonPane.hideButton();
        Component[] componentArray = this.buttonPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.buttonPane.remove(componentArray[i]);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        for (int i = 0; i < componentArray.length - 1; ++i) {
            this.buttonPane.add(componentArray[i], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.buttonPane.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.buttonPane.add((Component)this.filler, gridBagConstraints);
        this.buttonPane.revalidate();
        this.dockedHere.put(wmiDockableCardButtonPane.getTitle(), wmiDockableCardButtonPane);
        this.cardPane.add((Component)wmiDockableCardButtonPane.getContentPane(), wmiDockableCardButtonPane.getTitle());
        this.cardControl.last(this.cardPane);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new NullPointerException("Title cannot be null");
        }
        this.title = string;
        if (this.titleButton != null) {
            this.titleButton.setText(string);
            this.cardPane.add((Component)this.contentPane, string);
        }
    }

    public JButton getButton() {
        return this.titleButton;
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void hideButton() {
        this.remove(this.buttonPane);
    }

    public void dock(WmiDockingHost wmiDockingHost) throws WmiDockException {
        this.dock(wmiDockingHost, wmiDockingHost.getPreferredDockLocation());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dock(WmiDockingHost wmiDockingHost, int n) throws WmiDockException {
        if (!wmiDockingHost.isValidDockLocation(n)) throw new WmiDockException("Docking Host says location " + n + " is not valid.");
        if (n == 0 || n == 1) {
            this.remove(this.buttonPane);
            this.add((Component)this.buttonPane, "West");
        } else {
            this.remove(this.buttonPane);
            this.add((Component)this.buttonPane, "North");
        }
        if (wmiDockingHost.isDockOpen(n)) {
            wmiDockingHost.dock(this, n);
            this.buttonHighlight(this);
            this.dockHost = wmiDockingHost;
            return;
        } else {
            WmiDockable wmiDockable = wmiDockingHost.getDocked(n);
            if (!(wmiDockable instanceof WmiDockableCardButtonPane)) throw new WmiDockException("DockableCardButtonPane can only dock in open dock, or in a dock occupied by another DockableCardButtonPane");
            ((WmiDockableCardButtonPane)wmiDockable).addPane(this);
            ((WmiDockableCardButtonPane)wmiDockable).dockedHere.put(this.getTitle(), this);
            ((WmiDockableCardButtonPane)wmiDockable).switchTo(this.getTitle());
            this.dockHost = wmiDockable;
        }
    }

    public void undock(WmiDockingHost wmiDockingHost) {
        if (wmiDockingHost.isDocked(this)) {
            if (this.dockHost instanceof WmiDockingHost) {
                if (this.dockedHere.size() == 0) {
                    wmiDockingHost.undock(this);
                } else {
                    int n = wmiDockingHost.getWhereDocked(this);
                    Iterator iterator = this.dockedHere.values().iterator();
                    WmiDockableCardButtonPane wmiDockableCardButtonPane = this.removeHosted(this, (WmiDockableCardButtonPane)iterator.next());
                    iterator.remove();
                    wmiDockingHost.undock(this);
                    try {
                        wmiDockableCardButtonPane.dock(wmiDockingHost, n);
                        this.buttonHighlight(wmiDockableCardButtonPane);
                    }
                    catch (WmiDockException wmiDockException) {
                        wmiDockException.printStackTrace();
                    }
                    while (iterator.hasNext()) {
                        WmiDockableCardButtonPane wmiDockableCardButtonPane2 = this.removeHosted(this, (WmiDockableCardButtonPane)iterator.next());
                        iterator.remove();
                        try {
                            wmiDockableCardButtonPane2.dock(wmiDockingHost, n);
                        }
                        catch (WmiDockException wmiDockException) {
                            wmiDockException.printStackTrace();
                        }
                    }
                }
            } else if (this.dockHost instanceof WmiDockableCardButtonPane) {
                WmiDockableCardButtonPane wmiDockableCardButtonPane = (WmiDockableCardButtonPane)this.dockHost;
                this.removeHosted(wmiDockableCardButtonPane, this);
                wmiDockableCardButtonPane.dockedHere.remove(this.getTitle());
            }
        }
        this.dockHost = null;
    }

    public Iterator removeHosted() {
        Iterator iterator = null;
        ArrayList<WmiDockableCardButtonPane> arrayList = new ArrayList<WmiDockableCardButtonPane>();
        Iterator iterator2 = this.dockedHere.values().iterator();
        while (iterator2.hasNext()) {
            WmiDockableCardButtonPane wmiDockableCardButtonPane = (WmiDockableCardButtonPane)iterator2.next();
            arrayList.add(this.removeHosted(this, wmiDockableCardButtonPane));
        }
        iterator = arrayList.iterator();
        return iterator;
    }

    public void clearHosted() {
        this.dockedHere.clear();
    }

    public WmiDockableCardButtonPane removeHosted(WmiDockableCardButtonPane wmiDockableCardButtonPane, WmiDockableCardButtonPane wmiDockableCardButtonPane2) {
        wmiDockableCardButtonPane.cardPane.remove(wmiDockableCardButtonPane2.getContentPane());
        wmiDockableCardButtonPane.buttonPane.remove(wmiDockableCardButtonPane2.getButton());
        wmiDockableCardButtonPane.switchTo(wmiDockableCardButtonPane.getTitle());
        wmiDockableCardButtonPane2.buildLayout();
        return wmiDockableCardButtonPane2;
    }

    public Component getDockableComponent() {
        return this;
    }

    public boolean canStack() {
        return true;
    }

    public boolean contains(WmiDockable wmiDockable) {
        return this.dockedHere.containsValue(wmiDockable);
    }

    public void removeHostedRecord(WmiDockableCardButtonPane wmiDockableCardButtonPane) {
        this.dockedHere.remove(wmiDockableCardButtonPane.getTitle());
    }

    public static class WmiDockableTitleButton
    extends JButton {
        private WmiDockable ownerPanel;

        public WmiDockableTitleButton(WmiDockable wmiDockable) {
            this.ownerPanel = wmiDockable;
        }

        public WmiDockable getDockable() {
            return this.ownerPanel;
        }
    }

    public static class WmiContentPane
    extends JPanel {
        private JButton titleButton;

        public WmiContentPane(JButton jButton) {
            this.titleButton = jButton;
        }

        public JButton getButton() {
            return this.titleButton;
        }
    }

    public static class WmiPanelSwitcher
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            Container container = jButton = (JButton)actionEvent.getSource();
            while (!(container instanceof WmiDockableCardButtonPane)) {
                container = container.getParent();
            }
            ((WmiDockableCardButtonPane)container).switchTo(jButton.getText());
        }
    }
}

