/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.WmiDisclosureTriangle;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockException;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockable;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteDnDManager;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteStackPanel;
import com.maplesoft.util.RuntimePlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.plaf.PanelUI;

public class WmiPalette
extends JPanel
implements WmiDockable {
    private static final int LEFT_RIGHT_BORDER = 4;
    private static final int PALETTE_IMAGE_MAX_HEIGHT = 600;
    protected JLabel label = null;
    private WmiDisclosureTriangle triangle = null;
    private JComponent content;
    private boolean wasExpanded = true;
    private Dimension animatedResizeDim = null;
    private Image contentGhostImage = null;
    private int contentX = 0;
    private int contentY = 0;
    public String resourceName = null;

    public WmiPalette(String string, String string2) {
        this.resourceName = string;
        this.configurePanel();
        this.setTitle(string2);
    }

    public void configurePanel() {
        this.setUI(PaletteGroupPanelUI.getInstance());
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        JPanel jPanel = this.createUpperPanel();
        this.add((Component)jPanel, "North");
        WmiPaletteDnDManager.installDragListener(this.label, this);
    }

    private JPanel createUpperPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.triangle = new WmiDisclosureTriangle(true, 2);
        this.triangle.addActionListener(new DisclosureTriangleListener());
        jPanel.add((Component)this.triangle, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.label = new JLabel();
        this.label.setFont(this.getFont());
        this.label.setForeground(Color.WHITE);
        this.label.addMouseListener(new PaletteMouseListener());
        jPanel.add((Component)this.label, gridBagConstraints);
        return jPanel;
    }

    public String getTitle() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setTitle(String string) {
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    public void setTitleColor(Color color) {
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    public Color getTitleColor() {
        if (this.label != null) {
            return this.label.getForeground();
        }
        return null;
    }

    public void setExpanded(boolean bl) {
        this.setExpanded(bl, false);
    }

    public void setExpanded(boolean bl, boolean bl2) {
        if (this.triangle != null) {
            this.triangle.setSelected(bl);
        }
        if (this.content != null && bl != this.wasExpanded) {
            Object object;
            this.wasExpanded = bl;
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.content.getSize();
            Dimension dimension3 = new Dimension(dimension);
            if (bl) {
                this.setContent(this.content);
                dimension3.height += dimension2.height;
            } else {
                if (bl2) {
                    this.contentGhostImage = new BufferedImage(dimension2.width, dimension2.height, 2);
                    object = (Graphics2D)this.contentGhostImage.getGraphics();
                    ((Graphics)object).setColor(Color.BLUE);
                    ((Graphics)object).fillRect(0, 0, dimension2.width, dimension2.height);
                    this.content.paint((Graphics)object);
                    ((Graphics)object).dispose();
                    this.contentX = this.content.getX();
                    this.contentY = this.content.getY();
                }
                this.remove(this.content);
                dimension3.height -= dimension2.height;
            }
            if (bl2) {
                this.animateResize(dimension, dimension3);
            } else {
                this.setSize(dimension3);
                this.invalidate();
                object = this.getParent();
                if (object != null) {
                    ((Container)object).validate();
                    ((Component)object).repaint();
                }
            }
        }
    }

    public boolean isExpanded() {
        return this.triangle != null ? this.triangle.isSelected() : false;
    }

    public void setExpandEnabled(boolean bl) {
        if (this.triangle != null) {
            this.triangle.setEnabled(bl);
        }
    }

    public boolean isExpandEnabled() {
        if (this.triangle != null) {
            return this.triangle.isEnabled();
        }
        return false;
    }

    protected void setContent(JComponent jComponent) {
        this.content = jComponent;
        this.content.setOpaque(true);
        this.add((Component)this.content, "Center");
        this.content.invalidate();
        this.content.doLayout();
    }

    protected JComponent getContent() {
        return this.content;
    }

    public void paint(Graphics graphics) {
        Shape shape = null;
        if (this.animatedResizeDim != null) {
            shape = graphics.getClip();
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            if (shape != null) {
                Rectangle rectangle2 = shape.getBounds();
                SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            }
            graphics.setClip(rectangle);
        }
        super.paintComponent(graphics);
        if (this.contentGhostImage != null) {
            graphics.drawImage(this.contentGhostImage, this.contentX, this.contentY, null);
        }
        super.paintChildren(graphics);
        if (shape != null) {
            graphics.setClip(shape);
        }
    }

    protected Window getParentWindow() {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
    }

    public void dragAndDropStarted() {
    }

    public void dragAndDropEnded(boolean bl) {
        if (bl) {
            this.invalidateParent();
            this.invalidateScrollPane();
        } else {
            WmiPaletteDnDManager.cancelPaletteDrag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createImage() {
        int n = this.getWidth();
        int n2 = Math.min(this.getHeight(), 600);
        if (n <= 0) {
            n = 250;
        }
        if (n2 <= 0) {
            n2 = 14;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        Object object = this.getTreeLock();
        synchronized (object) {
            WmiPalette wmiPalette = this;
            synchronized (wmiPalette) {
                this.animatedResizeDim = new Dimension(n, n2);
                this.paint(graphics2D);
                this.animatedResizeDim = null;
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected int getContentWidth() {
        Container container = this.getParent();
        return container != null ? container.getWidth() - 8 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void animateResize(Dimension dimension, Dimension dimension2) {
        WmiPalette wmiPalette = this;
        synchronized (wmiPalette) {
            if (this.animatedResizeDim == null) {
                this.animatedResizeDim = this.getSize();
                PaletteGroupResizer paletteGroupResizer = new PaletteGroupResizer(dimension, dimension2);
                Thread thread = new Thread(paletteGroupResizer);
                thread.setName("palette animate resize thread");
                thread.start();
            }
        }
    }

    public synchronized Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public synchronized Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public synchronized Dimension getPreferredSize() {
        Dimension dimension = this.animatedResizeDim != null ? this.animatedResizeDim : super.getPreferredSize();
        dimension.width = this.getContentWidth();
        return dimension;
    }

    public synchronized Dimension getSize() {
        return this.animatedResizeDim != null ? this.animatedResizeDim : super.getSize();
    }

    public synchronized int getWidth() {
        return this.animatedResizeDim != null ? this.animatedResizeDim.width : super.getWidth();
    }

    public synchronized int getHeight() {
        return this.animatedResizeDim != null ? this.animatedResizeDim.width : super.getHeight();
    }

    protected void invalidateParent() {
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
            container.doLayout();
            container.repaint();
        }
    }

    protected void invalidateScrollPane() {
        JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (jViewport != null) {
            jViewport.invalidate();
            jViewport.doLayout();
            jViewport.repaint();
        }
    }

    public boolean canStack() {
        return false;
    }

    public boolean contains(WmiDockable wmiDockable) {
        return false;
    }

    public void dock(WmiDockingHost wmiDockingHost, int n) throws WmiDockException {
        wmiDockingHost.dock(this, n);
    }

    public void dock(WmiDockingHost wmiDockingHost) throws WmiDockException {
        this.dock(wmiDockingHost, 3);
    }

    public Component getDockableComponent() {
        return this;
    }

    public void undock(WmiDockingHost wmiDockingHost) {
    }

    private class PaletteMouseListener
    extends MouseAdapter {
        private PaletteMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = WmiPalette.this.getTreeLock();
            synchronized (object) {
                WmiPalette wmiPalette = WmiPalette.this;
                synchronized (wmiPalette) {
                    if (WmiPalette.this.animatedResizeDim == null) {
                        WmiPalette.this.setExpanded(!WmiPalette.this.isExpanded(), true);
                    }
                }
            }
        }
    }

    private class DisclosureTriangleListener
    implements ActionListener {
        private DisclosureTriangleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = WmiPalette.this.getTreeLock();
            synchronized (object) {
                WmiPalette wmiPalette = WmiPalette.this;
                synchronized (wmiPalette) {
                    if (WmiPalette.this.animatedResizeDim == null) {
                        ButtonModel buttonModel = WmiPalette.this.triangle.getModel();
                        WmiPalette.this.setExpanded(buttonModel.isSelected(), true);
                    }
                }
            }
        }
    }

    private class PaletteGroupResizer
    implements Runnable {
        private static final int ANIMATION_TIME = 100;
        private static final int FRAME_DELAY = 10;
        private static final int MIN_STEP_SIZE = 10;
        private long startTime = System.currentTimeMillis();
        private Dimension currentSize = null;
        private Dimension targetSize = null;

        public PaletteGroupResizer(Dimension dimension, Dimension dimension2) {
            this.currentSize = dimension;
            this.targetSize = dimension2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WmiPaletteStackPanel wmiPaletteStackPanel;
            Dimension dimension = new Dimension(this.currentSize);
            float f = 10.0f;
            float f2 = this.targetSize.width - dimension.width;
            float f3 = this.targetSize.height - dimension.height;
            f2 /= f;
            f3 /= f;
            f2 = this.checkStepSize(f2);
            f3 = this.checkStepSize(f3);
            Container container = WmiPalette.this.getParent();
            WmiPaletteStackPanel wmiPaletteStackPanel2 = wmiPaletteStackPanel = container instanceof WmiPaletteStackPanel ? (WmiPaletteStackPanel)container : null;
            if (wmiPaletteStackPanel != null) {
                wmiPaletteStackPanel.setChildResizing(true);
            }
            try {
                int n = 0;
                while ((float)n < f) {
                    long l = System.currentTimeMillis();
                    float f4 = (l -= this.startTime) / 10L;
                    this.resize(f2, f3, f4, dimension);
                    if (((WmiPalette)WmiPalette.this).animatedResizeDim.width == this.targetSize.width && ((WmiPalette)WmiPalette.this).animatedResizeDim.height == this.targetSize.height) {
                        break;
                    }
                    Thread.sleep(10L);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                WmiPalette.this.animatedResizeDim = null;
                WmiPalette.this.contentGhostImage = null;
                if (wmiPaletteStackPanel != null) {
                    wmiPaletteStackPanel.setChildResizing(false);
                }
            }
            this.scrollToVisible();
        }

        private float checkStepSize(float f) {
            f = f > 0.0f ? Math.max(10.0f, f) : Math.min(-10.0f, f);
            return f;
        }

        private void resize(float f, float f2, float f3, Dimension dimension) {
            ((WmiPalette)WmiPalette.this).animatedResizeDim.height = dimension.height + (int)(f2 * f3);
            ((WmiPalette)WmiPalette.this).animatedResizeDim.height = f2 > 0.0f ? Math.min(((WmiPalette)WmiPalette.this).animatedResizeDim.height, this.targetSize.height) : Math.max(((WmiPalette)WmiPalette.this).animatedResizeDim.height, this.targetSize.height);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WmiPalette.this.invalidate();
                    WmiPalette.this.invalidateParent();
                }
            });
        }

        private void scrollToVisible() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WmiPalette.this.invalidateParent();
                    JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = WmiPalette.class$("javax.swing.JViewport")) : class$javax$swing$JViewport, WmiPalette.this);
                    if (jViewport != null) {
                        int n = WmiPalette.this.getY() + WmiPalette.this.getHeight();
                        Rectangle rectangle = jViewport.getViewRect();
                        int n2 = n - (rectangle.y + rectangle.height);
                        if (n2 > 0) {
                            jViewport.setViewPosition(new Point(0, rectangle.y + n2));
                        }
                    }
                    WmiPalette.this.invalidateScrollPane();
                    WmiPalette.this.invalidate();
                    WmiPalette.this.validate();
                }
            });
        }
    }

    public static class PaletteGroupPanelUI
    extends PanelUI {
        private static PaletteGroupPanelUI instance = null;
        private static final int ROUNDNESS = RuntimePlatform.isMac() ? 15 : 8;

        private PaletteGroupPanelUI() {
        }

        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            Font font = jComponent.getFont();
            float f = 0.0f;
            f = RuntimePlatform.isMac() ? 10.0f : 11.0f;
            font = font.deriveFont(f);
            jComponent.setFont(font);
            jComponent.setOpaque(true);
            jComponent.setBorder(BorderFactory.createEmptyBorder(5, 4, 5, 4));
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            this.paint(graphics, jComponent.getSize(), jComponent.getForeground(), false);
        }

        public void paint(Graphics graphics, Dimension dimension, Color color, boolean bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color2 = graphics2D.getColor();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setColor(color);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint paint = graphics2D.getPaint();
            if (RuntimePlatform.isMac()) {
                Color color3 = bl ? Color.DARK_GRAY : Color.LIGHT_GRAY;
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, bl ? Color.BLACK : Color.WHITE, 0.0f, 10.0f, color3);
                Shape shape = graphics2D.getClip();
                Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, 10);
                if (shape instanceof Rectangle) {
                    rectangle = rectangle.intersection((Rectangle)shape);
                }
                graphics2D.setClip(rectangle);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRoundRect(0, 0, dimension.width - 1, dimension.height - 1, ROUNDNESS, ROUNDNESS);
                rectangle = new Rectangle(0, 10, dimension.width - 1, dimension.height - 11);
                if (shape instanceof Rectangle) {
                    rectangle = rectangle.intersection((Rectangle)shape);
                }
                graphics2D.setClip(rectangle);
                gradientPaint = new GradientPaint(0.0f, 10.0f, color3, 0.0f, 20.0f, color3.brighter());
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRoundRect(0, 0, dimension.width - 1, dimension.height - 1, ROUNDNESS, ROUNDNESS);
                graphics2D.setClip(shape);
            } else {
                Color color4 = bl ? Color.GRAY : Color.LIGHT_GRAY;
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color4.brighter(), 0.0f, 20.0f, color4);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRoundRect(0, 0, dimension.width - 1, dimension.height - 1, ROUNDNESS, ROUNDNESS);
            }
            graphics2D.setPaint(paint);
            graphics2D.drawRoundRect(0, 0, dimension.width - 1, dimension.height - 1, ROUNDNESS, ROUNDNESS);
            graphics2D.setColor(color2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public static PaletteGroupPanelUI getInstance() {
            if (instance == null) {
                instance = new PaletteGroupPanelUI();
            }
            return instance;
        }
    }
}

