/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.dockingtools.WmiBorderSplitPane;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteStackPanel;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WmiPaletteDnDManager {
    private static final String PALETTE_DRAG_MIME_TYPE = "application/x-java-serialized-object;class=java.io.Serializable";
    private static final Transferable PALETTE_DRAG_TRANSFERABLE = new PaletteTransferable();
    public static final DataFlavor PALETTE_DRAG_FLAVOR = new DataFlavor("application/x-java-serialized-object;class=java.io.Serializable", "Maple Palette");
    public static final FlavorMap PALETTE_DRAG_FLAVOR_MAP = new PaletteFlavorMap();
    private static WmiPalette dragPalette = null;
    private static WmiPaletteStackPanel dragOriginPanel = null;
    private static WmiPaletteStackPanel dropTargetPanel = null;
    private static WmiBorderSplitPane dragOriginSplitPane = null;
    private static boolean splitPaneEastCollapsed = false;
    private static boolean splitPaneWestCollapsed = false;
    private static int dragOriginIndex = -1;
    private static boolean paletteDragAccepted = false;
    private static Window dragPaletteOriginWindow = null;

    private WmiPaletteDnDManager() {
    }

    public static void installDragListener(JComponent jComponent, WmiPalette wmiPalette) {
        PaletteDragListener paletteDragListener = new PaletteDragListener(wmiPalette);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(jComponent, 2, paletteDragListener);
    }

    public static WmiPalette getDraggedPalette() {
        return dragPalette;
    }

    public static Window getDraggedPaletteOriginWindow() {
        return dragPaletteOriginWindow;
    }

    public static Transferable startPaletteDrag(final WmiPalette wmiPalette) {
        dragPalette = wmiPalette;
        dropTargetPanel = dragOriginPanel = (WmiPaletteStackPanel)SwingUtilities.getAncestorOfClass(WmiPaletteStackPanel.class, wmiPalette);
        if (dragOriginPanel != null && (dragOriginSplitPane = (WmiBorderSplitPane)SwingUtilities.getAncestorOfClass(WmiBorderSplitPane.class, dragOriginPanel)) != null) {
            splitPaneEastCollapsed = dragOriginSplitPane.isCollapsed(2);
            splitPaneWestCollapsed = dragOriginSplitPane.isCollapsed(3);
            if (splitPaneEastCollapsed) {
                dragOriginSplitPane.setCollapsed(2, false);
            }
            if (splitPaneWestCollapsed) {
                dragOriginSplitPane.setCollapsed(3, false);
            }
        }
        dragPaletteOriginWindow = wmiPalette.getParentWindow();
        if (dragOriginPanel != null) {
            dragOriginIndex = dragOriginPanel.getComponentIndexWhereDocked(wmiPalette);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dragOriginPanel.undock(wmiPalette, true);
                }
            });
        }
        return PALETTE_DRAG_TRANSFERABLE;
    }

    public static void dragEntered(WmiPaletteStackPanel wmiPaletteStackPanel) {
        if (wmiPaletteStackPanel != dropTargetPanel) {
            if (dropTargetPanel != null) {
                dropTargetPanel.dragExited();
            }
            dropTargetPanel = wmiPaletteStackPanel;
        }
    }

    private static void endPaletteDrag(WmiDockingHost wmiDockingHost) {
        if (dragOriginSplitPane != null) {
            Component component = dragOriginSplitPane.getFromLocation(2);
            if (splitPaneEastCollapsed && component != wmiDockingHost) {
                dragOriginSplitPane.setCollapsed(2, splitPaneEastCollapsed);
            }
            Component component2 = dragOriginSplitPane.getFromLocation(3);
            if (splitPaneWestCollapsed && component2 != wmiDockingHost) {
                dragOriginSplitPane.setCollapsed(3, splitPaneWestCollapsed);
            }
        }
        dropTargetPanel = null;
        dragPalette = null;
        dragOriginPanel = null;
        dragOriginIndex = -1;
        paletteDragAccepted = false;
        dragOriginSplitPane = null;
    }

    public static void acceptPaletteDrag(WmiDockingHost wmiDockingHost) {
        paletteDragAccepted = true;
        WmiPaletteDnDManager.endPaletteDrag(wmiDockingHost);
    }

    public static void cancelPaletteDrag() {
        if (dragOriginPanel != null) {
            dragOriginPanel.dockComponentAtIndex(dragPalette, dragOriginIndex);
        }
        if (dropTargetPanel != null) {
            dropTargetPanel.dragExited();
        }
        WmiPaletteDnDManager.endPaletteDrag(null);
    }

    private static class PaletteFlavorMap
    implements FlavorMap {
        private PaletteFlavorMap() {
        }

        public Map getFlavorsForNatives(String[] stringArray) {
            HashMap<String, DataFlavor> hashMap = new HashMap<String, DataFlavor>(1);
            hashMap.put(WmiPaletteDnDManager.PALETTE_DRAG_MIME_TYPE, PALETTE_DRAG_FLAVOR);
            return hashMap;
        }

        public Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
            HashMap<DataFlavor, String> hashMap = new HashMap<DataFlavor, String>(1);
            hashMap.put(PALETTE_DRAG_FLAVOR, WmiPaletteDnDManager.PALETTE_DRAG_MIME_TYPE);
            return hashMap;
        }
    }

    private static class PaletteTransferable
    implements Transferable {
        private PaletteTransferable() {
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return dataFlavor == PALETTE_DRAG_FLAVOR && dragPalette != null ? "Maple Palette" : null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PALETTE_DRAG_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == PALETTE_DRAG_FLAVOR;
        }
    }

    private static class PaletteDragListener
    implements DragGestureListener,
    DragSourceListener {
        private WmiPalette palette = null;

        public PaletteDragListener(WmiPalette wmiPalette) {
            this.palette = wmiPalette;
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
            if (inputEvent instanceof MouseEvent && ((MouseEvent)inputEvent).getButton() == 1) {
                Object object;
                Transferable transferable = WmiPaletteDnDManager.startPaletteDrag(this.palette);
                Component component = dragGestureEvent.getComponent();
                if (component instanceof AbstractButton) {
                    object = ((AbstractButton)component).getModel();
                    object.setArmed(false);
                    object.setPressed(false);
                }
                if (DragSource.isDragImageSupported()) {
                    object = this.palette.createImage();
                    Point point = new Point(dragGestureEvent.getDragOrigin());
                    point.x = -point.x;
                    point.y = -point.y;
                    while (component != this.palette && component != null) {
                        point.x -= component.getX();
                        point.y -= component.getY();
                        component = component.getParent();
                    }
                    if (component != this.palette) {
                        point.x = -((Image)object).getWidth(null);
                        point.y = -((Image)object).getHeight(null);
                    }
                    dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, (Image)object, point, transferable, this);
                } else {
                    dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable, this);
                }
                this.palette.dragAndDropStarted();
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.palette.dragAndDropEnded(paletteDragAccepted);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

