/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.controller.insert.WmiInsertEntityCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import java.awt.Component;

public class WmiMathMLContentInsertionController {
    public static WmiMathMLEditorDocumentView componentToView(Component component) {
        WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView = null;
        while (component.getParent() != null && !(component instanceof WmiMathMLEditorButtonMenu.WmiMathMLButtonMenuPanel) && !(component instanceof WmiMathMLEditorPalette)) {
            component = component.getParent();
        }
        if (component instanceof WmiMathMLEditorButtonMenu.WmiMathMLButtonMenuPanel) {
            wmiMathMLEditorDocumentView = ((WmiMathMLEditorButtonMenu.WmiMathMLButtonMenuPanel)component).getPaletteManager().getView();
        } else if (component instanceof WmiMathMLEditorPalette) {
            wmiMathMLEditorDocumentView = ((WmiMathMLEditorPalette)component).getPaletteManager().getView();
        }
        return wmiMathMLEditorDocumentView;
    }

    private static void insertInMathOrText(WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView, String string, WmiModelTag wmiModelTag) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (string.startsWith("<mrow>")) {
            WmiInsertMathMLCommand wmiInsertMathMLCommand = WmiInsertMathMLCommand.DEFAULT_MATHML_INSERTER;
            wmiInsertMathMLCommand.doInsertionCommand(wmiMathMLEditorDocumentView, string);
        } else {
            WmiInsertEntityCommand wmiInsertEntityCommand = WmiInsertEntityCommand.DEFAULT_ENTITY_INSERTER;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('&');
            stringBuffer.append(string);
            stringBuffer.append(';');
            wmiInsertEntityCommand.insert(wmiMathMLEditorDocumentView, stringBuffer.toString());
        }
    }

    public static void insertPaletteContent(Component component, String string) {
        WmiMathMLContentInsertionController.insertPaletteContent(component, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertPaletteContent(Component component, String string, WmiModelTag wmiModelTag) {
        WmiMathDocumentModel wmiMathDocumentModel;
        WmiMathMLEditorDocumentView wmiMathMLEditorDocumentView = WmiMathMLContentInsertionController.componentToView(component);
        if (wmiMathMLEditorDocumentView != null && WmiModelLock.writeLock(wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathMLEditorDocumentView.getModel(), true)) {
            try {
                WmiMathMLContentInsertionController.insertInMathOrText(wmiMathMLEditorDocumentView, string, wmiModelTag);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
    }
}

