/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiControllerBuilder;
import com.maplesoft.mathdoc.controller.WmiReflectingControllerBuilder;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import com.maplesoft.mathdoc.model.math.WmiMathEncloseModel;
import com.maplesoft.mathdoc.view.WmiAggregateSelection;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMetatagWrapperView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiReflectingViewBuilder;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTableCellView;
import com.maplesoft.mathdoc.view.WmiTableColumnView;
import com.maplesoft.mathdoc.view.WmiTableRowView;
import com.maplesoft.mathdoc.view.WmiTableView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewBuilder;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import com.maplesoft.mathdoc.view.math.WmiFractionView;
import com.maplesoft.mathdoc.view.math.WmiMathAlignGroupView;
import com.maplesoft.mathdoc.view.math.WmiMathAlignMarkView;
import com.maplesoft.mathdoc.view.math.WmiMathAmbiguousView;
import com.maplesoft.mathdoc.view.math.WmiMathEncloseView;
import com.maplesoft.mathdoc.view.math.WmiMathGlyphView;
import com.maplesoft.mathdoc.view.math.WmiMathIdentifierView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathPaddedView;
import com.maplesoft.mathdoc.view.math.WmiMathPhantomView;
import com.maplesoft.mathdoc.view.math.WmiMathSpaceView;
import com.maplesoft.mathdoc.view.math.WmiMathTableCellView;
import com.maplesoft.mathdoc.view.math.WmiMathTableLabeledRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiMultiscriptView;
import com.maplesoft.mathdoc.view.math.WmiOverView;
import com.maplesoft.mathdoc.view.math.WmiRootView;
import com.maplesoft.mathdoc.view.math.WmiSubSupView;
import com.maplesoft.mathdoc.view.math.WmiSubscriptView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiUnderOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderView;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JViewport;

public abstract class WmiAbstractViewFactory
implements WmiViewFactory {
    protected static final String DEFAULT_VIEW_PACKAGE_NAME = "com.maplesoft.mathdoc.view";
    protected static final String COMPOSED_VIEW_CLASS_NAME = "WmiArrayCompositeView";
    protected static final String MODEL_CLASS_NAME = "com.maplesoft.mathdoc.model.WmiModel";
    private static final Class[] CONSTRUCTOR_ARGS = new Class[2];
    private WmiMathDocumentView root = null;
    private HashMap undoMap;
    private HashMap redoMap;
    private ArrayList pending = new ArrayList();
    private WmiUndoableEdit undoEdit = null;
    private WmiUndoableEdit redoEdit = null;
    private WmiUndoableEdit activeEdit = null;
    private WmiSelectionBuilder selectionBuilder = null;

    protected WmiAbstractViewFactory() {
        this.initialize();
        this.undoMap = new HashMap();
        this.redoMap = new HashMap();
        this.addViewMapping(WmiModelTag.PARAGRAPH, new ParagraphBuilder());
        this.addViewMapping(WmiModelTag.TEXT, new TextBuilder());
        this.addViewMapping(WmiModelTag.COMPOSED, new ComposedBuilder());
        this.addViewMapping(WmiModelTag.METATAG_WRAPPER, new MetatagBuilder());
        this.addViewMapping(WmiModelTag.TABLE, new TableBuilder());
        this.addViewMapping(WmiModelTag.TABLE_ROW, new TableRowBuilder());
        this.addViewMapping(WmiModelTag.TABLE_COLUMN, new TableColumnBuilder());
        this.addViewMapping(WmiModelTag.TABLE_CELL, new TableCellBuilder());
        this.addViewMapping(WmiModelTag.MATH, new InlineBuilder());
        this.addViewMapping(WmiModelTag.MATH_ROW, new MathInlineBuilder());
        this.addViewMapping(WmiModelTag.MATH_ENCLOSE, new MathEncloseBuilder());
        this.addViewMapping(WmiModelTag.MATH_FENCED, new MathFencedBuilder());
        this.addViewMapping(WmiModelTag.MATH_FRAC, new FractionBuilder());
        this.addViewMapping(WmiModelTag.MATH_AMBIGUOUS, new AmbiguousBuilder());
        this.addViewMapping(WmiModelTag.MATH_NROOT, new RootBuilder());
        this.addViewMapping(WmiModelTag.MATH_SQUARE_ROOT, new RootBuilder());
        this.addViewMapping(WmiModelTag.MATH_SUPERSCRIPT, new SuperscriptBuilder());
        this.addViewMapping(WmiModelTag.MATH_SUBSCRIPT, new SubscriptBuilder());
        this.addViewMapping(WmiModelTag.MATH_UNDER_OVER, new UnderOverBuilder());
        this.addViewMapping(WmiModelTag.MATH_OVER, new OverBuilder());
        this.addViewMapping(WmiModelTag.MATH_UNDER, new UnderBuilder());
        this.addViewMapping(WmiModelTag.MATH_SUB_SUP, new SubSupBuilder());
        this.addViewMapping(WmiModelTag.MATH_OPERATOR, new OperatorBuilder());
        this.addViewMapping(WmiModelTag.MATH_IDENTIFIER, new IdentifierBuilder());
        this.addViewMapping(WmiModelTag.MATH_PADDED, new PaddedBuilder());
        this.addViewMapping(WmiModelTag.MATH_PHANTOM, new PhantomBuilder());
        this.addViewMapping(WmiModelTag.MATH_PROXY_LABEL, new TextBuilder());
        this.addViewMapping(WmiModelTag.MATH_SPACE, new SpaceBuilder());
        this.addViewMapping(WmiModelTag.MATH_STYLE, new MathInlineBuilder());
        this.addViewMapping(WmiModelTag.MATH_TEXT, new MathTextBuilder());
        this.addViewMapping(WmiModelTag.MATH_ERROR, new MathInlineBuilder());
        this.addViewMapping(WmiModelTag.MATH_STRING, new MathTextBuilder());
        this.addViewMapping(WmiModelTag.MATH_TABLE, new MathTableBuilder());
        this.addViewMapping(WmiModelTag.MATH_TABLE_ROW, new MathTableRowBuilder());
        this.addViewMapping(WmiModelTag.MATH_TABLE_LABELED_ROW, new MathTableLabeledRowBuilder());
        this.addViewMapping(WmiModelTag.MATH_TABLE_CELL, new MathTableCellBuilder());
        this.addViewMapping(WmiModelTag.MATH_ALIGN_GROUP, new MathAlignGroupBuilder());
        this.addViewMapping(WmiModelTag.MATH_ALIGN_MARK, new MathAlignMarkBuilder());
        this.addViewMapping(WmiModelTag.MATH_TABLE_CELL, new MathTableCellBuilder());
        this.addViewMapping(WmiModelTag.MATH_NUMERIC, new MathTextBuilder());
        this.addViewMapping(WmiModelTag.MATH_ACTION, new MathInlineBuilder());
        this.addViewMapping(WmiModelTag.MATH_MULTISCRIPTS, new MathMultiscriptBuilder());
        this.addViewMapping(WmiModelTag.MATH_PRESCRIPTS, new MathPrescriptBuilder());
        this.addViewMapping(WmiModelTag.MATH_NONE, new MathNoneBuilder());
        this.addViewMapping(WmiModelTag.MATH_GLYPH, new GlyphBuilder());
        this.addViewMapping(WmiModelTag.TEXT_CONTAINER, new WmiReflectingViewBuilder("com.maplesoft.mathdoc.view.WmiTextContainerView"));
        String string = "com.maplesoft.mathdoc.controller.";
        String string2 = "com.maplesoft.mathdoc.controller.metadata.";
        WmiReflectingControllerBuilder wmiReflectingControllerBuilder = new WmiReflectingControllerBuilder(string + "WmiTextController");
        this.addControllerMapping(WmiModelTag.TEXT, wmiReflectingControllerBuilder);
        this.addControllerMapping(WmiModelTag.PARAGRAPH, new WmiReflectingControllerBuilder(string + "WmiParagraphController"));
        this.addControllerMapping(WmiModelTag.PLOT, new WmiReflectingControllerBuilder(string + "WmiContainerController"));
        this.addControllerMapping(WmiModelTag.METATAG_WRAPPER, new WmiReflectingControllerBuilder(string2 + "WmiMetatagController"));
        WmiReflectingControllerBuilder wmiReflectingControllerBuilder2 = new WmiReflectingControllerBuilder(string + "WmiMathController");
        this.setMathController(wmiReflectingControllerBuilder2);
        this.selectionBuilder = new WmiSelectionBuilder(this.root);
    }

    public WmiSelectionBuilder getSelectionBuilder() {
        return this.selectionBuilder;
    }

    public void setMathController(WmiControllerBuilder wmiControllerBuilder) {
        this.addControllerMapping(WmiModelTag.MATH_AMBIGUOUS, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_ROW, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_FENCED, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_FRAC, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_NROOT, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_SQUARE_ROOT, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_SUPERSCRIPT, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_SUBSCRIPT, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_STYLE, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_UNDER_OVER, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_OVER, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_UNDER, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_SUB_SUP, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_OPERATOR, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_IDENTIFIER, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_PADDED, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_PHANTOM, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_PROXY_LABEL, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_SPACE, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_TEXT, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_ERROR, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_STRING, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_TABLE, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_TABLE_ROW, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_TABLE_CELL, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_NUMERIC, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_ACTION, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_MULTISCRIPTS, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_PRESCRIPTS, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_NONE, wmiControllerBuilder);
        this.addControllerMapping(WmiModelTag.MATH_GLYPH, wmiControllerBuilder);
    }

    public void releaseFactory() {
        if (this.undoMap != null) {
            this.undoMap.clear();
            this.undoMap = null;
        }
        if (this.redoMap != null) {
            this.redoMap.clear();
            this.redoMap = null;
        }
        if (this.pending != null) {
            this.pending.clear();
            this.pending = null;
        }
        this.undoEdit = null;
        this.redoEdit = null;
        this.activeEdit = null;
        this.root = null;
        if (this.selectionBuilder != null) {
            this.selectionBuilder.setDocument(null);
            this.selectionBuilder = null;
        }
    }

    public WmiViewFactory copyFactory() {
        WmiAbstractViewFactory wmiAbstractViewFactory = null;
        try {
            wmiAbstractViewFactory = (WmiAbstractViewFactory)this.clone();
            wmiAbstractViewFactory.undoMap = new HashMap();
            wmiAbstractViewFactory.redoMap = new HashMap();
            wmiAbstractViewFactory.pending = new ArrayList();
            wmiAbstractViewFactory.undoEdit = null;
            wmiAbstractViewFactory.redoEdit = null;
            wmiAbstractViewFactory.activeEdit = null;
            wmiAbstractViewFactory.root = null;
            wmiAbstractViewFactory.selectionBuilder = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WmiErrorLog.log(cloneNotSupportedException);
        }
        return wmiAbstractViewFactory;
    }

    protected abstract void initialize();

    protected abstract Object getBuilder(WmiModelTag var1);

    public abstract WmiController getController(WmiView var1);

    public abstract void addViewMapping(WmiModelTag var1, WmiViewBuilder var2);

    public abstract void addViewMapping(WmiModelTag var1, Constructor var2);

    public abstract void addControllerMapping(WmiModelTag var1, WmiControllerBuilder var2);

    public WmiView createView(WmiModel wmiModel, WmiCompositeView wmiCompositeView) throws WmiNoReadAccessException {
        Object object;
        WmiModelTag wmiModelTag;
        WmiView wmiView = null;
        if (wmiModel != null && (wmiModelTag = wmiModel.getTag()) != null && (object = this.getBuilder(wmiModelTag)) != null) {
            try {
                if (object instanceof WmiViewBuilder) {
                    wmiView = ((WmiViewBuilder)object).createView(wmiModel, this.root);
                } else if (object instanceof Constructor) {
                    Constructor constructor = (Constructor)object;
                    Object[] objectArray = new Object[]{wmiModel, this.root};
                    wmiView = (WmiView)constructor.newInstance(objectArray);
                } else {
                    WmiErrorLog.log(new Exception("failed to create view for " + wmiModelTag));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WmiErrorLog.log(illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                WmiErrorLog.log(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                WmiErrorLog.log(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                WmiErrorLog.log(invocationTargetException);
            }
        }
        if (wmiView != null && wmiCompositeView != null) {
            wmiView.setParentView(wmiCompositeView);
            wmiView.updateView();
            if (wmiView instanceof WmiPositionedView) {
                ((WmiPositionedView)wmiView).forceRepaint();
            }
        }
        return wmiView;
    }

    public void releaseView(WmiView wmiView) {
    }

    public void createNotify(WmiModel wmiModel) throws WmiNoReadAccessException {
        this.createView(wmiModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCompleteNotify(WmiModel wmiModel) {
        Object object = this.root.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.pending.size(); ++i) {
                try {
                    WmiView wmiView = (WmiView)this.pending.get(i);
                    if (wmiView.getModel() == null || wmiView.isContentValid()) continue;
                    wmiView.updateView();
                    continue;
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
        }
        this.root.layoutView();
        this.root.updateNotify();
        if (this.undoEdit != null || this.redoEdit != null) {
            object = (WmiUndoablePositionMarker)(this.undoEdit != null ? this.undoMap.get(this.undoEdit) : this.redoMap.get(this.redoEdit));
            if (object != null) {
                try {
                    ((WmiUndoablePositionMarker)object).updatePosition();
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                    this.root.setPositionMarker(null);
                    this.root.setSelection(null);
                }
            } else {
                this.root.setPositionMarker(null);
                this.root.setSelection(null);
            }
        } else {
            WmiSelection wmiSelection;
            object = this.root.getPositionMarker();
            if (object != null) {
                try {
                    object.resync();
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
            if ((wmiSelection = this.root.getSelection()) != null) {
                try {
                    wmiSelection.resync();
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
        }
        if (this.activeEdit != null) {
            this.redoMap.put(this.activeEdit, new WmiUndoablePositionMarker());
            this.activeEdit = null;
        }
        this.redoEdit = null;
        this.undoEdit = null;
        this.pending.clear();
    }

    public void updateBeginNotify(WmiModel wmiModel) {
        WmiPositionMarker wmiPositionMarker = this.root.getPositionMarker();
        if (wmiPositionMarker != null) {
            wmiPositionMarker.hide();
        }
        this.pending.clear();
    }

    public void updateNotify(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiView wmiView = null;
        WmiModelObserver wmiModelObserver = wmiModel != null ? wmiModel.getObserver() : null;
        boolean bl = true;
        while (wmiModelObserver != null) {
            if (wmiModelObserver instanceof WmiView) {
                WmiView wmiView2 = (WmiView)((Object)wmiModelObserver);
                if (wmiView2.getModel() == wmiModel && wmiView2.getDocumentView() == this.root) {
                    if (wmiView == null) {
                        wmiView = wmiView2;
                        bl = false;
                    } else if (wmiModel.getParent() != null) {
                        wmiView = null;
                        bl = true;
                        break;
                    }
                } else if (wmiView2.getModel() == null) {
                    WmiModelObserver wmiModelObserver2 = wmiModelObserver.getNextObserver();
                    wmiModel.releaseObserver(wmiModelObserver);
                    wmiModelObserver = wmiModelObserver2;
                    continue;
                }
            }
            wmiModelObserver = wmiModelObserver.getNextObserver();
        }
        if (bl && wmiModel != null) {
            this.updateNotify(wmiModel.getParent());
        }
        if (wmiView != null) {
            if (wmiView.getParentView() == this.root) {
                wmiView = this.root;
            }
            wmiView.invalidate(2);
            wmiView.invalidate(1);
            this.pending.add(wmiView);
        }
    }

    public void createEditNotify(WmiUndoableEdit wmiUndoableEdit) {
        this.activeEdit = wmiUndoableEdit;
        this.undoMap.put(wmiUndoableEdit, new WmiUndoablePositionMarker());
    }

    public void endEditNotify(WmiUndoableEdit wmiUndoableEdit) {
        this.redoMap.put(wmiUndoableEdit, new WmiUndoablePositionMarker());
    }

    public void releaseEditNotify(WmiUndoableEdit wmiUndoableEdit) {
        if (wmiUndoableEdit != null) {
            this.undoMap.remove(wmiUndoableEdit);
            this.redoMap.remove(wmiUndoableEdit);
        }
    }

    public void undoNotify(WmiUndoableEdit wmiUndoableEdit) {
        this.undoEdit = wmiUndoableEdit;
    }

    public void redoNotify(WmiUndoableEdit wmiUndoableEdit) {
        this.redoEdit = wmiUndoableEdit;
    }

    public void positionUpdateNotify(WmiModel wmiModel, int n, boolean bl) throws WmiNoReadAccessException {
        Object object;
        int n2;
        Object object2 = WmiViewUtil.modelToView(this.root, wmiModel, n);
        while (object2 == null && wmiModel instanceof WmiCompositeModel && (n2 = (object = (WmiCompositeModel)wmiModel).getChildCount()) > 0) {
            wmiModel = object.getChild(n == 0 ? 0 : n2 - 1);
            object2 = WmiViewUtil.modelToView(this.root, wmiModel, 0);
        }
        if (bl) {
            if (wmiModel instanceof WmiTextModel) {
                if (object2 != null && (object = object2.getDocumentView()) != null) {
                    WmiCaret wmiCaret = ((WmiMathDocumentView)object).getCaret();
                    if (wmiCaret != null) {
                        if (((WmiMathDocumentView)object).getSelection() != null) {
                            ((WmiMathDocumentView)object).setSelection(null);
                        }
                        wmiCaret.updateMarkerPosition(wmiModel, n);
                    }
                    if ((wmiCaret = ((WmiMathDocumentView)object).getCaret()) != null) {
                        wmiCaret.scrollVisible();
                    }
                }
            } else {
                while (object2 instanceof WmiCompositeView && !WmiViewUtil.isTraversableView((WmiView)object2)) {
                    if (object2 instanceof WmiSwitchableCompositeView && (object = ((WmiSwitchableCompositeView)object2).getRootPhysicalView()) != null) {
                        object2 = object;
                    }
                    if ((n2 = (object = (WmiCompositeView)object2).getChildCount()) <= 0) break;
                    if (n == 0) {
                        object2 = object.getChild(0);
                        continue;
                    }
                    object2 = object.getChild(object.getChildCount() - 1);
                }
                if (object2 instanceof WmiPositionedView) {
                    ((WmiPositionedView)object2).setPositionMarker(n);
                }
                if ((object = this.root.getPositionMarker()) != null) {
                    object.scrollVisible();
                }
            }
        } else if (object2 instanceof WmiPositionedView) {
            JViewport jViewport;
            object = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)object2);
            Rectangle rectangle = this.root.getVisibleRegion();
            Container container = this.root.getParent();
            if (container instanceof JViewport && (jViewport = (JViewport)container) != null) {
                int n3 = ((Point)object).y;
                int n4 = n3 + ((WmiPositionedView)object2).getHeight();
                int n5 = rectangle.y;
                int n6 = n5 + rectangle.height;
                int n7 = n4 - rectangle.height;
                if (n7 < n5) {
                    n7 = n5;
                }
                if (n4 > n6 && n7 != n5) {
                    jViewport.setViewPosition(new Point(0, n7));
                }
            }
        }
    }

    public void removeNotify(WmiModel wmiModel) {
    }

    public void destroyNotify(WmiModel wmiModel) {
    }

    public void setRootView(WmiMathDocumentView wmiMathDocumentView) {
        this.root = wmiMathDocumentView;
        if (this.selectionBuilder != null) {
            this.selectionBuilder.setDocument(this.root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(WmiView wmiView, int n) {
        WmiModel wmiModel;
        if (this.selectionBuilder != null && WmiModelLock.readLock(wmiModel = this.root.getModel(), true)) {
            try {
                this.selectionBuilder.updateSelection(wmiView, n);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
    }

    public WmiSelection createSelection(WmiViewPath wmiViewPath, WmiViewPath wmiViewPath2) {
        WmiSelection wmiSelection = null;
        if (this.selectionBuilder != null) {
            wmiSelection = this.selectionBuilder.createSelection(wmiViewPath, wmiViewPath2);
        }
        return wmiSelection;
    }

    public WmiSelection createAggregateSelection(Set set) {
        WmiSelection wmiSelection = null;
        if (this.selectionBuilder != null) {
            wmiSelection = this.selectionBuilder.createAggregateSelection(set);
        }
        return wmiSelection;
    }

    public void setSelectionBuilder(WmiSelectionBuilder wmiSelectionBuilder) {
        this.selectionBuilder = wmiSelectionBuilder;
    }

    public void addViewMapping(WmiModelTag wmiModelTag, String string, String string2) {
        String string3 = string + "." + string2;
        try {
            Class<?> clazz = Class.forName(string3);
            Constructor<?> constructor = clazz.getConstructor(CONSTRUCTOR_ARGS);
            this.addViewMapping(wmiModelTag, constructor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            WmiErrorLog.log(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            WmiErrorLog.log(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WmiErrorLog.log(illegalArgumentException);
        }
    }

    static {
        try {
            Class<?> clazz;
            WmiAbstractViewFactory.CONSTRUCTOR_ARGS[0] = clazz = Class.forName(MODEL_CLASS_NAME);
            WmiAbstractViewFactory.CONSTRUCTOR_ARGS[1] = WmiMathDocumentView.class;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected static class MathFencedBuilder
    implements WmiViewBuilder {
        protected MathFencedBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiFencedView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class GlyphBuilder
    implements WmiViewBuilder {
        protected GlyphBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathGlyphView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class IdentifierBuilder
    implements WmiViewBuilder {
        protected IdentifierBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathIdentifierView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathTextBuilder
    implements WmiViewBuilder {
        protected MathTextBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathTextView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathNoneBuilder
    implements WmiViewBuilder {
        protected MathNoneBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMultiscriptView.WmiNoneMarkerView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathPrescriptBuilder
    implements WmiViewBuilder {
        protected MathPrescriptBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMultiscriptView.WmiPrescriptMarkerView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathMultiscriptBuilder
    implements WmiViewBuilder {
        protected MathMultiscriptBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMultiscriptView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathAlignMarkBuilder
    implements WmiViewBuilder {
        protected MathAlignMarkBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathAlignMarkView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathAlignGroupBuilder
    implements WmiViewBuilder {
        protected MathAlignGroupBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathAlignGroupView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathTableCellBuilder
    implements WmiViewBuilder {
        protected MathTableCellBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathTableCellView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathTableLabeledRowBuilder
    implements WmiViewBuilder {
        protected MathTableLabeledRowBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathTableLabeledRowView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathTableRowBuilder
    implements WmiViewBuilder {
        protected MathTableRowBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathTableRowView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathTableBuilder
    implements WmiViewBuilder {
        protected MathTableBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathTableView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class OperatorBuilder
    implements WmiViewBuilder {
        protected OperatorBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathOperatorView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class PhantomBuilder
    implements WmiViewBuilder {
        protected PhantomBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathPhantomView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class PaddedBuilder
    implements WmiViewBuilder {
        protected PaddedBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathPaddedView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class SubscriptBuilder
    implements WmiViewBuilder {
        protected SubscriptBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiSubscriptView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class SubSupBuilder
    implements WmiViewBuilder {
        protected SubSupBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiSubSupView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class OverBuilder
    implements WmiViewBuilder {
        protected OverBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiOverView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class UnderBuilder
    implements WmiViewBuilder {
        protected UnderBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiUnderView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class UnderOverBuilder
    implements WmiViewBuilder {
        protected UnderOverBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiUnderOverView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class SuperscriptBuilder
    implements WmiViewBuilder {
        protected SuperscriptBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiSuperscriptView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class RootBuilder
    implements WmiViewBuilder {
        protected RootBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiRootView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class FractionBuilder
    implements WmiViewBuilder {
        protected FractionBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiFractionView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class AmbiguousBuilder
    implements WmiViewBuilder {
        protected AmbiguousBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathAmbiguousView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathInlineBuilder
    implements WmiViewBuilder {
        protected MathInlineBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathInlineView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MathEncloseBuilder
    implements WmiViewBuilder {
        protected MathEncloseBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            try {
                WmiMathEncloseModel.WmiMathEncloseAttributeSet wmiMathEncloseAttributeSet = (WmiMathEncloseModel.WmiMathEncloseAttributeSet)wmiModel.getAttributesForRead();
                if (wmiMathEncloseAttributeSet.getNotation().equals("radical")) {
                    return new WmiRootView(wmiModel, wmiMathDocumentView);
                }
                return new WmiMathEncloseView(wmiModel, wmiMathDocumentView);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
                return new WmiMathEncloseView(wmiModel, wmiMathDocumentView);
            }
        }
    }

    protected static class InlineBuilder
    implements WmiViewBuilder {
        protected InlineBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiInlineView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class SpaceBuilder
    implements WmiViewBuilder {
        protected SpaceBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMathSpaceView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class MetatagBuilder
    implements WmiViewBuilder {
        protected MetatagBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiMetatagWrapperView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class ComposedBuilder
    implements WmiViewBuilder {
        protected ComposedBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiArrayCompositeView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class TableCellBuilder
    implements WmiViewBuilder {
        protected TableCellBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiTableCellView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class TableColumnBuilder
    implements WmiViewBuilder {
        protected TableColumnBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiTableColumnView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class TableRowBuilder
    implements WmiViewBuilder {
        protected TableRowBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiTableRowView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class TableBuilder
    implements WmiViewBuilder {
        protected TableBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiTableView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class TextBuilder
    implements WmiViewBuilder {
        protected TextBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiTextView(wmiModel, wmiMathDocumentView);
        }
    }

    protected static class ParagraphBuilder
    implements WmiViewBuilder {
        protected ParagraphBuilder() {
        }

        public WmiView createView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            return new WmiParagraphView(wmiModel, wmiMathDocumentView);
        }
    }

    protected class WmiUndoablePositionMarker {
        WmiModelMarker marker = null;
        WmiModelSelection selection = null;

        protected WmiUndoablePositionMarker() {
            this.createModelMarker();
            this.createRangeMarker();
        }

        protected void createModelMarker() {
            WmiPositionMarker wmiPositionMarker = WmiAbstractViewFactory.this.root.getPositionMarker();
            if (wmiPositionMarker instanceof WmiCaret) {
                WmiCaret wmiCaret = (WmiCaret)wmiPositionMarker;
                WmiPositionedView wmiPositionedView = wmiCaret.getView();
                int n = wmiCaret.getOffset();
                if (wmiPositionedView instanceof WmiTextView) {
                    n += ((WmiTextView)wmiPositionedView).getStartOffset();
                }
                if (wmiPositionedView != null) {
                    this.marker = new WmiModelMarker(wmiPositionedView.getModel(), n);
                }
            } else if (wmiPositionMarker != null && wmiPositionMarker.getView() != null) {
                this.marker = new WmiModelMarker(wmiPositionMarker.getView().getModel(), 0);
            }
        }

        protected void createRangeMarker() {
            WmiSelection wmiSelection = WmiAbstractViewFactory.this.root.getSelection();
            if (wmiSelection != null) {
                WmiModel[] wmiModelArray = new WmiModel[2];
                int[] nArray = new int[2];
                if (wmiSelection.getModelInterval(wmiModelArray, nArray)) {
                    this.selection = new WmiModelSelectionRange(new WmiModelMarker(wmiModelArray[0], nArray[0]), new WmiModelMarker(wmiModelArray[1], nArray[1]));
                } else if (wmiSelection instanceof WmiAggregateSelection) {
                    this.selection = new WmiModelSelectionAggregate((WmiAggregateSelection)wmiSelection);
                }
            }
        }

        protected void updatePosition() throws WmiNoReadAccessException {
            try {
                if (this.marker != null) {
                    this.marker.updateViewPosition();
                } else {
                    WmiAbstractViewFactory.this.root.setPositionMarker(null);
                }
                if (this.selection != null) {
                    this.selection.updateSelection();
                } else {
                    WmiAbstractViewFactory.this.root.setSelection(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class WmiModelSelectionAggregate
    implements WmiModelSelection {
        private Set models = new HashSet();

        protected WmiModelSelectionAggregate(WmiAggregateSelection wmiAggregateSelection) {
            Iterator iterator = wmiAggregateSelection.getViewIterator();
            while (iterator.hasNext()) {
                WmiView wmiView = (WmiView)iterator.next();
                WmiModel wmiModel = wmiView.getModel();
                this.models.add(wmiModel);
            }
        }

        public void updateSelection() {
            WmiSelection wmiSelection = WmiAbstractViewFactory.this.selectionBuilder.createAggregateSelection(this.models);
            WmiAbstractViewFactory.this.root.setSelection(wmiSelection);
            WmiAbstractViewFactory.this.root.repaint();
        }
    }

    protected class WmiModelSelectionRange
    implements WmiModelSelection {
        private WmiModelMarker start;
        private WmiModelMarker end;

        protected WmiModelSelectionRange(WmiModelMarker wmiModelMarker, WmiModelMarker wmiModelMarker2) {
            this.start = wmiModelMarker;
            this.end = wmiModelMarker2;
        }

        public void updateSelection() throws WmiNoReadAccessException {
            if (this.start.model != null && this.end.model != null) {
                WmiSelection wmiSelection = WmiAbstractViewFactory.this.selectionBuilder.createSelection(this.start.model, this.start.offset, this.end.model, this.end.offset);
                WmiAbstractViewFactory.this.root.setSelection(wmiSelection);
                WmiAbstractViewFactory.this.root.repaint();
            }
        }
    }

    protected static interface WmiModelSelection {
        public void updateSelection() throws WmiNoReadAccessException;
    }

    protected class WmiModelMarker {
        private WmiModel model;
        private int offset;

        protected WmiModelMarker(WmiModel wmiModel, int n) {
            this.model = wmiModel;
            this.offset = n;
        }

        protected void updateViewPosition() throws WmiNoReadAccessException {
            WmiView wmiView = WmiViewUtil.modelToView(WmiAbstractViewFactory.this.root, this.model, this.offset);
            int n = 0;
            if (wmiView instanceof WmiTextView) {
                WmiTextView wmiTextView = (WmiTextView)wmiView;
                n = this.offset == -1 ? wmiTextView.getLength() : this.offset - wmiTextView.getStartOffset();
                if (n < 0) {
                    n = 0;
                } else if (n >= wmiTextView.getLength()) {
                    n = wmiTextView.getLength();
                }
            } else if (WmiViewUtil.isTraversableView(wmiView)) {
                n = this.offset == -1 ? ((WmiTraversableView)wmiView).getTraversableCount() - 1 : this.offset;
            }
            if (wmiView instanceof WmiPositionedView) {
                ((WmiPositionedView)wmiView).setPositionMarker(n);
                WmiAbstractViewFactory.this.root.setSelection(null);
                WmiAbstractViewFactory.this.root.repaint();
            }
        }
    }
}

