/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMetatagWrapperModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.WmiSearchVisitor;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class WmiParagraphMouseListener
extends WmiMouseInputAdapter
implements MouseListener,
MouseMotionListener {
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            Object object = mouseEvent.getSource();
            WmiMathDocumentView wmiMathDocumentView = null;
            if (object instanceof WmiView) {
                wmiMathDocumentView = ((WmiView)object).getDocumentView();
            }
            if (wmiMathDocumentView != null) {
                Cursor cursor;
                Cursor cursor2 = Cursor.getPredefinedCursor(2);
                if (wmiMathDocumentView != null && !(cursor = wmiMathDocumentView.getCursor()).equals(cursor2)) {
                    wmiMathDocumentView.setCursor(cursor2);
                }
                mouseEvent.consume();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.processMetadataVisibility(mouseEvent, true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.processMetadataVisibility(mouseEvent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMetadataVisibility(MouseEvent mouseEvent, boolean bl) {
        boolean bl2 = false;
        WmiMathDocumentView wmiMathDocumentView = WmiViewUtil.getDocumentView(mouseEvent.getSource());
        WmiMathDocumentModel wmiMathDocumentModel = null;
        if (wmiMathDocumentView != null) {
            wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        }
        if (wmiMathDocumentModel != null && wmiMathDocumentModel.getMetadataManager().getDecoratorVisibility() == 1) {
            bl2 = true;
        }
        if (bl2) {
            WmiModel wmiModel = ((WmiView)mouseEvent.getSource()).getModel();
            MetatagVisibilitySelector metatagVisibilitySelector = new MetatagVisibilitySelector(bl);
            boolean bl3 = WmiModelLock.readLock(wmiModel.getDocument(), false);
            if (bl3) {
                try {
                    WmiModelUtil.visitModels(wmiModel, metatagVisibilitySelector, WmiModelTag.METATAG_WRAPPER);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    WmiModelLock.readUnlock(wmiModel.getDocument());
                }
                wmiMathDocumentView.repaint();
            }
        }
    }

    protected class MetatagVisibilitySelector
    implements WmiSearchVisitor {
        private boolean selectorSetting;

        public MetatagVisibilitySelector(boolean bl) {
            this.selectorSetting = bl;
        }

        public int visitMatch(Object object) {
            WmiMetatagWrapperModel wmiMetatagWrapperModel = (WmiMetatagWrapperModel)object;
            wmiMetatagWrapperModel.setDecoratorVisible(this.selectorSetting);
            return 1;
        }
    }
}

