/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiStatusListener;
import com.maplesoft.mathdoc.controller.WmiTask;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;

public class WmiTaskMonitor {
    public static final int COMMAND_REFUSED = 0;
    public static final int COMMAND_COMPLETE = 1;
    public static final int COMMAND_RUNNING = 2;
    public static final int COMMAND_DEFERRED = 3;
    protected static final int NO_QUEUE = 0;
    protected static final int FOREGROUND_QUEUE = 1;
    protected static final int BACKGROUND_QUEUE = 2;
    private static WmiTaskMonitor theMonitor = null;
    private static Vector safeReadOnlyCommands = new Vector();
    private WmiBackgroundTaskRunner backgroundTaskRunner = new WmiBackgroundTaskRunner();
    private Vector statusListeners;
    protected WmiCommandQueue foregroundCmdQueue;
    protected WmiCommandQueue backgroundCmdQueue;

    public static WmiTaskMonitor getInstance() {
        if (theMonitor == null) {
            theMonitor = new WmiTaskMonitor();
        }
        return theMonitor;
    }

    public static void registerSafeReadOnlyCommand(String string) {
        safeReadOnlyCommands.add(string);
    }

    public static boolean isSafeReadOnlyCommand(WmiCommand wmiCommand) {
        return safeReadOnlyCommands.contains(wmiCommand.getName());
    }

    private WmiTaskMonitor() {
        this.backgroundTaskRunner.start();
        this.statusListeners = new Vector();
        this.foregroundCmdQueue = new WmiCommandQueue();
        this.backgroundCmdQueue = new WmiCommandQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(WmiCommand wmiCommand, ActionEvent actionEvent) {
        int n = 0;
        int n2 = this.loadCommand(wmiCommand, actionEvent);
        if (n2 != 0) {
            WmiCommandQueue wmiCommandQueue = this.queueForType(n2);
            if (n2 == 1) {
                if (!wmiCommandQueue.isTaskExecuting()) {
                    this.performCommand(1);
                    n = 1;
                } else {
                    n = 3;
                }
            } else {
                WmiBackgroundTaskRunner wmiBackgroundTaskRunner = this.backgroundTaskRunner;
                synchronized (wmiBackgroundTaskRunner) {
                    this.backgroundTaskRunner.notify();
                }
                n = 3;
            }
        }
        if (n == 0) {
            Toolkit.getDefaultToolkit().beep();
        }
        return n;
    }

    private WmiCommandQueue queueForType(int n) {
        WmiCommandQueue wmiCommandQueue = null;
        if (n == 1) {
            wmiCommandQueue = this.foregroundCmdQueue;
        } else if (n == 2) {
            wmiCommandQueue = this.backgroundCmdQueue;
        }
        return wmiCommandQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int queueCommand(WmiCommand wmiCommand, ActionEvent actionEvent, Object object) {
        WmiCommandQueue wmiCommandQueue;
        int n = 1;
        if (wmiCommand.isBackgroundTask()) {
            n = 2;
        }
        WmiCommandQueue wmiCommandQueue2 = wmiCommandQueue = this.queueForType(n);
        synchronized (wmiCommandQueue2) {
            WmiTask wmiTask = new WmiTask(wmiCommand, actionEvent, object);
            wmiCommandQueue.add(wmiTask);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmiTask startNextCommand(int n) {
        WmiTask wmiTask = null;
        WmiCommandQueue wmiCommandQueue = this.queueForType(n);
        if (wmiCommandQueue != null) {
            WmiCommandQueue wmiCommandQueue2 = wmiCommandQueue;
            synchronized (wmiCommandQueue2) {
                if (wmiCommandQueue.size() > 0) {
                    wmiTask = (WmiTask)wmiCommandQueue.get(0);
                    wmiCommandQueue.setTaskExecuting(true);
                }
            }
        }
        return wmiTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmiTask finishActiveCommand(int n) {
        WmiTask wmiTask = null;
        WmiCommandQueue wmiCommandQueue = this.queueForType(n);
        if (wmiCommandQueue != null) {
            WmiCommandQueue wmiCommandQueue2 = wmiCommandQueue;
            synchronized (wmiCommandQueue2) {
                if (wmiCommandQueue.size() > 0) {
                    wmiTask = (WmiTask)wmiCommandQueue.get(0);
                    if (wmiTask.getEvent().getSource() == null || !wmiTask.getEvent().getSource().equals(wmiTask.getOriginalSource())) {
                        wmiTask.getEvent().setSource(wmiTask.getOriginalSource());
                    }
                    wmiCommandQueue.remove(0);
                    wmiCommandQueue.setTaskExecuting(false);
                }
            }
        }
        return wmiTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getQueuedCommandCount(int n) {
        int n2 = -1;
        WmiCommandQueue wmiCommandQueue = this.queueForType(n);
        if (wmiCommandQueue != null) {
            WmiCommandQueue wmiCommandQueue2 = wmiCommandQueue;
            synchronized (wmiCommandQueue2) {
                n2 = wmiCommandQueue.size();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCommand(WmiCommand wmiCommand, ActionEvent actionEvent) {
        WmiCommandQueue wmiCommandQueue;
        int n = 0;
        boolean bl = false;
        WmiCommandQueue wmiCommandQueue2 = wmiCommandQueue = this.queueForType(1);
        synchronized (wmiCommandQueue2) {
            Object object;
            if (wmiCommandQueue.isTaskExecuting()) {
                object = (WmiTask)wmiCommandQueue.get(0);
                if (object != null && ((WmiTask)object).getCommand().canQueue(wmiCommand.getName())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                object = actionEvent.getSource();
                ArrayList arrayList = new ArrayList();
                WmiCommand.getViews(actionEvent, arrayList);
                if (arrayList.isEmpty()) {
                    WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.getActiveDocumentView();
                    actionEvent.setSource(wmiMathDocumentView);
                }
                n = this.queueCommand(wmiCommand, actionEvent, object);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(int n) {
        WmiTask wmiTask = null;
        while ((wmiTask = this.startNextCommand(n)) != null) {
            WmiCommand wmiCommand = wmiTask.getCommand();
            ActionEvent actionEvent = wmiTask.getEvent();
            this.notifyTaskStart(wmiTask);
            boolean bl = false;
            boolean bl2 = false;
            ArrayList arrayList = new ArrayList();
            WmiCommand.getViews(actionEvent, arrayList);
            WmiView wmiView = null;
            if (!arrayList.isEmpty()) {
                wmiView = (WmiView)arrayList.get(0);
            }
            WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
            WmiMathDocumentModel wmiMathDocumentModel = wmiModel != null ? wmiModel.getDocument() : null;
            try {
                boolean bl3 = wmiMathDocumentModel != null || wmiCommand.lockTypeRequired() == -1;
                boolean bl4 = wmiMathDocumentModel != null ? wmiMathDocumentModel.isReadOnly() : false;
                boolean bl5 = !bl4 || wmiCommand.lockTypeRequired() == -1 || wmiCommand.lockTypeRequired() == 0 || WmiTaskMonitor.isSafeReadOnlyCommand(wmiCommand);
                boolean bl6 = wmiCommand.getName().equals("Tools.Task.TaskBrowse");
                if (!bl6 && !bl3 || !bl5) continue;
                if (wmiCommand.lockTypeRequired() == 1) {
                    bl2 = WmiModelLock.writeLock(wmiMathDocumentModel, true);
                } else if (wmiCommand.lockTypeRequired() == 0) {
                    bl = WmiModelLock.readLock(wmiMathDocumentModel, true);
                }
                wmiCommand.doCommand(actionEvent);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (RuntimeException runtimeException) {
                WmiErrorLog.log(runtimeException);
            }
            finally {
                if (bl2) {
                    WmiModelLock.writeUnlock(wmiMathDocumentModel);
                } else if (bl) {
                    WmiModelLock.readUnlock(wmiMathDocumentModel);
                }
                this.notifyTaskCompletion(wmiTask);
                this.finishActiveCommand(n);
            }
        }
    }

    public void addStatusListener(WmiStatusListener wmiStatusListener) {
        this.statusListeners.add(wmiStatusListener);
    }

    public void removeStatusListener(WmiStatusListener wmiStatusListener) {
        this.statusListeners.remove(wmiStatusListener);
    }

    protected void notifyTaskStart(WmiTask wmiTask) {
        for (int i = 0; i < this.statusListeners.size(); ++i) {
            WmiStatusListener wmiStatusListener = (WmiStatusListener)this.statusListeners.get(i);
            if (wmiStatusListener == null) continue;
            wmiStatusListener.processTaskStart(wmiTask);
        }
    }

    protected void notifyTaskCompletion(WmiTask wmiTask) {
        for (int i = 0; i < this.statusListeners.size(); ++i) {
            WmiStatusListener wmiStatusListener = (WmiStatusListener)this.statusListeners.get(i);
            if (wmiStatusListener == null) continue;
            wmiStatusListener.processTaskCompletion(wmiTask);
        }
    }

    private static class WmiCommandQueue
    extends ArrayList {
        private boolean taskExecuting = false;

        private WmiCommandQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTaskExecuting(boolean bl) {
            WmiCommandQueue wmiCommandQueue = this;
            synchronized (wmiCommandQueue) {
                this.taskExecuting = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isTaskExecuting() {
            boolean bl = false;
            WmiCommandQueue wmiCommandQueue = this;
            synchronized (wmiCommandQueue) {
                bl = this.taskExecuting;
            }
            return bl;
        }
    }

    private class WmiBackgroundTaskRunner
    extends Thread {
        private WmiBackgroundTaskRunner() {
            super("WMI:Background Task Runner");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = true;
            while (bl) {
                try {
                    WmiBackgroundTaskRunner wmiBackgroundTaskRunner = this;
                    synchronized (wmiBackgroundTaskRunner) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                }
                if (!bl) continue;
                WmiTaskMonitor.this.performCommand(2);
            }
        }
    }
}

