/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiDefaultKeyListener;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiAbstractInlineWrapperView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;

public class WmiTextKeyListener
extends WmiDefaultKeyListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processChar(KeyEvent keyEvent, WmiView wmiView) {
        boolean bl = false;
        WmiModel wmiModel = wmiView.getModel();
        WmiMathDocumentView wmiMathDocumentView = null;
        boolean bl2 = false;
        WmiCaret wmiCaret = null;
        WmiSelection wmiSelection = null;
        if (WmiModelLock.readLock(wmiModel, true)) {
            try {
                wmiMathDocumentView = wmiView.getDocumentView();
                wmiCaret = wmiMathDocumentView != null ? wmiMathDocumentView.getCaret() : null;
                wmiSelection = wmiMathDocumentView != null ? wmiMathDocumentView.getSelection() : null;
                boolean bl3 = bl2 = wmiCaret == null || !wmiCaret.isReadOnly();
                if (wmiSelection != null) {
                    boolean bl4 = bl2 = !wmiSelection.isReadOnly();
                }
                if (wmiCaret != null) {
                    wmiView = this.updateCaretBias(wmiCaret, wmiView, keyEvent);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
        if (!(wmiCaret == null && wmiSelection == null || wmiSelection == null && wmiView != wmiCaret.getView())) {
            this.finalKeyDispatch(keyEvent, wmiView, wmiCaret, wmiSelection, bl2);
            wmiMathDocumentView.saveLastHorizontalPosition();
            bl = true;
        }
        return bl;
    }

    protected boolean finalKeyDispatch(KeyEvent keyEvent, WmiView wmiView, WmiCaret wmiCaret, WmiSelection wmiSelection, boolean bl) {
        boolean bl2 = true;
        int n = wmiCaret != null ? wmiCaret.getOffset() : 0;
        char c = keyEvent.getKeyChar();
        if (c == '\u007f') {
            WmiCommand.invokeCommand("edit.delete");
        } else if (c == '\b') {
            WmiCommand.invokeCommand("edit.backspace");
        } else if (bl && c == '\n') {
            if (wmiSelection == null) {
                if (keyEvent.isShiftDown()) {
                    ((WmiTextView)wmiView).insertChar(c, n);
                } else {
                    this.splitParagraph((WmiTextView)wmiView, n);
                }
            }
        } else if (bl) {
            if (wmiSelection == null) {
                ((WmiTextView)wmiView).insertChar(c, n);
            } else {
                this.replaceSelection(wmiSelection, c);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        keyEvent.consume();
        return bl2;
    }

    private void replaceSelection(WmiSelection wmiSelection, char c) {
        wmiSelection.replaceSelection(Character.toString(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitParagraph(WmiTextView wmiTextView, int n) {
        WmiModel wmiModel = wmiTextView.getModel();
        WmiCompositeModel wmiCompositeModel = null;
        WmiCompositeModel wmiCompositeModel2 = null;
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        WmiModel wmiModel2 = null;
        WmiMathDocumentView wmiMathDocumentView = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        if (WmiModelLock.readLock(wmiModel, true)) {
            try {
                wmiMathDocumentView = wmiTextView.getDocumentView();
                wmiCompositeModel = wmiModel.getParent();
                if (wmiModel instanceof WmiTextModel) {
                    n5 = ((WmiTextModel)wmiModel).getLength();
                }
                if (wmiCompositeModel instanceof WmiParagraphModel) {
                    n2 = wmiCompositeModel.indexOf(wmiModel);
                    n3 += wmiTextView.getStartOffset();
                    wmiCompositeModel2 = wmiCompositeModel.getParent();
                    n4 = wmiCompositeModel2.indexOf(wmiCompositeModel);
                } else {
                    wmiCompositeModel = null;
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
        if (wmiCompositeModel != null && n2 >= 0 && n4 >= 0 && WmiModelLock.writeLock(wmiModel, true)) {
            try {
                Object object;
                int n6 = wmiCompositeModel.getChildCount();
                WmiParagraphModel wmiParagraphModel = ((WmiParagraphModel)wmiCompositeModel).createEmptyParagraph();
                WmiLayoutAttributeSet wmiLayoutAttributeSet = (WmiLayoutAttributeSet)wmiCompositeModel.getAttributesForRead();
                int n7 = wmiLayoutAttributeSet.getInitialListValue();
                WmiMathDocumentModel wmiMathDocumentModel2 = wmiParagraphModel.getDocument();
                if (n2 == 0 && n3 == 0) {
                    object = new WmiFontAttributeSet();
                    ((WmiFontAttributeSet)object).addAttributes(wmiMathDocumentModel.getActiveEditAttributes());
                    wmiParagraphModel.appendChild(new WmiTextModel(wmiMathDocumentModel2, "", (WmiFontAttributeSet)object));
                    wmiCompositeModel2.addChild(wmiParagraphModel, n4);
                    wmiModel2 = wmiModel;
                    if (n7 > 0) {
                        wmiCompositeModel.addAttribute("initial", new Integer(-1));
                    }
                } else if (n2 == n6 - 1 && n3 == n5) {
                    object = new WmiFontAttributeSet();
                    ((WmiFontAttributeSet)object).addAttributes(wmiMathDocumentModel.getActiveEditAttributes());
                    wmiModel2 = new WmiTextModel(wmiMathDocumentModel2, "", (WmiFontAttributeSet)object);
                    wmiCompositeModel2.addChild(wmiParagraphModel, n4 + 1);
                    wmiParagraphModel.appendChild(wmiModel2);
                    if (n7 > 0) {
                        wmiParagraphModel.addAttribute("initial", new Integer(-1));
                    }
                } else {
                    if (n3 == 0) {
                        wmiModel2 = this.splitParagraphBefore((WmiParagraphModel)wmiCompositeModel, wmiParagraphModel, n2);
                    } else if (n3 == n5) {
                        wmiModel2 = this.splitParagraphAfter((WmiParagraphModel)wmiCompositeModel, wmiParagraphModel, n2);
                    } else {
                        object = ((WmiTextModel)wmiModel).getText();
                        WmiModel[] wmiModelArray = new WmiTextModel[]{new WmiTextModel(wmiMathDocumentModel2, ((String)object).substring(0, n3)), new WmiTextModel(wmiMathDocumentModel2, ((String)object).substring(n3))};
                        wmiModelArray[0].setAttributes(wmiModel.getAttributes());
                        wmiModelArray[1].setAttributes(wmiModel.getAttributes());
                        wmiCompositeModel.replaceChildren(wmiModelArray, n2, 1);
                        wmiModel2 = this.splitParagraphAfter((WmiParagraphModel)wmiCompositeModel, wmiParagraphModel, n2);
                    }
                    if (n7 > 0) {
                        wmiParagraphModel.addAttribute("initial", new Integer(-1));
                    }
                }
                if (wmiModel2 != null) {
                    object = new WmiDefaultPositionUpdateHandler(wmiMathDocumentView, new WmiModelPosition(wmiModel2, 0));
                    wmiMathDocumentView.setPendingPositionUpdateHandler((WmiPositionUpdateHandler)object);
                }
                wmiMathDocumentModel2.update(WmiTextView.getUndoInsertTextName());
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                WmiErrorLog.log(wmiNoUpdateAccessException);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            finally {
                WmiModelLock.writeUnlock(wmiModel);
            }
        }
    }

    private WmiModel splitParagraphBefore(WmiParagraphModel wmiParagraphModel, WmiParagraphModel wmiParagraphModel2, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel wmiCompositeModel = wmiParagraphModel.getParent();
        int n2 = wmiCompositeModel.indexOf(wmiParagraphModel);
        if (n2 >= 0) {
            int n3 = wmiParagraphModel.getChildCount();
            for (int i = n; i < n3; ++i) {
                wmiParagraphModel2.appendChild(wmiParagraphModel.getChild(i));
            }
            wmiParagraphModel.removeChildren(n, n3 - n);
            wmiCompositeModel.addChild(wmiParagraphModel2, n2 + 1);
        }
        return wmiParagraphModel2.getChild(0);
    }

    private WmiModel splitParagraphAfter(WmiParagraphModel wmiParagraphModel, WmiParagraphModel wmiParagraphModel2, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return this.splitParagraphBefore(wmiParagraphModel, wmiParagraphModel2, n + 1);
    }

    private WmiView updateCaretBias(WmiCaret wmiCaret, WmiView wmiView, KeyEvent keyEvent) throws WmiNoReadAccessException {
        WmiView wmiView2 = wmiView;
        if (wmiCaret != null) {
            WmiTextView wmiTextView = (WmiTextView)wmiView2;
            int n = wmiCaret.getOffset();
            boolean bl = wmiTextView.getEndOffset() - wmiTextView.getStartOffset() == n;
            boolean bl2 = 0 == n;
            char c = keyEvent.getKeyChar();
            if (bl && c == '\u007f') {
                WmiPositionedView wmiPositionedView = this.getRightView(wmiTextView);
                if (wmiPositionedView != null && c == '\u007f') {
                    wmiPositionedView.setPositionMarker(0);
                }
            } else if (bl2) {
                WmiPositionedView wmiPositionedView = this.getLeftView(wmiTextView);
                if (c == '\b') {
                    if (wmiPositionedView instanceof WmiTextView) {
                        WmiTextView wmiTextView2 = (WmiTextView)wmiPositionedView;
                        int n2 = wmiTextView2.getEndOffset() - wmiTextView2.getStartOffset();
                        wmiPositionedView.setPositionMarker(n2);
                    } else if (wmiPositionedView instanceof WmiAbstractInlineWrapperView) {
                        WmiAbstractInlineWrapperView wmiAbstractInlineWrapperView = (WmiAbstractInlineWrapperView)wmiPositionedView;
                        if (wmiAbstractInlineWrapperView.stepInto()) {
                            WmiViewPosition wmiViewPosition = wmiAbstractInlineWrapperView.getFinalPosition();
                            wmiViewPosition.getView().setPositionMarker(wmiViewPosition.getOffset());
                        }
                    } else if (wmiPositionedView != null) {
                        WmiCompositeView wmiCompositeView;
                        int n3;
                        while (wmiPositionedView instanceof WmiCompositeView && !WmiViewUtil.isTraversableView(wmiPositionedView) && (n3 = (wmiCompositeView = (WmiCompositeView)((Object)wmiPositionedView)).getChildCount()) > 0) {
                            wmiPositionedView = (WmiPositionedView)wmiCompositeView.getChild(n3 - 1);
                        }
                        wmiPositionedView.setPositionMarker(-1);
                    }
                } else if (c != '\u007f' && c != '\n' && wmiPositionedView instanceof WmiTextView) {
                    WmiTextView wmiTextView3 = (WmiTextView)wmiPositionedView;
                    int n4 = wmiTextView3.getEndOffset() - wmiTextView3.getStartOffset();
                    Point point = WmiViewUtil.getAbsoluteOffset(wmiTextView);
                    Point point2 = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
                    int n5 = point2.y;
                    int n6 = point.y;
                    if (n5 == n6) {
                        wmiPositionedView.setPositionMarker(n4);
                    }
                }
            }
            wmiView2 = wmiCaret.getView() != null ? wmiCaret.getView() : wmiView;
        }
        return wmiView2;
    }

    protected WmiPositionedView getLeftView(WmiTextView wmiTextView) {
        return wmiTextView.getNextView(2);
    }

    protected WmiPositionedView getRightView(WmiTextView wmiTextView) {
        return wmiTextView.getNextView(3);
    }
}

