/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.controller.WmiTextController;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;

public class WmiTextMouseListener
extends WmiMouseInputAdapter {
    private static final String SELECT_PARAGRAPH = "select.paragraph";
    private static final String SELECT_WORD = "select.word";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Object object = mouseEvent.getSource();
        if (object instanceof WmiTextView) {
            WmiTextView wmiTextView = (WmiTextView)object;
            WmiModel wmiModel = wmiTextView.getModel();
            int n = 0;
            boolean bl = false;
            try {
                bl = WmiModelLock.readLock(wmiModel, false);
                if (bl) {
                    n = wmiTextView.getOffset(point);
                    boolean bl2 = mouseEvent.isShiftDown();
                    WmiMathDocumentView wmiMathDocumentView = wmiTextView.getDocumentView();
                    if (bl2) {
                        WmiTextController.updateSelection(wmiTextView, n);
                        mouseEvent.consume();
                    } else {
                        WmiSelection wmiSelection = wmiMathDocumentView != null ? wmiMathDocumentView.getSelection() : null;
                        wmiTextView.setPositionMarker(n);
                        if (wmiMathDocumentView != null && wmiSelection != null) {
                            if (mouseEvent.getButton() == 1) {
                                wmiMathDocumentView.setSelection(null);
                                wmiMathDocumentView.repaint();
                            } else if (WmiTextMouseListener.isPopupTrigger(mouseEvent) && !wmiSelection.contains(wmiTextView, n)) {
                                wmiMathDocumentView.setSelection(null);
                                wmiMathDocumentView.repaint();
                            }
                        }
                        if (!WmiTextMouseListener.isPopupTrigger(mouseEvent)) {
                            mouseEvent.consume();
                        }
                    }
                    wmiMathDocumentView.saveLastHorizontalPosition();
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (bl) {
                    WmiModelLock.readUnlock(wmiModel);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            int n = mouseEvent.getClickCount();
            if (n == 2) {
                Object object = mouseEvent.getSource();
                if (object instanceof WmiTextView) {
                    this.selectWord((WmiTextView)object);
                }
                mouseEvent.consume();
            } else if (n == 3) {
                Object object = mouseEvent.getSource();
                if (object instanceof WmiTextView) {
                    this.selectParagraph((WmiTextView)object);
                }
                mouseEvent.consume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 || mouseEvent.getButton() == 0) {
            Point point = mouseEvent.getPoint();
            Object object = mouseEvent.getSource();
            if (object instanceof WmiTextView) {
                WmiTextView wmiTextView = (WmiTextView)object;
                WmiModel wmiModel = wmiTextView.getModel();
                int n = 0;
                boolean bl = false;
                try {
                    bl = WmiModelLock.readLock(wmiModel, false);
                    if (bl) {
                        n = wmiTextView.getOffset(point);
                        WmiTextController.updateSelection(wmiTextView, n);
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    if (bl) {
                        WmiModelLock.readUnlock(wmiModel);
                    }
                }
            }
            mouseEvent.consume();
        }
    }

    private void selectParagraph(WmiTextView wmiTextView) {
        WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(SELECT_PARAGRAPH);
        ActionEvent actionEvent = new ActionEvent(wmiTextView, 0, null);
        if (wmiCommandProxy != null) {
            wmiCommandProxy.actionPerformed(actionEvent);
        }
    }

    private void selectWord(WmiTextView wmiTextView) {
        WmiCommandProxy wmiCommandProxy = WmiCommand.getCommandProxy(SELECT_WORD);
        ActionEvent actionEvent = new ActionEvent(wmiTextView, 0, null);
        if (wmiCommandProxy != null) {
            wmiCommandProxy.actionPerformed(actionEvent);
        }
    }
}

