/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathRationalCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;

public abstract class WmiFormatMathRationalAlignCommand
extends WmiFormatMathRationalCommand {
    private String alignmentLocation;
    private String alignmentValue;

    protected WmiFormatMathRationalAlignCommand(String string, String string2, String string3) {
        super(string);
        this.alignmentLocation = string2;
        this.alignmentValue = string3;
    }

    public WmiAttributeSet modifyAttribute(WmiAttributeSet wmiAttributeSet) {
        wmiAttributeSet.addAttribute(this.getAlignmentLocation(), this.getAlignmentValue());
        return wmiAttributeSet;
    }

    private String getAlignmentLocation() {
        return this.alignmentLocation;
    }

    private String getAlignmentValue() {
        return this.alignmentValue;
    }

    private boolean isAlignmentChecked(WmiFractionModel.WmiFractionAttributeSet wmiFractionAttributeSet) {
        boolean bl = false;
        Object object = wmiFractionAttributeSet.getAttribute(this.getAlignmentLocation());
        if (object instanceof String) {
            bl = ((String)object).equals(this.getAlignmentValue());
        }
        return bl;
    }

    public int getType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected() {
        WmiPositionMarker wmiPositionMarker;
        WmiPositionedView wmiPositionedView;
        boolean bl = false;
        WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.getActiveDocumentView();
        if (wmiMathDocumentView != null && (wmiPositionedView = (wmiPositionMarker = wmiMathDocumentView.getPositionMarker()).getView()) != null) {
            WmiModel wmiModel = wmiPositionedView.getModel();
            boolean bl2 = false;
            try {
                WmiFractionModel wmiFractionModel;
                bl2 = WmiModelLock.readLock(wmiModel, false);
                if (bl2 && (wmiFractionModel = (WmiFractionModel)this.getTargetModel(wmiModel)) != null) {
                    WmiFractionModel.WmiFractionAttributeSet wmiFractionAttributeSet = (WmiFractionModel.WmiFractionAttributeSet)wmiFractionModel.getAttributes();
                    bl = this.isAlignmentChecked(wmiFractionAttributeSet);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (bl2) {
                    WmiModelLock.readUnlock(wmiModel);
                }
            }
        }
        return bl;
    }

    public static class WmiFormatMathRationalDenominatorRight
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalDenominatorRight() {
            super("format.rational.align.dright", "denomalign", "right");
        }
    }

    public static class WmiFormatMathRationalDenominatorCenter
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalDenominatorCenter() {
            super("format.rational.align.dcenter", "denomalign", "center");
        }
    }

    public static class WmiFormatMathRationalDenominatorLeft
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalDenominatorLeft() {
            super("format.rational.align.dleft", "denomalign", "left");
        }
    }

    public static class WmiFormatMathRationalNumeratorRight
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalNumeratorRight() {
            super("format.rational.align.nright", "numalign", "right");
        }
    }

    public static class WmiFormatMathRationalNumeratorCenter
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalNumeratorCenter() {
            super("format.rational.align.ncenter", "numalign", "center");
        }
    }

    public static class WmiFormatMathRationalNumeratorLeft
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalNumeratorLeft() {
            super("format.rational.align.nleft", "numalign", "left");
        }
    }
}

