/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathRationalCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;

public class WmiFormatMathRationalBevelCommand
extends WmiFormatMathRationalCommand {
    public WmiFormatMathRationalBevelCommand() {
        super("format.rational.bevelled");
    }

    public WmiAttributeSet modifyAttribute(WmiAttributeSet wmiAttributeSet) {
        boolean bl = ((WmiFractionModel.WmiFractionAttributeSet)wmiAttributeSet).isBevelled();
        wmiAttributeSet.addAttribute("bevelled", Boolean.toString(!bl));
        return wmiAttributeSet;
    }

    public int getType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected() {
        WmiPositionedView wmiPositionedView;
        WmiPositionMarker wmiPositionMarker;
        boolean bl = false;
        WmiMathDocumentView wmiMathDocumentView = WmiMathDocumentView.getActiveDocumentView();
        if (wmiMathDocumentView != null && (wmiPositionMarker = wmiMathDocumentView.getPositionMarker()) != null && (wmiPositionedView = wmiPositionMarker.getView()) != null) {
            WmiModel wmiModel = wmiPositionedView.getModel();
            boolean bl2 = false;
            try {
                WmiFractionModel wmiFractionModel;
                bl2 = WmiModelLock.readLock(wmiModel, false);
                if (bl2 && (wmiFractionModel = (WmiFractionModel)this.getTargetModel(wmiModel)) != null) {
                    WmiFractionModel.WmiFractionAttributeSet wmiFractionAttributeSet = (WmiFractionModel.WmiFractionAttributeSet)wmiFractionModel.getAttributes();
                    bl = wmiFractionAttributeSet.isBevelled();
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                if (bl2) {
                    WmiModelLock.readUnlock(wmiModel);
                }
            }
        }
        return bl;
    }
}

