/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.util.ArrayList;

public class MathInsertUtil {
    public static final char BS_ESCAPE_CHAR = '\\';
    public static final int NO_BIAS = 0;
    public static final int LEFT_BIAS = -1;
    public static final int RIGHT_BIAS = 1;

    public static WmiModelPosition deleteMathSelection(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelPosition wmiModelPosition = null;
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        if (wmiSelection != null) {
            try {
                WmiModel wmiModel;
                wmiModelPosition = MathInsertUtil.wrapSelection(wmiMathDocumentView);
                WmiModel wmiModel2 = wmiModel = wmiModelPosition != null ? wmiModelPosition.getModel() : null;
                if (wmiModel != null) {
                    int n;
                    WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
                    int n2 = n = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
                    if (n >= 0) {
                        WmiFontAttributeSet wmiFontAttributeSet = MathInsertUtil.getInsertAttributes(wmiModel);
                        WmiIdentifierModel wmiIdentifierModel = new WmiIdentifierModel(wmiMathDocumentModel, "", "", wmiFontAttributeSet, false);
                        wmiCompositeModel.replaceChild(wmiIdentifierModel, n);
                        WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel);
                        wmiModelPosition = new WmiModelPosition(wmiIdentifierModel, 0);
                    }
                }
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
        return wmiModelPosition;
    }

    public static WmiModelPosition updateInsertionPoint(WmiPositionMarker wmiPositionMarker, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel;
        WmiModelPosition wmiModelPosition = null;
        WmiPositionedView wmiPositionedView = wmiPositionMarker != null ? wmiPositionMarker.getView() : null;
        WmiModel wmiModel2 = wmiModel = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
        if (wmiModel != null) {
            int n2 = wmiPositionMarker.getOffset();
            if (wmiPositionedView instanceof WmiTextView) {
                n2 += ((WmiTextView)wmiPositionedView).getStartOffset();
            }
            wmiModelPosition = MathInsertUtil.updateInsertionPoint(new WmiModelPosition(wmiModel, n2), n);
        }
        return wmiModelPosition;
    }

    public static WmiModelPosition updateInsertionPoint(WmiModelPosition wmiModelPosition, int n) throws WmiNoReadAccessException {
        WmiModelTag wmiModelTag;
        WmiModel wmiModel = wmiModelPosition.getModel();
        WmiCompositeModel wmiCompositeModel = wmiModel != null ? wmiModel.getParent() : null;
        int n2 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
        WmiModelTag wmiModelTag2 = wmiCompositeModel != null ? wmiCompositeModel.getTag() : null;
        WmiModelTag wmiModelTag3 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
        if (n == 0) {
            Object object;
            if (wmiModelTag == WmiModelTag.MATH_OPERATOR && (object = wmiModel.getAttributesForRead()) instanceof WmiMathOperatorModel.WmiMathOperatorAttributeSet && ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)object).isLargeOp() && wmiModelTag2 != WmiModelTag.MATH_ROW) {
                wmiModelPosition = new WmiModelPosition(wmiCompositeModel, wmiModelPosition.getOffset() == 0 ? 0 : -1);
            }
            if ((object = MathInsertUtil.findAncestorWithSemantics(wmiModel, wmiModelPosition.getOffset())) != null) {
                WmiModel wmiModel2;
                for (wmiModel2 = wmiModel; wmiModel2 != null && wmiModel2.getParent() != object; wmiModel2 = wmiModel2.getParent()) {
                }
                int n3 = object.indexOf(wmiModel2);
                wmiModelPosition = new WmiModelPosition((WmiModel)object, n3 == 0 ? 0 : -1);
            }
        } else if (n == -1 && wmiModelPosition != null && wmiModelPosition.getOffset() == 0) {
            boolean bl;
            wmiModel = wmiModelPosition.getModel();
            wmiCompositeModel = wmiModel != null ? wmiModel.getParent() : null;
            boolean bl2 = bl = wmiModelTag2 != null;
            if (wmiModelTag2 != WmiModelTag.MATH_ROW && bl) {
                boolean bl3 = bl = wmiCompositeModel.indexOf(wmiModel) == 0;
                if (wmiModelTag2 == WmiModelTag.MATH_MULTISCRIPTS || wmiModelTag2 == WmiModelTag.MATH_FENCED || wmiModelTag2 == WmiModelTag.MATH) {
                    bl = false;
                } else if (wmiModelTag2 == WmiModelTag.MATH_SQUARE_ROOT || wmiModelTag2 == WmiModelTag.MATH_NROOT) {
                    bl = false;
                    wmiModelPosition = new WmiModelPosition(wmiCompositeModel, 0);
                }
            }
            if (bl) {
                n2 = wmiCompositeModel.indexOf(wmiModel);
                if (n2 > 0) {
                    WmiCompositeModel wmiCompositeModel2;
                    int n4;
                    WmiModel wmiModel3 = wmiCompositeModel.getChild(n2 - 1);
                    boolean bl4 = false;
                    while (wmiModel3.getTag() == WmiModelTag.MATH_ROW && (n4 = (wmiCompositeModel2 = (WmiCompositeModel)wmiModel3).getChildCount()) > 0) {
                        bl4 = true;
                        wmiModel3 = wmiCompositeModel2.getChild(n4 - 1);
                    }
                    int n5 = -1;
                    if (wmiModel3 instanceof WmiTextModel) {
                        n5 = ((WmiTextModel)wmiModel3).getLength();
                    }
                    wmiModelPosition = new WmiModelPosition(wmiModel3, n5);
                    if (bl4) {
                        wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiModelPosition, n);
                    }
                } else {
                    wmiModelPosition = MathInsertUtil.updateInsertionPoint(new WmiModelPosition(wmiCompositeModel, 0), n);
                }
            }
        } else if (n == 1 && wmiModelPosition != null) {
            wmiModel = wmiModelPosition.getModel();
            boolean bl = false;
            if (wmiModel instanceof WmiTextModel) {
                int n6 = ((WmiTextModel)wmiModel).getLength();
                boolean bl5 = false;
                if (n6 == 0) {
                    if (wmiModelTag2 == WmiModelTag.MATH_ROW) {
                        if (wmiCompositeModel.getChildCount() == 1) {
                            WmiModelTag wmiModelTag4 = wmiModelTag2 = (wmiCompositeModel = wmiCompositeModel.getParent()) != null ? wmiCompositeModel.getTag() : null;
                            if (wmiModelTag2 != WmiModelTag.MATH_ROW) {
                                bl5 = true;
                            }
                        }
                    } else {
                        bl5 = true;
                    }
                }
                if (wmiModelPosition.getOffset() == n6 && !bl5 && wmiModelTag2 != WmiModelTag.MATH_MULTISCRIPTS) {
                    bl = true;
                }
            } else if (wmiModel instanceof WmiCompositeModel) {
                boolean bl6 = bl = wmiModelPosition.getOffset() != 0;
            }
            if (bl) {
                wmiCompositeModel = wmiModel.getParent();
                if (wmiModelTag2 != null && wmiModelTag2 != WmiModelTag.MATH_FENCED && wmiModelTag2 != WmiModelTag.MATH) {
                    int n7 = n2 = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
                    if (n2 >= 0 && n2 < wmiCompositeModel.getChildCount() - 1) {
                        wmiModelPosition = new WmiModelPosition(wmiCompositeModel.getChild(n2 + 1), 0);
                    } else if (wmiCompositeModel != null) {
                        wmiModelPosition = MathInsertUtil.updateInsertionPoint(new WmiModelPosition(wmiCompositeModel, -1), n);
                    }
                }
            }
        }
        wmiModelPosition = MathInsertUtil.testForFenceBoundary(wmiModelPosition);
        return wmiModelPosition;
    }

    private static WmiModelPosition testForFenceBoundary(WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException {
        int n;
        WmiCompositeModel wmiCompositeModel;
        WmiModel wmiModel;
        WmiModel wmiModel2 = wmiModel = wmiModelPosition != null ? wmiModelPosition.getModel() : null;
        if (wmiModel != null && (wmiCompositeModel = wmiModel.getParent()) != null && wmiCompositeModel.getTag() == WmiModelTag.MATH_FENCED && (n = wmiCompositeModel.indexOf(wmiModel)) < 0) {
            WmiMathFencedModel wmiMathFencedModel = (WmiMathFencedModel)wmiCompositeModel;
            WmiAttributeSet wmiAttributeSet = wmiCompositeModel.getAttributesForRead();
            if (wmiAttributeSet instanceof WmiMathFencedModel.WmiFencedAttributeSet) {
                WmiMathModel wmiMathModel = wmiMathFencedModel.getModelForLeft();
                WmiMathModel wmiMathModel2 = wmiMathFencedModel.getModelForRight();
                if (wmiMathModel == wmiModel) {
                    wmiModelPosition = new WmiModelPosition(wmiCompositeModel, 0);
                } else if (wmiMathModel2 == wmiModel) {
                    wmiModelPosition = new WmiModelPosition(wmiCompositeModel, -1);
                }
            }
        }
        return wmiModelPosition;
    }

    private static WmiCompositeModel findAncestorWithSemantics(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        WmiCompositeModel wmiCompositeModel2 = null;
        WmiCompositeModel wmiCompositeModel3 = null;
        while (wmiCompositeModel != null && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW) {
            Object object;
            wmiCompositeModel3 = null;
            int n2 = wmiCompositeModel.indexOf(wmiModel);
            int n3 = wmiModel instanceof WmiCompositeModel ? ((WmiCompositeModel)wmiModel).getChildCount() : (wmiModel instanceof WmiTextModel ? ((WmiTextModel)wmiModel).getLength() : 1);
            WmiAttributeSet wmiAttributeSet = wmiCompositeModel.getAttributesForRead();
            if (wmiAttributeSet instanceof WmiMathAttributeSet && (object = wmiAttributeSet.getAttribute("Typesetting:-msemantics")) != null) {
                wmiCompositeModel3 = wmiCompositeModel;
            }
            if ((n < 0 || n == n3) && n2 == wmiCompositeModel.getChildCount() - 1) {
                n = n2;
                if (wmiCompositeModel3 != null) {
                    wmiCompositeModel2 = wmiCompositeModel3;
                }
            } else {
                if (n != 0 || n2 != 0) break;
                if (wmiCompositeModel3 != null) {
                    wmiCompositeModel2 = wmiCompositeModel3;
                }
            }
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = wmiModel.getParent();
        }
        return wmiCompositeModel2;
    }

    public static void ensureParentMathRow(WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n;
        WmiModel wmiModel = wmiModelPosition.getModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        int n2 = n = wmiCompositeModel != null ? wmiCompositeModel.indexOf(wmiModel) : -1;
        if (wmiCompositeModel != null && wmiCompositeModel.getTag() != WmiModelTag.MATH_ROW && n >= 0) {
            WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            wmiCompositeModel.replaceChild(wmiInlineMathModel, n);
            wmiInlineMathModel.addChild(wmiModel, 0);
        }
    }

    public static WmiModelPosition insertEmptyPlaceholder(WmiModelPosition wmiModelPosition) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return MathInsertUtil.insertEmptyPlaceholder(wmiModelPosition, null);
    }

    public static WmiModelPosition insertEmptyPlaceholder(WmiModelPosition wmiModelPosition, ArrayList arrayList) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel wmiCompositeModel;
        WmiAttributeSet wmiAttributeSet;
        WmiTextModel wmiTextModel = null;
        boolean bl = false;
        WmiModel wmiModel = wmiModelPosition.getModel();
        WmiModelTag wmiModelTag = wmiModel.getTag();
        if ((wmiModelTag == WmiModelTag.MATH_IDENTIFIER || wmiModelTag == WmiModelTag.MATH_TEXT) && ((WmiTextModel)wmiModel).getLength() == 0 && (wmiAttributeSet = (wmiTextModel = (WmiTextModel)wmiModel).getAttributesForRead()) instanceof WmiFontAttributeSet) {
            if (((WmiFontAttributeSet)wmiAttributeSet).hasStyle(2048)) {
                wmiTextModel = null;
            } else {
                wmiCompositeModel = wmiTextModel.getParent();
                wmiAttributeSet = wmiCompositeModel.getAttributesForRead();
                if (((WmiFontAttributeSet)wmiAttributeSet).hasStyle(2048)) {
                    wmiTextModel = null;
                    bl = true;
                }
            }
        }
        if (wmiTextModel == null) {
            WmiModel wmiModel2;
            int n = wmiModelPosition.getOffset();
            wmiCompositeModel = wmiModel.getDocument();
            WmiCompositeModel wmiCompositeModel2 = wmiModel.getParent();
            int n2 = wmiCompositeModel2.indexOf(wmiModel);
            WmiFontAttributeSet wmiFontAttributeSet = MathInsertUtil.getInsertAttributes(wmiModel);
            if (wmiFontAttributeSet.hasStyle(2048) || bl) {
                wmiModel2 = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
                if (wmiModel2 != null) {
                    wmiFontAttributeSet = (WmiFontAttributeSet)wmiModel2.getAttributes();
                    int n3 = wmiFontAttributeSet.getExtendedStyle();
                    n3 &= 0xFFFFFFFE;
                    wmiFontAttributeSet.setExtendedStyle(n3 &= 0xFFFFFFFD);
                }
            } else {
                WmiStyleAttributeSet wmiStyleAttributeSet;
                int n4 = wmiFontAttributeSet.getExtendedStyle();
                int n5 = WmiAbstractMathTokenModel.getPrototype(wmiModel, n4);
                int n6 = n4 ^ n5;
                WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
                Object object = wmiFontAttributeSet.getAttribute(WmiFontAttributeSet.STYLE_KEY);
                if (object != null && (wmiStyleAttributeSet = wmiMathDocumentModel.getStyle(0, object.toString())) instanceof WmiFontAttributeSet) {
                    n5 = ((WmiFontAttributeSet)wmiStyleAttributeSet).getExtendedStyle();
                }
                wmiFontAttributeSet = (WmiFontAttributeSet)wmiFontAttributeSet.copyAttributes();
                if (n6 != 0) {
                    n5 &= ~n6;
                    n5 |= n4 & n6;
                }
                wmiFontAttributeSet.setExtendedStyle(n5);
            }
            wmiTextModel = new WmiTextModel((WmiMathDocumentModel)wmiCompositeModel, "", wmiFontAttributeSet);
            if (wmiModel instanceof WmiTextModel) {
                wmiModel2 = (WmiTextModel)wmiModel;
                if (n == ((WmiTextModel)wmiModel2).getLength()) {
                    wmiCompositeModel2.addChild(wmiTextModel, n2 + 1);
                } else if (n == 0) {
                    wmiCompositeModel2.addChild(wmiTextModel, n2);
                } else {
                    ((WmiTextModel)wmiModel2).splitModel(n, arrayList);
                    wmiCompositeModel2.addChild(wmiTextModel, n2 + 1);
                }
            } else {
                if (n == 0) {
                    wmiCompositeModel2.addChild(wmiTextModel, n2);
                } else {
                    wmiCompositeModel2.addChild(wmiTextModel, n2 + 1);
                }
                wmiModel = wmiTextModel;
                n = 0;
            }
        }
        return new WmiModelPosition(wmiTextModel, 0);
    }

    private static WmiFontAttributeSet getInsertAttributes(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        WmiFontAttributeSet wmiFontAttributeSet = wmiMathDocumentModel.getActiveEditAttributes();
        if (wmiFontAttributeSet != null) {
            WmiCompositeModel wmiCompositeModel;
            boolean bl = false;
            if ((wmiFontAttributeSet.getExtendedStyle() & 0x800) != 0) {
                bl = true;
            } else {
                WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
                if (wmiAttributeSet instanceof WmiFontAttributeSet && (((WmiFontAttributeSet)wmiAttributeSet).getExtendedStyle() & 0x800) != 0) {
                    bl = true;
                }
            }
            int n = 0;
            boolean bl2 = false;
            if (bl && (wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH)) != null) {
                wmiFontAttributeSet = (WmiFontAttributeSet)wmiCompositeModel.getAttributesForRead();
                WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
                if (wmiAttributeSet instanceof WmiFontAttributeSet) {
                    int n2 = ((WmiFontAttributeSet)wmiAttributeSet).getExtendedStyle();
                    n = WmiAbstractMathTokenModel.getPrototype(wmiModel, n2);
                    n &= 0xFFFFE7FF;
                    bl2 = true;
                }
            }
            wmiFontAttributeSet = (WmiFontAttributeSet)wmiFontAttributeSet.copyAttributes();
            if (bl2) {
                wmiFontAttributeSet.setExtendedStyle(n);
            }
        }
        return wmiFontAttributeSet;
    }

    public static WmiModelPosition splitModel(WmiModelPosition wmiModelPosition, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel wmiModel = wmiModelPosition.getModel();
        int n2 = wmiModelPosition.getOffset();
        if (wmiModel instanceof WmiTextModel) {
            WmiTextModel wmiTextModel = (WmiTextModel)wmiModel;
            if (n2 < 0) {
                n2 = wmiTextModel.getLength();
            }
            WmiTextModel wmiTextModel2 = wmiTextModel.splitModel(n2);
            wmiModel = n == -1 ? wmiTextModel : wmiTextModel2;
            n2 = n == -1 ? wmiTextModel.getLength() : 0;
        }
        return new WmiModelPosition(wmiModel, n2);
    }

    public static boolean isEscapedInsert(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiMathDocumentView != null && wmiMathDocumentView.getSelection() == null && wmiMathDocumentView.getPositionMarker() != null) {
            WmiTextModel wmiTextModel;
            WmiModelTag wmiModelTag;
            WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
            WmiModelPosition wmiModelPosition = wmiPositionMarker.getModelPosition();
            WmiModel wmiModel = wmiModelPosition.getModel();
            int n = wmiModelPosition.getOffset();
            WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if ((wmiModelTag == WmiModelTag.MATH_IDENTIFIER || wmiModelTag == WmiModelTag.MATH_OPERATOR) && (wmiTextModel = (WmiTextModel)wmiModel).getLength() > 0 && n > 0 && wmiTextModel.getText().charAt(n - 1) == '\\') {
                bl = true;
            }
        }
        return bl;
    }

    public static WmiModelPosition wrapSelection(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return MathInsertUtil.wrapSelection(wmiMathDocumentView, 0);
    }

    public static WmiModelPosition wrapSelection(WmiMathDocumentView wmiMathDocumentView, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiModelPosition wmiModelPosition = null;
        if (wmiSelection != null) {
            WmiModel[] wmiModelArray = new WmiModel[2];
            int[] nArray = new int[2];
            wmiSelection.getModelInterval(wmiModelArray, nArray);
            if (wmiModelArray[0] instanceof WmiMathTableModel.WmiMathTableDataModel) {
                wmiModelArray[0] = ((WmiCompositeModel)wmiModelArray[0]).getChild(0);
                nArray[0] = 0;
            }
            if (wmiModelArray[1] instanceof WmiMathTableModel.WmiMathTableDataModel) {
                wmiModelArray[1] = ((WmiCompositeModel)wmiModelArray[1]).getChild(((WmiCompositeModel)wmiModelArray[1]).getChildCount() - 1);
                nArray[1] = -1;
            }
            WmiModelPosition wmiModelPosition2 = new WmiModelPosition(wmiModelArray[0], nArray[0]);
            WmiModelPosition wmiModelPosition3 = new WmiModelPosition(wmiModelArray[1], nArray[1]);
            wmiModelPosition2 = MathInsertUtil.updateInsertionPoint(wmiModelPosition2, 1);
            wmiModelPosition3 = MathInsertUtil.updateInsertionPoint(wmiModelPosition3, -1);
            wmiModelPosition = MathInsertUtil.wrapSelection(wmiModelPosition2, wmiModelPosition3);
        } else {
            wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiPositionMarker, n);
            if (wmiModelPosition != null && !(wmiModelPosition.getModel() instanceof WmiCompositeModel) && wmiModelPosition.getOffset() == 0) {
                wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiPositionMarker, -1);
            }
            wmiModelPosition = MathInsertUtil.wrapSelection(wmiModelPosition, wmiModelPosition);
        }
        return wmiModelPosition;
    }

    public static WmiModelPosition wrapSelection(WmiModelPosition wmiModelPosition, WmiModelPosition wmiModelPosition2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition wmiModelPosition3 = null;
        if (wmiModelPosition == null || wmiModelPosition2 == null) {
            return null;
        }
        WmiModel wmiModel = wmiModelPosition.getModel();
        WmiModel wmiModel2 = wmiModelPosition2.getModel();
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        if (!wmiMathDocumentModel.isMutableModel(wmiModel)) {
            return null;
        }
        wmiModelPosition3 = wmiModel == wmiModel2 ? (wmiModel instanceof WmiTextModel ? MathInsertUtil.singleTextModel(wmiModelPosition, wmiModelPosition2) : MathInsertUtil.singleNonTextModel(wmiModelPosition, wmiModelPosition2)) : MathInsertUtil.multipleModels(wmiModelPosition, wmiModelPosition2);
        return wmiModelPosition3;
    }

    private static WmiModelPosition singleTextModel(WmiModelPosition wmiModelPosition, WmiModelPosition wmiModelPosition2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel wmiModel;
        boolean bl;
        WmiTextModel wmiTextModel;
        WmiModel wmiModel2 = wmiModelPosition.getModel();
        int n = wmiModelPosition.getOffset();
        WmiModel wmiModel3 = wmiModelPosition2.getModel();
        int n2 = wmiModelPosition2.getOffset();
        ArrayList<WmiAbstractModel> arrayList = new ArrayList<WmiAbstractModel>();
        ArrayList<WmiTextModel> arrayList2 = new ArrayList<WmiTextModel>();
        MathInsertUtil.ensureParentMathRow(wmiModelPosition);
        WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
        int n3 = wmiCompositeModel.indexOf(wmiModel2);
        String string = ((WmiTextModel)wmiModel2).getText();
        if (string.length() == 0) {
            return wmiModelPosition;
        }
        String string2 = string;
        boolean bl2 = false;
        if (wmiModel2 instanceof WmiAbstractMathTokenModel && (n2 - n == (wmiTextModel = (WmiAbstractMathTokenModel)wmiModel2).getLength() || n == wmiTextModel.getLength())) {
            string2 = wmiTextModel.getSemanticLabel();
            bl2 = true;
        }
        wmiTextModel = null;
        if (n > 0) {
            wmiTextModel = MathInsertUtil.createModel((WmiTextModel)wmiModel2, string, string2, !bl2, 0, n);
            arrayList2.add(wmiTextModel);
            arrayList.add(wmiTextModel);
        }
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiModel2.getDocument());
        WmiTextModel wmiTextModel2 = null;
        if (n != n2) {
            wmiTextModel2 = MathInsertUtil.createModel((WmiTextModel)wmiModel3, string, string2, !bl2, n, n2);
            arrayList2.add(wmiTextModel2);
            wmiInlineMathModel.addChild(wmiTextModel2, 0);
            bl = false;
        } else {
            wmiInlineMathModel.addAttribute("Typesetting:-msemantics", "donotprune");
            bl = true;
        }
        arrayList.add(wmiInlineMathModel);
        WmiTextModel wmiTextModel3 = null;
        if (n2 != -1 && n2 != string.length()) {
            wmiTextModel3 = MathInsertUtil.createModel((WmiTextModel)wmiModel3, string, n2, string.length());
            arrayList2.add(wmiTextModel3);
            arrayList.add(wmiTextModel3);
        }
        WmiModel[] wmiModelArray = new WmiModel[arrayList.size()];
        arrayList.toArray(wmiModelArray);
        wmiCompositeModel.replaceChildren(wmiModelArray, n3, 1);
        wmiCompositeModel.addAttribute("Typesetting:-msemantics", "donotprune");
        boolean bl3 = wmiTextModel != null;
        boolean bl4 = wmiInlineMathModel != null && wmiInlineMathModel.getChildCount() != 0;
        int n4 = bl3 && bl4 ? 1 : 0;
        WmiModelPosition wmiModelPosition3 = wmiModelPosition;
        if (!arrayList2.isEmpty() && (wmiModelPosition3 = MathInsertUtil.retokenize(arrayList2, n4, -1)) == null) {
            wmiModelPosition3 = wmiModelPosition;
        }
        wmiCompositeModel.addAttribute("Typesetting:-msemantics", null);
        WmiModel wmiModel4 = wmiModelPosition3.getModel();
        wmiCompositeModel = wmiModel4.getParent();
        if (bl) {
            wmiCompositeModel.removeChild(wmiInlineMathModel);
            wmiInlineMathModel = null;
        } else if (wmiModel4 instanceof WmiTextModel && (wmiModel = WmiModelUtil.getPreviousSibling(wmiModel4)) instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)wmiModel).getAllText().equals("\u2212")) {
            wmiModel4 = wmiInlineMathModel;
        }
        return new WmiModelPosition(wmiModel4, -1);
    }

    private static WmiModelPosition singleNonTextModel(WmiModelPosition wmiModelPosition, WmiModelPosition wmiModelPosition2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n = wmiModelPosition.getOffset();
        WmiModel wmiModel = wmiModelPosition2.getModel();
        int n2 = wmiModelPosition2.getOffset();
        WmiModelPosition wmiModelPosition3 = null;
        MathInsertUtil.ensureParentMathRow(wmiModelPosition);
        int n3 = wmiModelPosition2 != wmiModelPosition ? 1 : -1;
        wmiModelPosition3 = MathInsertUtil.splitModel(wmiModelPosition, n3);
        if (wmiModelPosition2 != wmiModelPosition) {
            wmiModel = wmiModelPosition3.getModel();
            if (n2 != -1) {
                n2 -= n;
            }
            wmiModelPosition2 = new WmiModelPosition(wmiModel, n2);
            wmiModelPosition3 = MathInsertUtil.splitModel(wmiModelPosition2, -1);
        }
        return wmiModelPosition3;
    }

    private static WmiModelPosition multipleModels(WmiModelPosition wmiModelPosition, WmiModelPosition wmiModelPosition2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n;
        String string;
        WmiCompositeModel wmiCompositeModel;
        WmiModelPosition wmiModelPosition3 = null;
        WmiModel wmiModel = wmiModelPosition.getModel();
        int n2 = wmiModelPosition.getOffset();
        WmiModel wmiModel2 = wmiModelPosition2.getModel();
        int n3 = wmiModelPosition2.getOffset();
        WmiModel wmiModel3 = WmiModelUtil.commonParent(wmiModel, wmiModel2);
        if (!(wmiModel3 instanceof WmiCompositeModel)) {
            wmiModel3 = wmiModel3.getParent();
        }
        WmiCompositeModel wmiCompositeModel2 = (WmiCompositeModel)wmiModel3;
        wmiModel = wmiModelPosition.getModel();
        n2 = wmiModelPosition.getOffset();
        wmiModel2 = wmiModelPosition2.getModel();
        n3 = wmiModelPosition2.getOffset();
        WmiTextModel wmiTextModel = null;
        WmiTextModel wmiTextModel2 = null;
        WmiModel[] wmiModelArray = new WmiModel[4];
        if (!wmiCompositeModel2.isCrossBoundarySubselectable()) {
            wmiCompositeModel2 = wmiCompositeModel2.getParent();
        }
        int n4 = 0;
        int n5 = wmiCompositeModel2.getChildCount() - 1;
        if (wmiModel != wmiCompositeModel2) {
            wmiCompositeModel = wmiModel.getParent();
            if (n2 != 0 && wmiCompositeModel == wmiCompositeModel2 && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW && wmiModel instanceof WmiTextModel) {
                string = ((WmiTextModel)wmiModel).getText();
                if (n2 > 0 && (n = wmiCompositeModel.indexOf(wmiModel)) >= 0) {
                    wmiTextModel = MathInsertUtil.createModel((WmiTextModel)wmiModel, string, 0, n2);
                    wmiModelArray[0] = wmiTextModel;
                    wmiModelArray[1] = wmiModel = MathInsertUtil.createModel((WmiTextModel)wmiModel, string, n2, string.length());
                    wmiCompositeModel.replaceChild(wmiModel, n);
                }
            }
            while (wmiCompositeModel != wmiCompositeModel2) {
                wmiModel = wmiCompositeModel;
                wmiCompositeModel = wmiCompositeModel.getParent();
            }
            n4 = wmiCompositeModel2.indexOf(wmiModel);
        }
        if (wmiModel2 != wmiCompositeModel2 && wmiModel2 != wmiModel) {
            wmiCompositeModel = wmiModel2.getParent();
            if (wmiCompositeModel == wmiCompositeModel2 && wmiCompositeModel.getTag() == WmiModelTag.MATH_ROW && wmiModel2 instanceof WmiTextModel) {
                string = ((WmiTextModel)wmiModel2).getText();
                if (n3 > 0 && n3 < string.length() && (n = wmiCompositeModel.indexOf(wmiModel2)) >= 0) {
                    wmiModelArray[2] = wmiModel2 = MathInsertUtil.createModel((WmiTextModel)wmiModel2, string, 0, n3);
                    wmiTextModel2 = MathInsertUtil.createModel((WmiTextModel)wmiModel2, string, n3, string.length());
                    wmiModelArray[3] = wmiTextModel2;
                    wmiCompositeModel.replaceChild(wmiModel2, n);
                }
            }
            while (wmiCompositeModel != null && wmiCompositeModel != wmiCompositeModel2) {
                wmiModel2 = wmiCompositeModel;
                wmiCompositeModel = wmiCompositeModel.getParent();
            }
            n5 = wmiCompositeModel2.indexOf(wmiModel2);
        }
        if (n4 >= 0 && n5 >= 0) {
            wmiModelPosition3 = n5 != n4 ? MathInsertUtil.wrap(wmiCompositeModel2, n4, n5, wmiTextModel2, wmiTextModel) : new WmiModelPosition(wmiModel, 0);
        }
        MathInsertUtil.retokenize(wmiModelArray);
        return wmiModelPosition3;
    }

    private static WmiModelPosition wrap(WmiCompositeModel wmiCompositeModel, int n, int n2, WmiModel wmiModel, WmiModel wmiModel2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n3 = n2 - n + 1;
        WmiModel[] wmiModelArray = new WmiModel[n3];
        for (int i = 0; i < n3; ++i) {
            wmiModelArray[i] = wmiCompositeModel.getChild(i + n);
        }
        WmiMathDocumentModel wmiMathDocumentModel = wmiCompositeModel.getDocument();
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        wmiInlineMathModel.setAttributes(wmiCompositeModel.getAttributes());
        int n4 = 1;
        int n5 = 0;
        if (wmiModel2 != null) {
            ++n4;
        }
        if (wmiModel != null) {
            ++n4;
        }
        WmiModel[] wmiModelArray2 = new WmiModel[n4];
        if (wmiModel2 != null) {
            wmiModelArray2[n5++] = wmiModel2;
        }
        wmiModelArray2[n5++] = wmiInlineMathModel;
        if (wmiModel != null) {
            wmiModelArray2[n5++] = wmiModel;
        }
        wmiCompositeModel.replaceChildren(wmiModelArray2, n, n3);
        WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel);
        wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
        return new WmiModelPosition(wmiInlineMathModel, -1);
    }

    private static void retokenize(ArrayList arrayList) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] wmiModelArray = new WmiModel[arrayList.size()];
        arrayList.toArray(wmiModelArray);
        MathInsertUtil.retokenize(wmiModelArray);
    }

    private static WmiModelPosition retokenize(ArrayList arrayList, int n, int n2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] wmiModelArray = new WmiModel[arrayList.size()];
        arrayList.toArray(wmiModelArray);
        return MathInsertUtil.retokenize(wmiModelArray, n, n2);
    }

    private static void retokenize(WmiModel[] wmiModelArray) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        for (int i = 0; i < wmiModelArray.length; ++i) {
            WmiCompositeModel wmiCompositeModel;
            int n;
            WmiModel wmiModel = wmiModelArray[i];
            if (!(wmiModel instanceof WmiTextModel) || (n = (wmiCompositeModel = wmiModel.getParent()).indexOf(wmiModel)) < 0) continue;
            MathTokenizer.retokenize((WmiTextModel)wmiModel, 0, false);
        }
    }

    private static WmiModelPosition retokenize(WmiModel[] wmiModelArray, int n, int n2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition wmiModelPosition = null;
        for (int i = 0; i < wmiModelArray.length; ++i) {
            WmiCompositeModel wmiCompositeModel;
            int n3;
            WmiModel wmiModel = wmiModelArray[i];
            if (!(wmiModel instanceof WmiTextModel) || (n3 = (wmiCompositeModel = wmiModel.getParent()).indexOf(wmiModel)) < 0) continue;
            if (i == n) {
                wmiModelPosition = MathTokenizer.retokenize((WmiTextModel)wmiModel, n2, false);
                continue;
            }
            MathTokenizer.retokenize((WmiTextModel)wmiModel, 0, false);
        }
        return wmiModelPosition;
    }

    public static WmiTextModel createModel(WmiTextModel wmiTextModel, String string, int n, int n2) throws WmiNoReadAccessException {
        return MathInsertUtil.createModel(wmiTextModel, string, string, true, n, n2);
    }

    public static WmiTextModel createModel(WmiTextModel wmiTextModel, String string, String string2, boolean bl, int n, int n2) throws WmiNoReadAccessException {
        WmiFontAttributeSet wmiFontAttributeSet;
        int n3;
        WmiAbstractMathTokenModel wmiAbstractMathTokenModel = null;
        WmiModelTag wmiModelTag = wmiTextModel.getTag();
        string = string.substring(n, n2);
        if (bl) {
            string2 = string2.substring(n, n2);
        }
        boolean bl2 = ((n3 = (wmiFontAttributeSet = (WmiFontAttributeSet)wmiTextModel.getAttributes()).getExtendedStyle()) & 1) != 0;
        boolean bl3 = (n3 & 2) != 0;
        int n4 = WmiAbstractMathTokenModel.getPrototype(wmiTextModel, n3);
        int n5 = n3 ^ n4;
        wmiFontAttributeSet.setExtendedStyle(n3 &= 0xFFFFE7FC);
        WmiMathDocumentModel wmiMathDocumentModel = wmiTextModel.getDocument();
        if (wmiModelTag == WmiModelTag.MATH_IDENTIFIER) {
            wmiFontAttributeSet.setExtendedStyle(n3);
            wmiAbstractMathTokenModel = new WmiIdentifierModel(wmiMathDocumentModel, string, string2, wmiFontAttributeSet, false);
        } else {
            wmiAbstractMathTokenModel = wmiModelTag == WmiModelTag.MATH_OPERATOR ? new WmiMathOperatorModel(wmiMathDocumentModel, string, string2, wmiFontAttributeSet) : (wmiModelTag == WmiModelTag.MATH_NUMERIC ? new WmiNumericModel(wmiMathDocumentModel, string, wmiFontAttributeSet) : new WmiMathTextModel(wmiMathDocumentModel, string, (WmiAttributeSet)wmiFontAttributeSet));
        }
        WmiFontAttributeSet wmiFontAttributeSet2 = (WmiFontAttributeSet)wmiAbstractMathTokenModel.getAttributes();
        int n6 = wmiFontAttributeSet2.getExtendedStyle();
        int n7 = WmiAbstractMathTokenModel.getPrototype(wmiAbstractMathTokenModel, n6);
        wmiFontAttributeSet2.setExtendedStyle(n7);
        if ((n5 & 1) != 0) {
            wmiFontAttributeSet2.setStyle(1, bl2);
        }
        if ((n5 & 2) != 0) {
            wmiFontAttributeSet2.setStyle(2, bl3);
        }
        try {
            wmiAbstractMathTokenModel.addAttributes(wmiFontAttributeSet2);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        return wmiAbstractMathTokenModel;
    }

    public static WmiMathContext createContext(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiMathContext wmiMathContext = null;
        WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
        if (wmiMathWrapperModel != null) {
            wmiMathContext = WmiMathWrapperModel.createContext(wmiMathWrapperModel.getAttributesForRead());
        }
        return wmiMathContext;
    }

    public static WmiModelPosition performModelWrap(WmiModel wmiModel, WmiCompositeModel wmiCompositeModel, WmiMathContext wmiMathContext, int n, int n2, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n3;
        WmiModelPosition wmiModelPosition = null;
        WmiCompositeModel wmiCompositeModel2 = wmiModel.getParent();
        int n4 = n3 = wmiCompositeModel2 != null ? wmiCompositeModel2.indexOf(wmiModel) : -1;
        if (wmiCompositeModel == null) {
            WmiErrorLog.log(new Exception("null replacement"));
        }
        if (n3 >= 0 && wmiCompositeModel != null) {
            wmiCompositeModel2.replaceChild(wmiCompositeModel, n3);
            WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel2);
            if (wmiModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel3 = (WmiCompositeModel)wmiModel;
                if (wmiCompositeModel3.getTag() == WmiModelTag.MATH_ROW) {
                    int n5 = 0;
                    for (int i = 0; i < wmiCompositeModel3.getChildCount(); ++i) {
                        if (WmiModelUtil.isEmptyModel(wmiCompositeModel3.getChild(i))) continue;
                        ++n5;
                    }
                    bl &= n5 > 1;
                }
                if (bl && wmiModel.getTag() != WmiModelTag.MATH_FENCED) {
                    wmiModel = WmiMathFactory.addBrackets((WmiMathModel)wmiModel, wmiMathContext);
                }
            }
            wmiCompositeModel.replaceChild(wmiModel, n);
            wmiModelPosition = n2 >= 0 ? new WmiModelPosition(wmiCompositeModel.getChild(n2), 0) : new WmiModelPosition(wmiCompositeModel, -1);
        }
        return wmiModelPosition;
    }
}

