/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.components.WmiPopupList;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.insert.WmiInsertEntityCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiSearchAndSelect;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import com.maplesoft.util.MathMLEntityMap;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class WmiEntityListCommand
extends WmiInsertEntityCommand {
    public static final EntityStore AVAILABLE_ENTITIES;
    public static final HashMap COMMANDS_IN_LIST;
    private static WmiSymbolList symbolList;

    protected static String resolvedDisplayName(Object object) {
        String string = object.toString();
        if (string.equals("Pi")) {
            string = "Pi (uppercase Greek)";
        }
        return string;
    }

    public WmiEntityListCommand(String string) {
        super(string);
        Iterator iterator = COMMANDS_IN_LIST.values().iterator();
        while (iterator.hasNext()) {
            this.addQueueableCommand((String)iterator.next());
        }
    }

    public WmiEntityListCommand() {
        this("Insert.Entitylist");
    }

    public void doCommand(ActionEvent actionEvent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiPositionMarker wmiPositionMarker;
        WmiMathDocumentView wmiMathDocumentView = WmiEntityListCommand.getDocumentView(actionEvent);
        if (wmiMathDocumentView != null && (wmiPositionMarker = wmiMathDocumentView.getPositionMarker()) != null) {
            Vector vector;
            WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
            WmiModel wmiModel = wmiPositionedView.getModel();
            String string = "";
            if (wmiModel instanceof WmiTextModel) {
                string = ((WmiTextModel)wmiModel).getText();
            }
            if ((vector = AVAILABLE_ENTITIES.lookup(string)).size() == 1 && vector.get(0) != null) {
                this.insertFromList(wmiMathDocumentView, vector.get(0), null);
            } else if (vector.size() > 0 && symbolList == null) {
                symbolList = this.getSymbolList(wmiMathDocumentView, vector, string, 0, 0, null);
                symbolList.display();
            }
        }
    }

    public static void popDownList() {
        if (symbolList != null) {
            symbolList.setVisible(false);
        }
        symbolList = null;
    }

    protected String[] getData(WmiModel wmiModel) throws WmiNoReadAccessException {
        String string = null;
        String string2 = null;
        if (wmiModel instanceof WmiAbstractMathTokenModel) {
            string = ((WmiAbstractMathTokenModel)wmiModel).getSemanticLabel();
            int n = string.indexOf(38);
            int n2 = string.lastIndexOf(59);
            if (n != -1 && n2 != -1) {
                string2 = string.substring(n, n2 + 1);
                string = string.substring(n2 + 1, string.length());
            }
        }
        String[] stringArray = new String[]{string, string2};
        return stringArray;
    }

    protected boolean isAll(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            return false;
        }
        return true;
    }

    protected void insertFromList(WmiMathDocumentView wmiMathDocumentView, Object object, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiPositionMarker wmiPositionMarker;
        if (wmiMathDocumentView != null && (wmiPositionMarker = wmiMathDocumentView.getPositionMarker()) != null) {
            Object object2;
            String string2;
            WmiPositionedView wmiPositionedView = wmiPositionMarker.getView();
            WmiModel wmiModel = wmiPositionedView.getModel();
            WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
            WmiModelLock.writeLock(wmiModel, true);
            WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
            int n = wmiCompositeModel.indexOf(wmiModel);
            if (wmiPositionMarker != null) {
                UpdatePositionAfterInsert updatePositionAfterInsert = new UpdatePositionAfterInsert(wmiPositionMarker, wmiCompositeModel, n, wmiMathDocumentView);
                wmiMathDocumentView.setPendingPositionUpdateHandler(updatePositionAfterInsert);
            }
            boolean bl = false;
            if (wmiSelection == null) {
                if (wmiModel instanceof WmiTextModel) {
                    int n2;
                    WmiCompositeModel wmiCompositeModel2;
                    string2 = ((WmiTextModel)wmiModel).getText();
                    if (string2.equals("[")) {
                        bl = true;
                    }
                    if (wmiCompositeModel.getTag() != WmiModelTag.MATH_ROW) {
                        object2 = wmiModel.getAttributes();
                        wmiCompositeModel2 = new WmiInlineMathModel(wmiModel.getDocument());
                        try {
                            wmiCompositeModel.replaceChild(wmiCompositeModel2, n);
                            ((WmiAbstractArrayCompositeModel)wmiCompositeModel2).appendChild(wmiModel);
                        }
                        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                        }
                        ((WmiAbstractModel)((Object)wmiCompositeModel2)).setAttributes((WmiAttributeSet)object2);
                    }
                    WmiSearchAndSelect.selectTextModel(wmiMathDocumentView, (WmiTextModel)wmiModel);
                    if (wmiModel instanceof WmiMathOperatorModel && this.isAll(((WmiTextModel)(object2 = (WmiMathOperatorModel)wmiModel)).getAllText(), '@') && (n2 = (wmiCompositeModel2 = ((WmiAbstractModel)object2).getParent()).indexOf((WmiModel)object2)) > 0) {
                        WmiTextModel wmiTextModel = (WmiTextModel)wmiCompositeModel2.getChild(n2 - 1);
                        WmiViewFactory wmiViewFactory = wmiMathDocumentView.getViewFactory();
                        WmiSelectionBuilder wmiSelectionBuilder = wmiViewFactory.getSelectionBuilder();
                        WmiSelection wmiSelection2 = wmiSelectionBuilder.createSelection(wmiTextModel, 0, (WmiModel)object2, ((WmiTextModel)object2).getLength());
                        wmiMathDocumentView.setSelection(wmiSelection2);
                    }
                } else if (wmiModel instanceof WmiCompositeModel) {
                    WmiSearchAndSelect.selectCompositeModel(wmiMathDocumentView, (WmiCompositeModel)wmiModel);
                }
            }
            if (object instanceof StoredObjectResult) {
                this.handleStoredObjectInsert(wmiModel, (StoredObjectResult)object, wmiMathDocumentView, string, bl);
            } else {
                string2 = object.toString();
                if (COMMANDS_IN_LIST.containsKey(string2)) {
                    object2 = (String)COMMANDS_IN_LIST.get(string2);
                    WmiCommand.invokeCommand((String)object2);
                } else {
                    if (string == null) {
                        string = "";
                    }
                    if (!string2.startsWith("<")) {
                        this.insert(wmiMathDocumentView, string + "&" + string2 + ";");
                    } else {
                        object2 = WmiInsertMathMLCommand.DEFAULT_MATHML_INSERTER;
                        ((WmiInsertGenericMathCommand)object2).doInsertionCommand(wmiMathDocumentView, string2);
                    }
                }
            }
            WmiModelLock.writeUnlock(wmiModel);
        }
    }

    protected void handleStoredObjectInsert(WmiModel wmiModel, StoredObjectResult storedObjectResult, WmiMathDocumentView wmiMathDocumentView, String string, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
    }

    public WmiSymbolList getSymbolList(WmiMathDocumentView wmiMathDocumentView, Vector vector, String string, int n, int n2, String string2) {
        return new WmiSymbolList(wmiMathDocumentView, vector, string, n, n2, string2);
    }

    static {
        Object object;
        AVAILABLE_ENTITIES = new EntityStore();
        COMMANDS_IN_LIST = new HashMap();
        symbolList = null;
        MathMLEntityMap mathMLEntityMap = MathMLEntityMap.getInstance();
        Iterator iterator = mathMLEntityMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            AVAILABLE_ENTITIES.insert((String)object);
        }
        AVAILABLE_ENTITIES.insert("sqrt", "<mrow><msqrt><mi>a</mi></msqrt></mrow>");
        object = COMMANDS_IN_LIST.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            AVAILABLE_ENTITIES.insert(string);
        }
    }

    public class WmiSymbolCellRenderer
    extends JPanel
    implements ListCellRenderer {
        String entity = null;
        protected JLabel label;
        protected JLabel image;
        protected Color focusCol;
        protected Color focusColFG;
        protected Color regularLabel;
        protected Color stripeColor;
        protected WmiMathDocumentView renderView = new WmiMathDocumentView();

        public WmiSymbolCellRenderer() {
            this.setOpaque(true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            this.label = new JLabel();
            this.add((Component)this.label, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            this.image = new JLabel();
            this.add((Component)this.image, gridBagConstraints);
            this.label.setHorizontalAlignment(2);
            this.image.setHorizontalAlignment(4);
            this.stripeColor = RuntimePlatform.isMac() ? new Color(237, 243, 254) : new Color((int)((double)Color.LIGHT_GRAY.getRed() * 1.1), (int)((double)Color.LIGHT_GRAY.getGreen() * 1.1), (int)((double)Color.LIGHT_GRAY.getBlue() * 1.1));
            this.setBackground(this.stripeColor);
            if (RuntimePlatform.isMac()) {
                this.focusCol = new Color(56, 117, 215);
                this.focusColFG = Color.WHITE;
            } else if (RuntimePlatform.isWindows()) {
                this.focusCol = new Color(121, 121, 178);
                this.focusColFG = Color.WHITE;
            } else {
                this.focusCol = UIManager.getColor("Tree.selectionBackground");
                this.focusColFG = UIManager.getColor("Tree.selectionForeground");
            }
            this.regularLabel = UIManager.getColor("Label.foreground");
        }

        private boolean isListFocusable(JList jList) {
            Container container = jList.getParent();
            while (container.getParent() != null && !(container instanceof Window)) {
                container = container.getParent();
            }
            if (container instanceof Window) {
                Window window = (Window)container;
                return window.isFocusableWindow();
            }
            return false;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return this.getListCellRendererComponent(jList, object, n, bl, bl2, false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2, boolean bl3) {
            String string = null;
            if (object instanceof StoredObjectResult) {
                this.entity = ((StoredObjectResult)object).getRenderString();
                string = object.toString();
            } else {
                this.entity = object.toString();
                string = WmiEntityListCommand.resolvedDisplayName(object);
            }
            this.label.setText(string);
            Image image = this.prepareImage(this.entity, this.renderView, bl, !bl3);
            if (image != null) {
                this.image.setIcon(new ImageIcon(image));
            }
            if (bl2 || RuntimePlatform.isMac_10_2() && bl || !this.isListFocusable(jList) && bl) {
                this.label.setBackground(this.focusCol);
                this.label.setForeground(this.focusColFG);
                this.setBackground(this.focusCol);
                this.setForeground(this.focusColFG);
            } else {
                Color color = n % 2 == 0 ? this.stripeColor : Color.WHITE;
                this.setBackground(color);
                this.label.setForeground(this.regularLabel);
                this.image.setBackground(this.regularLabel);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image prepareImage(String string, WmiMathDocumentView wmiMathDocumentView, boolean bl, boolean bl2) {
            Image image = null;
            boolean bl3 = WmiModelLock.writeLock(wmiMathDocumentView.getModel(), true);
            try {
                WmiMathOperatorModel wmiMathOperatorModel;
                WmiFontAttributeSet wmiFontAttributeSet = this.getRenderFontAttributes(bl);
                if (WmiMathOperatorDictionary.isNameForOperator("&" + string + ";") && bl2 && ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)(wmiMathOperatorModel = new WmiMathOperatorModel((WmiMathDocumentModel)wmiMathDocumentView.getModel(), "", "&" + string + ";", new WmiMathContext(wmiFontAttributeSet))).getAttributesForRead()).isLargeOp()) {
                    image = WmiMathViewUtil.renderMathML("<mo>&" + string + ";</mo>", wmiMathDocumentView, 2, true, wmiFontAttributeSet);
                }
                if (image == null) {
                    image = WmiMathViewUtil.renderMathMLEntity(string, 2, wmiFontAttributeSet, bl2);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
            finally {
                if (bl3) {
                    WmiModelLock.writeUnlock(wmiMathDocumentView.getModel());
                }
            }
            return image;
        }

        protected WmiFontAttributeSet getRenderFontAttributes(boolean bl) {
            WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
            if (RuntimePlatform.isMac()) {
                wmiFontAttributeSet.setSize(18);
            }
            if (bl) {
                wmiFontAttributeSet.setForeground(this.focusColFG.getRGB());
            }
            return wmiFontAttributeSet;
        }
    }

    private static class InequalityStoredObjectResult
    extends StoredObjectResult {
        private InequalityStoredObjectResult(String string, Object object) {
            super(string, object);
        }

        public String getRenderString() {
            return this.key.equals(">") ? "Greater Than" : "Less Than";
        }
    }

    public static class StoredObjectResult {
        protected Object stored;
        protected String key;

        public static StoredObjectResult createStoredObject(String string, Object object) {
            StoredObjectResult storedObjectResult = null;
            storedObjectResult = string.equals("<") || string.equals(">") ? new InequalityStoredObjectResult(string, object) : new StoredObjectResult(string, object);
            return storedObjectResult;
        }

        private StoredObjectResult(String string, Object object) {
            this.key = string;
            this.stored = object;
        }

        public String toString() {
            return this.key;
        }

        public String getRenderString() {
            return this.key;
        }

        public Object getStoredObject() {
            return this.stored;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof StoredObjectResult) {
                StoredObjectResult storedObjectResult = (StoredObjectResult)object;
                bl = this.key != null && this.key.equals(storedObjectResult.key) && this.stored != null && this.stored.equals(storedObjectResult.stored);
            } else {
                bl = super.equals(object);
            }
            return bl;
        }

        public int hashCode() {
            int n = 0;
            if (this.key != null) {
                n = this.key.hashCode();
            }
            if (this.stored != null) {
                n += this.stored.hashCode();
            }
            return n;
        }
    }

    protected static class ResultComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return WmiEntityListCommand.resolvedDisplayName(object).compareToIgnoreCase(WmiEntityListCommand.resolvedDisplayName(object2));
        }
    }

    public static class EntityStore {
        private StoreNode root = new StoreNode();

        public void insert(String string) {
            this.insert(string, string);
        }

        public void insert(String string, Object object) {
            StoreNode storeNode = this.root;
            int n = string.length() - 1;
            for (int i = 0; i < n; ++i) {
                storeNode = storeNode.insert(string.charAt(i), false);
            }
            storeNode.insert(string.charAt(n), true, object);
        }

        public void remove(String string, Class clazz) {
            this.remove(string, null, clazz);
        }

        public void remove(String string, String string2, Class clazz) {
            StoreNode storeNode;
            LinkedList<StoreNode> linkedList = new LinkedList<StoreNode>();
            StoreNode storeNode2 = this.root;
            int n = string.length() - 1;
            for (int i = 0; i < n && storeNode2 != null; ++i) {
                if ((storeNode2 = storeNode2.findChild(string.charAt(i))) == null) continue;
                linkedList.add(storeNode2);
            }
            if (storeNode2 != null && (storeNode = storeNode2.findChild(string.charAt(n))) != null) {
                int n2;
                if (string2 != null) {
                    storeNode.remove(clazz, string2);
                } else {
                    storeNode.remove(clazz);
                }
                if (storeNode.isRemovable()) {
                    this.removeNode(storeNode2, storeNode);
                }
                for (int i = n2 = linkedList.size() - 1; i >= 0; --i) {
                    StoreNode storeNode3 = (StoreNode)linkedList.get(i);
                    if (!storeNode3.isRemovable()) continue;
                    StoreNode storeNode4 = i > 0 ? (StoreNode)linkedList.get(i - 1) : this.root;
                    this.removeNode(storeNode4, storeNode3);
                }
            }
        }

        private void removeNode(StoreNode storeNode, StoreNode storeNode2) {
            StoreNode storeNode3 = storeNode2.previousSibling;
            StoreNode storeNode4 = storeNode2.nextSibling;
            if (storeNode3 == null && storeNode2 == storeNode.childRoot) {
                storeNode.childRoot = storeNode4;
            }
            if (storeNode3 != null) {
                storeNode3.nextSibling = storeNode4;
            }
            if (storeNode4 != null) {
                storeNode4.previousSibling = storeNode3;
            }
            storeNode2.nextSibling = null;
            storeNode2.previousSibling = null;
            storeNode2.childRoot = null;
        }

        public boolean contains(String string, Object object) {
            boolean bl = false;
            boolean bl2 = object instanceof StoredObjectResult;
            Vector vector = this.lookup(string);
            int n = vector.size();
            if (n > 0) {
                for (int i = 0; i < n && !bl; ++i) {
                    Object e = vector.get(i);
                    if (e instanceof StoredObjectResult) {
                        StoredObjectResult storedObjectResult = (StoredObjectResult)e;
                        bl = storedObjectResult.equals(object);
                        if (bl) continue;
                        if (bl2) {
                            StoredObjectResult storedObjectResult2 = (StoredObjectResult)object;
                            if (!string.equals(storedObjectResult.toString()) && !storedObjectResult2.toString().equals(storedObjectResult.toString())) continue;
                            bl = storedObjectResult.getStoredObject().equals(storedObjectResult2.getStoredObject());
                            continue;
                        }
                        bl = string.equals(storedObjectResult.toString()) && storedObjectResult.getStoredObject().equals(object);
                        continue;
                    }
                    bl = object != null && object.equals(e);
                }
            }
            return bl;
        }

        public Vector lookup(String string) {
            Vector vector = new Vector();
            LinkedList<StoreNode> linkedList = new LinkedList<StoreNode>();
            int n = string.length();
            StoreNode storeNode = this.root;
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                StoreNode storeNode2 = storeNode.findChild(c);
                if (storeNode2 == null) {
                    bl = false;
                    break;
                }
                linkedList.add(storeNode);
                storeNode = storeNode2;
            }
            if (storeNode != this.root && bl) {
                storeNode.buildResults(linkedList, vector, n);
                Collections.sort(vector, new ResultComparator());
            }
            return vector;
        }

        private static class StoreNode {
            private char storedChar;
            boolean terminal = false;
            Object storedData = null;
            StoreNode previousSibling = null;
            StoreNode childRoot = null;
            StoreNode nextSibling = null;

            public StoreNode() {
            }

            public StoreNode(char c, boolean bl, Object object) {
                this.storedChar = c;
                this.storedData = object;
                this.terminal = bl;
            }

            public StoreNode findChild(char c) {
                StoreNode storeNode = null;
                StoreNode storeNode2 = this.childRoot;
                while (storeNode2 != null && storeNode == null) {
                    if (storeNode2.storedChar == c) {
                        storeNode = storeNode2;
                    }
                    storeNode2 = storeNode2.nextSibling;
                }
                return storeNode;
            }

            public boolean isRemovable() {
                boolean bl = !this.terminal && (this.storedData == null || this.storedData instanceof CollisionItems && ((CollisionItems)this.storedData).size() == 0);
                return bl &= this.childRoot == null;
            }

            public void remove(Class clazz) {
                if (this.storedData instanceof CollisionItems) {
                    CollisionItems collisionItems = (CollisionItems)this.storedData;
                    Iterator iterator = collisionItems.iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (object instanceof StoredObjectResult) {
                            object = ((StoredObjectResult)object).getStoredObject();
                        }
                        if (!clazz.isInstance(object)) continue;
                        iterator.remove();
                        break;
                    }
                    if (collisionItems.size() == 0) {
                        this.terminal = false;
                        this.storedData = null;
                    }
                } else {
                    Object object = this.storedData;
                    if (this.storedData instanceof StoredObjectResult) {
                        object = ((StoredObjectResult)this.storedData).getStoredObject();
                    }
                    if (clazz.isInstance(object)) {
                        this.terminal = false;
                        this.storedData = null;
                    }
                }
            }

            public void remove(Class clazz, String string) {
                StoredObjectResult storedObjectResult;
                if (this.storedData instanceof CollisionItems) {
                    CollisionItems collisionItems = (CollisionItems)this.storedData;
                    Iterator iterator = collisionItems.iterator();
                    while (iterator.hasNext()) {
                        StoredObjectResult storedObjectResult2;
                        Object e = iterator.next();
                        if (!(e instanceof StoredObjectResult) || !string.equals((storedObjectResult2 = (StoredObjectResult)e).getRenderString()) || !clazz.isInstance(storedObjectResult2.getStoredObject())) continue;
                        iterator.remove();
                        break;
                    }
                    if (collisionItems.size() == 0) {
                        this.terminal = false;
                        this.storedData = null;
                    }
                } else if (this.storedData instanceof StoredObjectResult && clazz.isInstance((storedObjectResult = (StoredObjectResult)this.storedData).getStoredObject()) && string.equals(storedObjectResult.getRenderString())) {
                    this.terminal = false;
                    this.storedData = null;
                }
            }

            public void buildResults(LinkedList linkedList, Vector vector, int n) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = linkedList.size();
                for (int i = 1; i < n2; ++i) {
                    StoreNode storeNode = (StoreNode)linkedList.get(i);
                    if (storeNode.storedChar > '\u0000') {
                        stringBuffer.append(storeNode.storedChar);
                    }
                    if (!storeNode.terminal || stringBuffer.length() < n) continue;
                    this.addNodeToResults(stringBuffer.toString(), storeNode, vector);
                }
                this.completeResults(stringBuffer.toString(), vector, n);
            }

            private void addNodeToResults(String string, StoreNode storeNode, Vector vector) {
                if (storeNode.storedData instanceof String) {
                    vector.add(storeNode.storedData);
                } else if (storeNode.storedData instanceof CollisionItems) {
                    Iterator iterator = ((CollisionItems)storeNode.storedData).iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e instanceof String) {
                            vector.add(e);
                            continue;
                        }
                        if (e instanceof StoredObjectResult) {
                            vector.add(StoredObjectResult.createStoredObject(string, ((StoredObjectResult)e).getStoredObject()));
                            continue;
                        }
                        vector.add(StoredObjectResult.createStoredObject(string, e));
                    }
                } else if (storeNode.storedData instanceof StoredObjectResult) {
                    vector.add(StoredObjectResult.createStoredObject(string, ((StoredObjectResult)storeNode.storedData).getStoredObject()));
                } else if (storeNode.storedData != null) {
                    vector.add(StoredObjectResult.createStoredObject(string, storeNode.storedData));
                }
            }

            private void completeResults(String string, Vector vector, int n) {
                StringBuffer stringBuffer = new StringBuffer(string);
                if (this.storedChar > '\u0000') {
                    stringBuffer.append(this.storedChar);
                }
                if (this.terminal && stringBuffer.length() >= n) {
                    this.addNodeToResults(stringBuffer.toString(), this, vector);
                }
                StoreNode storeNode = this.childRoot;
                while (storeNode != null) {
                    storeNode.completeResults(stringBuffer.toString(), vector, n);
                    storeNode = storeNode.nextSibling;
                }
            }

            public StoreNode insert(char c, boolean bl) {
                return this.insert(c, bl, null);
            }

            public StoreNode insert(char c, boolean bl, Object object) {
                Object object2;
                StoreNode storeNode = null;
                StoreNode storeNode2 = this.childRoot;
                while (storeNode2 != null) {
                    if (c == storeNode2.storedChar) {
                        if (bl) {
                            if (storeNode2.terminal) {
                                if (storeNode2.storedData instanceof CollisionItems) {
                                    object2 = (CollisionItems)storeNode2.storedData;
                                    int n = ((Vector)object2).size();
                                    boolean bl2 = true;
                                    String string = object.toString();
                                    for (int i = 0; i < n; ++i) {
                                        Object e = ((Vector)object2).get(i);
                                        String string2 = e.toString();
                                        if (this.compareKeys(string2, string) <= 0) continue;
                                        ((Vector)object2).insertElementAt(object, i);
                                        bl2 = false;
                                        break;
                                    }
                                    if (bl2) {
                                        ((Vector)object2).add(object);
                                    }
                                } else {
                                    String string;
                                    object2 = new CollisionItems();
                                    String string3 = storeNode2.storedData.toString();
                                    if (this.compareKeys(string3, string = object.toString()) > 0) {
                                        ((Vector)object2).add(object);
                                        ((Vector)object2).add(storeNode2.storedData);
                                    } else {
                                        ((Vector)object2).add(storeNode2.storedData);
                                        ((Vector)object2).add(object);
                                    }
                                    storeNode2.storedData = object2;
                                }
                            } else {
                                storeNode2.terminal = true;
                                storeNode2.storedData = object;
                            }
                        }
                        storeNode = storeNode2;
                        break;
                    }
                    if (storeNode2.storedChar > c) {
                        storeNode = new StoreNode(c, bl, object);
                        storeNode.nextSibling = storeNode2;
                        if (storeNode2.previousSibling != null) {
                            storeNode2.previousSibling.nextSibling = storeNode;
                            storeNode.previousSibling = storeNode2.previousSibling;
                        } else {
                            this.childRoot = storeNode;
                        }
                        storeNode2.previousSibling = storeNode;
                        break;
                    }
                    storeNode2 = storeNode2.nextSibling;
                }
                if (storeNode == null) {
                    storeNode = new StoreNode(c, bl, object);
                    if (this.childRoot != null) {
                        object2 = this.childRoot;
                        while (((StoreNode)object2).nextSibling != null) {
                            object2 = ((StoreNode)object2).nextSibling;
                        }
                        ((StoreNode)object2).nextSibling = storeNode;
                        storeNode.previousSibling = object2;
                    } else {
                        this.childRoot = storeNode;
                    }
                }
                return storeNode;
            }

            private int compareKeys(String string, String string2) {
                int n = string.length();
                int n2 = string2.length();
                int n3 = 0;
                int n4 = 0;
                while (n3 < n && n4 < n2) {
                    char c = string.charAt(n3);
                    char c2 = string2.charAt(n4);
                    if (c == '(' || c == ')') {
                        ++n3;
                        continue;
                    }
                    if (c2 == '(' || c2 == ')') {
                        ++n4;
                        continue;
                    }
                    if (c != c2 && (c = Character.toUpperCase(c)) != (c2 = Character.toUpperCase(c2)) && (c = Character.toLowerCase(c)) != (c2 = Character.toLowerCase(c2))) {
                        return c - c2;
                    }
                    ++n3;
                    ++n4;
                }
                return n - n2;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("StoreNode for: ");
                stringBuffer.append(this.storedChar);
                if (this.previousSibling != null) {
                    stringBuffer.append(" preceded by a node for ");
                    stringBuffer.append(this.previousSibling.storedChar);
                }
                if (this.nextSibling != null) {
                    stringBuffer.append(" followed by a node for ");
                    stringBuffer.append(this.nextSibling.storedChar);
                }
                return stringBuffer.toString();
            }

            private class CollisionItems
            extends Vector {
                private CollisionItems() {
                }
            }
        }
    }

    protected class WmiSymbolList
    extends WmiPopupList {
        StringBuffer currentText;
        private String prefixes;

        public WmiSymbolList(WmiMathDocumentView wmiMathDocumentView, Vector vector, String string, int n, int n2, String string2) {
            super(wmiMathDocumentView, vector, n, n2);
            this.currentText = new StringBuffer();
            this.prefixes = string2;
            this.currentText.append(string);
        }

        protected void createList(Vector vector) {
            super.createList(vector);
            this.list.setCellRenderer(this.getSymbolCellRenderer());
        }

        public ListCellRenderer getSymbolCellRenderer() {
            return new WmiSymbolCellRenderer();
        }

        protected void updateCharacter(char c) {
            this.currentText.append(c);
            ListModel listModel = this.list.getModel();
            int n = listModel.getSize();
            String string = this.currentText.toString();
            for (int i = 0; i < n; ++i) {
                Object e = listModel.getElementAt(i);
                if (!e.toString().startsWith(string)) continue;
                this.list.setSelectedIndex(i);
                break;
            }
        }

        protected void selectionFinalized() {
            try {
                super.selectionFinalized();
                WmiEntityListCommand.this.insertFromList(this.docView, this.selection, this.prefixes);
                symbolList = null;
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
        }
    }

    public class UpdatePositionAfterInsertOfCompositeModel
    implements WmiPositionUpdateHandler {
        private WmiModel insertModel;
        private WmiPositionMarker marker;
        private WmiMathDocumentView docView;

        public UpdatePositionAfterInsertOfCompositeModel(WmiModel wmiModel, WmiPositionMarker wmiPositionMarker, WmiMathDocumentView wmiMathDocumentView) {
            this.insertModel = wmiModel;
            this.marker = wmiPositionMarker;
            this.docView = wmiMathDocumentView;
        }

        public void updatePosition() throws WmiNoReadAccessException {
            WmiModel wmiModel = this.insertModel;
            while (wmiModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                wmiModel = wmiCompositeModel.getChild(wmiCompositeModel.getChildCount() - 1);
            }
            int n = 0;
            if (wmiModel instanceof WmiTextModel) {
                n = ((WmiTextModel)wmiModel).getLength();
            }
            this.docView.setSelection(null);
            this.marker.updateMarkerPosition(wmiModel, n);
        }
    }

    public class UpdatePositionAfterInsert
    implements WmiPositionUpdateHandler {
        private WmiCompositeModel parentModel;
        private WmiPositionMarker marker;
        private WmiMathDocumentView docView;
        private int lookupIndex = 0;

        public UpdatePositionAfterInsert(WmiPositionMarker wmiPositionMarker, WmiCompositeModel wmiCompositeModel, int n, WmiMathDocumentView wmiMathDocumentView) {
            this.marker = wmiPositionMarker;
            this.parentModel = wmiCompositeModel;
            this.lookupIndex = n;
            this.docView = wmiMathDocumentView;
        }

        public void updatePosition() throws WmiNoReadAccessException {
            WmiModel wmiModel = this.parentModel.getChild(this.lookupIndex);
            int n = 0;
            if (wmiModel instanceof WmiTextModel) {
                n = ((WmiTextModel)wmiModel).getLength();
            }
            this.docView.setSelection(null);
            this.marker.updateMarkerPosition(wmiModel, n);
        }
    }
}

