/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.InsertMathStructureCommand;
import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.util.WmiSearchVisitor;
import java.io.StringReader;

public class WmiInsertMathMLCommand
extends InsertMathStructureCommand {
    public static final String INSERT_COMMAND_NAME = "Insert.Mathml";
    public static final WmiInsertMathMLCommand DEFAULT_MATHML_INSERTER = new WmiInsertMathMLCommand("Insert.Mathml");

    public WmiInsertMathMLCommand() {
        this(INSERT_COMMAND_NAME);
    }

    public WmiInsertMathMLCommand(String string) {
        super(string);
    }

    public WmiInsertMathMLCommand(String string, boolean bl) {
        super(string, bl);
    }

    public boolean insert(WmiMathDocumentView wmiMathDocumentView, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return this.insert(wmiMathDocumentView, string, false);
    }

    public boolean insert(WmiMathDocumentView wmiMathDocumentView, String string, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel;
        boolean bl2 = false;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        WmiPositionedView wmiPositionedView = wmiPositionMarker != null ? wmiPositionMarker.getView() : null;
        WmiModel wmiModel2 = wmiModel = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
        if (wmiModel != null) {
            WmiMathContext wmiMathContext = WmiInsertMathMLCommand.createAppropriateContextForModel(wmiModel);
            WmiMathModel wmiMathModel = this.createInsertedModel(string, wmiModel, wmiMathContext);
            String string2 = this.getResource(5);
            bl2 = wmiSelection == null ? WmiInsertMathMLCommand.insertAtPositionMarker(wmiMathDocumentView, wmiMathModel, string2) : WmiInsertMathMLCommand.selectionWrapInsert(wmiMathDocumentView, wmiMathModel, true, string2, bl);
        }
        return bl2;
    }

    public static boolean insert(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiInsertMathMLCommand.insert(wmiMathDocumentView, wmiModel, string, false);
    }

    public static boolean insert(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, String string, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel2;
        boolean bl2 = false;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
        WmiPositionedView wmiPositionedView = wmiPositionMarker != null ? wmiPositionMarker.getView() : null;
        WmiModel wmiModel3 = wmiModel2 = wmiPositionedView != null ? wmiPositionedView.getModel() : null;
        if (wmiModel2 != null) {
            bl2 = wmiSelection == null ? WmiInsertMathMLCommand.insertAtPositionMarker(wmiMathDocumentView, wmiModel, string) : WmiInsertMathMLCommand.selectionWrapInsert(wmiMathDocumentView, wmiModel, false, string, bl);
        }
        return bl2;
    }

    private static boolean insertAtPositionMarker(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl = false;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        try {
            WmiModelPosition wmiModelPosition = MathInsertUtil.updateInsertionPoint(wmiPositionMarker, 0);
            MathInsertUtil.ensureParentMathRow(wmiModelPosition);
            WmiModel wmiModel2 = wmiModelPosition.getModel();
            if (wmiModel2 != null && wmiModel2.getTag() == WmiModelTag.MATH_STRING) {
                if (wmiModel instanceof WmiTextModel) {
                    String string2 = ((WmiTextModel)wmiModel).getText();
                    int n = wmiModelPosition.getOffset();
                    ((WmiTextModel)wmiModel2).insertText(string2, n);
                    wmiModelPosition = new WmiModelPosition(wmiModel2, n + string2.length());
                    wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                    WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
                    wmiMathDocumentModel.update(string);
                    bl = true;
                }
            } else {
                wmiModelPosition = MathInsertUtil.insertEmptyPlaceholder(wmiModelPosition);
                wmiModel2 = wmiModelPosition.getModel();
                WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
                int n = wmiCompositeModel.indexOf(wmiModel2);
                wmiCompositeModel.replaceChild(wmiModel, n);
                WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel);
                WmiModel wmiModel3 = WmiInsertMathMLCommand.findPlaceholder(wmiModel);
                if (wmiModel3 != null) {
                    WmiInsertMathMLCommand.selectModel(wmiMathDocumentView, wmiModel3);
                } else {
                    int n2 = wmiModel instanceof WmiTextModel ? ((WmiTextModel)wmiModel).getLength() : -1;
                    wmiModelPosition = wmiModel instanceof WmiTextModel ? MathTokenizer.retokenize((WmiTextModel)wmiModel, n2) : new WmiModelPosition(wmiModel, n2);
                    wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                }
                WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
                wmiMathDocumentModel.update(string);
                bl = true;
            }
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        return bl;
    }

    private static boolean selectionWrapInsert(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, boolean bl, String string, boolean bl2) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl3 = false;
        try {
            WmiModelPosition wmiModelPosition = MathInsertUtil.wrapSelection(wmiMathDocumentView);
            WmiModel wmiModel2 = wmiModelPosition != null ? wmiModelPosition.getModel() : null;
            WmiModel wmiModel3 = WmiInsertMathMLCommand.findSelectionPlaceholder(wmiModel);
            if (bl2) {
                wmiModel3 = WmiInsertMathMLCommand.findPlaceholder(wmiModel);
            }
            if (wmiModel2 != null) {
                WmiMathDocumentModel wmiMathDocumentModel = wmiModel2.getDocument();
                WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
                int n = wmiCompositeModel.indexOf(wmiModel2);
                wmiCompositeModel.replaceChild(wmiModel, n);
                WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel);
                if (wmiModel3 != null) {
                    if (bl) {
                        wmiCompositeModel = wmiModel3.getParent();
                        n = wmiCompositeModel.indexOf(wmiModel3);
                        wmiCompositeModel.replaceChild(wmiModel2, n);
                        WmiInsertGenericMathCommand.refreshSemantics(wmiCompositeModel);
                        WmiInsertMathMLCommand.selectModel(wmiMathDocumentView, wmiModel2);
                    } else {
                        WmiInsertMathMLCommand.selectModel(wmiMathDocumentView, wmiModel3);
                    }
                } else if (wmiModel instanceof WmiTextModel) {
                    wmiModelPosition = MathTokenizer.retokenize((WmiTextModel)wmiModel, ((WmiTextModel)wmiModel).getLength());
                    wmiMathDocumentView.setPendingPosition(wmiModelPosition);
                } else {
                    wmiMathDocumentView.setPendingPosition(wmiModel, -1);
                }
                wmiMathDocumentModel.update(string);
                bl3 = true;
            }
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
            WmiErrorLog.log(wmiNoUpdateAccessException);
        }
        return bl3;
    }

    public WmiMathModel createInsertedModel(String string, WmiModel wmiModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        return WmiInsertMathMLCommand.convertMathMLToModel(string, wmiModel, wmiMathContext);
    }

    public static WmiMathModel convertMathMLToModel(String string, WmiModel wmiModel, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiMathModel wmiMathModel = null;
        WmiMathDocumentModel wmiMathDocumentModel = wmiModel.getDocument();
        WmiGenericCompositeModel wmiGenericCompositeModel = new WmiGenericCompositeModel(wmiMathDocumentModel, null);
        WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
        String string2 = string.replaceAll("&", "&amp;");
        StringReader stringReader = new StringReader(string2);
        try {
            wmiMathMLImportParser.parse(stringReader, (WmiCompositeModel)wmiGenericCompositeModel, 0);
            wmiMathModel = (WmiMathModel)wmiGenericCompositeModel.getChild(0);
            WmiInsertMathMLCommand.replaceMactions(wmiMathModel);
            WmiInsertMathMLCommand.updateAttributes(wmiMathModel, wmiModel, wmiMathContext != null ? wmiMathContext.getStyle() : null);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        catch (WmiParseException wmiParseException) {
            System.err.println("*** parse exception dealing with:");
            System.err.println(string);
            System.err.println("===");
            System.err.println(string2);
            WmiErrorLog.log(wmiParseException);
        }
        return wmiMathModel;
    }

    public static WmiModel findSelectionPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiModel wmiModel2 = WmiModelUtil.findFirstTraversalOrderedDescendantWithAttribute(wmiModel, "selection-placeholder", "true");
        return wmiModel2;
    }

    public static WmiModel findPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        WmiModel wmiModel2 = WmiModelUtil.findFirstTraversalOrderedDescendantWithAttribute(wmiModel, "placeholder", "true");
        boolean bl = false;
        if (wmiModel2 instanceof WmiTextModel) {
            boolean bl2 = bl = ((WmiTextModel)wmiModel2).getLength() == 0;
            if (bl && WmiModelLock.ownsWriteLock(wmiModel)) {
                try {
                    wmiModel2.addAttribute("placeholder", "false");
                    wmiModel2 = WmiInsertMathMLCommand.findPlaceholder(wmiModel);
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
            }
        }
        return wmiModel2;
    }

    public static boolean replaceMactions(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        WmiModel wmiModel2 = WmiModelUtil.findFirstDescendantOfTag(wmiModel, WmiModelTag.MATH_ACTION);
        while (wmiModel2 != null) {
            WmiModel wmiModel3 = null;
            if (WmiInsertMathMLCommand.isSelectionPlaceholder(wmiModel2)) {
                wmiModel3 = ((WmiCompositeModel)wmiModel2).getChild(0);
                bl3 = true;
            } else if (WmiInsertMathMLCommand.isPlaceholder(wmiModel2)) {
                wmiModel3 = ((WmiCompositeModel)wmiModel2).getChild(0);
                bl2 = true;
            } else if (WmiInsertMathMLCommand.isAtomic(wmiModel2)) {
                wmiModel3 = ((WmiCompositeModel)wmiModel2).getChild(0);
                wmiModel3.addAttribute("Typesetting:-msemantics", "atomic");
            }
            if (wmiModel3 != null) {
                WmiCompositeModel wmiCompositeModel = wmiModel2.getParent();
                int n = wmiCompositeModel.indexOf(wmiModel2);
                try {
                    wmiCompositeModel.replaceChild(wmiModel3, n);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
                }
                if (bl2 || bl3) {
                    wmiModel2 = wmiModel3;
                    wmiModel2.addAttribute("placeholder", "true");
                }
                if (bl3) {
                    wmiModel2 = wmiModel3;
                    wmiModel2.addAttribute("selection-placeholder", "true");
                    bl3 = false;
                }
                bl = true;
            }
            wmiModel2 = WmiModelUtil.findNextModel(wmiModel, wmiModel2, WmiModelTag.MATH_ACTION);
        }
        return bl;
    }

    private static boolean isSelectionPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl;
        boolean bl2 = bl = wmiModel instanceof WmiCompositeModel && WmiInsertMathMLCommand.containsActionTypeValue(wmiModel, "maplesoft:selection-placeholder");
        if (!bl) {
            WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
            bl = wmiAttributeSet.getAttribute("selection-placeholder") == "true";
        }
        return bl;
    }

    private static boolean isAtomic(WmiModel wmiModel) throws WmiNoReadAccessException {
        return wmiModel instanceof WmiCompositeModel && WmiInsertMathMLCommand.containsActionTypeValue(wmiModel, "maplesoft:atomic");
    }

    private static boolean isPlaceholder(WmiModel wmiModel) throws WmiNoReadAccessException {
        return wmiModel instanceof WmiCompositeModel && WmiInsertMathMLCommand.containsActionTypeValue(wmiModel, "maplesoft:placeholder");
    }

    private static boolean containsActionTypeValue(WmiModel wmiModel, String string) throws WmiNoReadAccessException {
        Object object;
        WmiAttributeSet wmiAttributeSet;
        boolean bl = false;
        if (wmiModel != null && (wmiAttributeSet = wmiModel.getAttributesForRead()) != null && (object = wmiAttributeSet.getAttribute("actiontype")) != null && object.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private static void updateAttributes(WmiModel wmiModel, WmiModel wmiModel2, WmiAttributeSet wmiAttributeSet) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfClass(wmiModel2, WmiMathWrapperModel.class);
        if (wmiCompositeModel != null) {
            wmiAttributeSet = wmiCompositeModel.getAttributes();
        }
        if (wmiAttributeSet != null && wmiModel != null) {
            WmiMathMLAttributeUpdateVisitor wmiMathMLAttributeUpdateVisitor = new WmiMathMLAttributeUpdateVisitor(wmiAttributeSet);
            WmiModelUtil.visitModels(wmiModel, wmiMathMLAttributeUpdateVisitor);
        }
    }

    private static class WmiMathMLAttributeUpdateVisitor
    implements WmiSearchVisitor {
        private WmiAttributeSet attributeSet = null;

        private WmiMathMLAttributeUpdateVisitor(WmiAttributeSet wmiAttributeSet) {
            this.attributeSet = wmiAttributeSet;
        }

        public int visitMatch(Object object) {
            int n = 2;
            if (this.attributeSet != null) {
                try {
                    if (object instanceof WmiModel) {
                        this.update((WmiModel)object);
                        n = 0;
                    }
                }
                catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                    WmiErrorLog.log(wmiNoWriteAccessException);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
            }
            return n;
        }

        private void update(WmiModel wmiModel) throws WmiNoWriteAccessException, WmiNoReadAccessException {
            WmiAttributeSet wmiAttributeSet = wmiModel.getAttributes();
            if (!(wmiAttributeSet instanceof WmiMathTableModel.WmiMathTableAttributeSet)) {
                WmiModel wmiModel2 = WmiModelUtil.findAncestorWithAttribute(wmiModel, "placeholder", "true");
                if (wmiModel2 == null && wmiAttributeSet.getAttribute("placeholder") != "true") {
                    long l;
                    WmiAttributeSet wmiAttributeSet2 = wmiAttributeSet.copyAttributes();
                    boolean bl = true;
                    if (wmiModel instanceof WmiAbstractMathTokenModel && ((l = ((WmiAbstractMathTokenModel)wmiModel).getModified()) & 1L) != 0L) {
                        bl = false;
                    }
                    if (bl) {
                        Object object = this.attributeSet.getAttribute("foreground");
                        wmiAttributeSet2.addAttribute("foreground", object);
                    }
                    Object object = this.attributeSet.getAttribute("executable");
                    wmiAttributeSet2.addAttribute("executable", object);
                    Object object2 = this.attributeSet.getAttribute("readonly");
                    wmiAttributeSet2.addAttribute("readonly", object2);
                    Object object3 = this.attributeSet.getAttribute("size");
                    wmiAttributeSet2.addAttribute("size", object3);
                    wmiModel.addAttributes(wmiAttributeSet2);
                } else {
                    WmiAttributeSet wmiAttributeSet3 = wmiAttributeSet.copyAttributes();
                    Object object = this.attributeSet.getAttribute("executable");
                    wmiAttributeSet3.addAttribute("executable", object);
                    wmiModel.addAttributes(wmiAttributeSet3);
                }
            }
        }
    }
}

