/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.components.WmiTable;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagAttributeTable;
import com.maplesoft.mathdoc.dialog.WmiDialog;
import com.maplesoft.mathdoc.dialog.WmiDialogButton;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class WmiMetatagCategoriesDialog
extends WmiDialog
implements TableModelListener {
    protected static final String RESOURCE_PATH = "com.maplesoft.mathdoc.controller.metadata.resources.Metadata";
    protected static final int CATEGORY_COLUMN_WIDTH = 200;
    protected static final int CATEGORY_COLUMN_INDEX = 0;
    private WmiTable mtCategoryTable = null;
    private JScrollPane mtCategoryScrollPane = null;
    private WmiMetatagAttributeTable mtAttributesTable = null;
    private JScrollPane mtAttributesScrollPane = null;
    private WmiDialogButton mtAddCategoryBtn = null;
    private WmiDialogButton mtRemoveCategoryBtn = null;
    private WmiDialogButton mtAddAttributeBtn = null;
    private WmiDialogButton mtRemoveAttributeBtn = null;
    private WmiDialogButton mtCancelBtn = null;
    private WmiDialogButton mtOKBtn = null;
    private WmiMetadataManager dMgr = null;
    private HashMap categoryTableCopy = null;
    private boolean applyEdits = false;

    public WmiMetatagCategoriesDialog(JFrame jFrame, WmiMetadataManager wmiMetadataManager) {
        super((Frame)jFrame);
        this.dMgr = wmiMetadataManager;
        this.categoryTableCopy = this.dMgr.getCategoryListCopy();
        this.setTitle("MTCD_Title");
        this.createDialogComponents();
        this.layoutDialog();
    }

    public boolean editCategories() {
        this.show();
        return this.applyEdits;
    }

    protected void addComponents() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 0));
        container.add(this.createCategoryPanel());
        container.add(Box.createHorizontalStrut(10));
        container.add(this.createAttributePanel());
    }

    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    protected void createDialogComponents() {
        WmiCatListTableModel wmiCatListTableModel = new WmiCatListTableModel();
        this.mtCategoryTable = new WmiTable(wmiCatListTableModel);
        this.mtCategoryTable.getColumnModel().getColumn(0).setCellEditor(new WmiMetatagCategoryNameCellEditor());
        this.mtCategoryTable.getTableHeader().setReorderingAllowed(false);
        this.mtCategoryTable.setSelectionMode(0);
        this.mtCategoryTable.getSelectionModel().addListSelectionListener(new WmiCatListSelectionListener());
        Dimension dimension = this.mtCategoryTable.getPreferredScrollableViewportSize();
        dimension.width = 200;
        this.mtCategoryTable.setPreferredScrollableViewportSize(dimension);
        this.mtCategoryScrollPane = new JScrollPane(this.mtCategoryTable, 22, 31);
        this.mtAttributesTable = new WmiMetatagAttributeTable();
        this.mtAttributesScrollPane = new JScrollPane(this.mtAttributesTable, 22, 31);
        Dimension dimension2 = this.mtAttributesTable.getPreferredScrollableViewportSize();
        dimension2.height = dimension.height + 20;
        this.mtAttributesTable.setPreferredScrollableViewportSize(dimension2);
        this.mtAddCategoryBtn = this.createButton("MTCD_AddCategory");
        this.mtAddCategoryBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiMetatagCategoriesDialog.this.addCategoryAction();
            }
        });
        this.mtRemoveCategoryBtn = this.createButton("MTCD_RemoveCategory");
        this.mtRemoveCategoryBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiMetatagCategoriesDialog.this.removeCategoryAction();
            }
        });
        this.mtAddAttributeBtn = this.createButton("MTCD_AddAttribute");
        this.mtAttributesTable.setAddButton((JButton)this.mtAddAttributeBtn);
        this.mtAddAttributeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiMetatagCategoriesDialog.this.stopCategoryEdit();
            }
        });
        this.mtRemoveAttributeBtn = this.createButton("MTCD_RemoveAttribute");
        this.mtAttributesTable.setDeleteButton((JButton)this.mtRemoveAttributeBtn);
        this.mtRemoveAttributeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WmiMetatagCategoriesDialog.this.stopCategoryEdit();
            }
        });
        this.mtCancelBtn = this.createCancelButton();
        this.mtOKBtn = this.createOKButton();
        Iterator iterator = new TreeSet(this.categoryTableCopy.values()).iterator();
        while (iterator.hasNext()) {
            WmiMetatagCategory wmiMetatagCategory = (WmiMetatagCategory)iterator.next();
            wmiCatListTableModel.insertRow(wmiCatListTableModel.getRowCount(), new Object[]{wmiMetatagCategory});
        }
        this.mtCategoryTable.setRowSelectionInterval(0, 0);
        this.mtCategoryTable.getModel().addTableModelListener(this);
    }

    private JPanel createCategoryPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.mtCategoryScrollPane.setAlignmentX(0.0f);
        this.mtCategoryScrollPane.setAlignmentY(0.0f);
        jPanel.add(this.mtCategoryScrollPane);
        jPanel.add(this.createCategoryEditButtonPanel());
        return jPanel;
    }

    private JPanel createAttributePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.mtAttributesScrollPane.setAlignmentX(0.0f);
        this.mtAttributesScrollPane.setAlignmentY(0.0f);
        jPanel.add(this.mtAttributesScrollPane);
        jPanel.add(this.createAttributeButtonPanel());
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.createCategoryEditButtonPanel());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.createAttributeButtonPanel());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.createOkCancelButtonPanel());
        return jPanel;
    }

    private JPanel createAttributeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add(this.createAttributeEditButtonPanel());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.createOkCancelButtonPanel());
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(1.0f);
        return jPanel;
    }

    private JPanel createCategoryEditButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add((Component)this.mtAddCategoryBtn);
        jPanel.add((Component)this.mtRemoveCategoryBtn);
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(1.0f);
        return jPanel;
    }

    private JPanel createAttributeEditButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add((Component)this.mtAddAttributeBtn);
        jPanel.add((Component)this.mtRemoveAttributeBtn);
        return jPanel;
    }

    private JPanel createOkCancelButtonPanel() {
        JPanel jPanel = this.createDefaultButtonsPanel();
        return jPanel;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource() == this.mtCategoryTable.getModel()) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            int n3 = tableModelEvent.getType();
            if (n3 == 0 && n >= 0 && n2 == 0) {
                String string;
                WmiMetatagCategory wmiMetatagCategory;
                Object object = this.mtCategoryTable.getValueAt(n, n2);
                WmiMetatagCategory wmiMetatagCategory2 = wmiMetatagCategory = object instanceof WmiMetatagCategory ? (WmiMetatagCategory)object : null;
                if (wmiMetatagCategory != null && (string = this.mtCategoryTable.getValueAt(n, n2).toString()) != null) {
                    wmiMetatagCategory.setName(string);
                }
            }
        }
    }

    protected void addCategoryAction() {
        WmiMetatagCategory wmiMetatagCategory = new WmiMetatagCategory();
        WmiCatListTableModel wmiCatListTableModel = (WmiCatListTableModel)this.mtCategoryTable.getModel();
        wmiCatListTableModel.insertRow(wmiCatListTableModel.getRowCount(), new Object[]{wmiMetatagCategory});
        int n = wmiCatListTableModel.getRowCount() - 1;
        this.mtCategoryTable.setRowSelectionInterval(n, n);
        this.mtCategoryTable.requestFocus();
        this.mtCategoryTable.editCellAt(n, 0);
    }

    protected void removeCategoryAction() {
        this.stopCategoryEdit();
    }

    protected void newSelectionAction(int n) {
        this.mtAttributesTable.unloadTable();
        WmiMetatagCategory wmiMetatagCategory = (WmiMetatagCategory)this.mtCategoryTable.getValueAt(n, 0);
        if (wmiMetatagCategory != null) {
            this.mtAttributesTable.setMetadata(wmiMetatagCategory);
        }
    }

    protected void stopCategoryEdit() {
        TableCellEditor tableCellEditor = this.mtCategoryTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    protected void okAction() {
        this.stopCategoryEdit();
        this.mtAttributesTable.unloadTable();
        this.applyEdits = true;
        this.categoryTableCopy.clear();
        for (int i = 0; i < this.mtCategoryTable.getRowCount(); ++i) {
            Object object = this.mtCategoryTable.getValueAt(i, 0);
            WmiMetatagCategory wmiMetatagCategory = object instanceof WmiMetatagCategory ? (WmiMetatagCategory)object : null;
            this.categoryTableCopy.put(wmiMetatagCategory.getName(), wmiMetatagCategory);
        }
        this.dMgr.replaceCategoryList(this.categoryTableCopy);
        super.okAction();
    }

    protected void cancelAction() {
        this.applyEdits = false;
        super.cancelAction();
    }

    protected class WmiMetatagCategoryNameCellEditor
    extends DefaultCellEditor {
        public JTextField fld;
        private WmiMetatagCategory activeEditValue;
        private JTable activeEditTable;
        private int activeEditRow;
        private int activeEditCol;

        public WmiMetatagCategoryNameCellEditor() {
            super(new JTextField());
            this.fld = null;
            this.activeEditValue = null;
            this.activeEditTable = null;
            this.fld = (JTextField)this.getComponent();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof WmiMetatagCategory) {
                this.activeEditValue = (WmiMetatagCategory)object;
                this.activeEditTable = jTable;
                this.activeEditRow = n;
                this.activeEditCol = n2;
            }
            this.fld.setText(object.toString());
            return this.fld;
        }

        public boolean stopCellEditing() {
            boolean bl = super.stopCellEditing();
            if (bl) {
                Object object = this.getCellEditorValue();
                if (this.activeEditValue != null) {
                    this.activeEditValue.setName(object.toString());
                    this.activeEditTable.setValueAt(this.activeEditValue, this.activeEditRow, this.activeEditCol);
                }
                this.activeEditValue = null;
            }
            return bl;
        }

        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.activeEditValue = null;
        }
    }

    protected class WmiCatListSelectionListener
    implements ListSelectionListener {
        protected WmiCatListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel;
            if (!listSelectionEvent.getValueIsAdjusting() && !(listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                WmiMetatagCategoriesDialog.this.newSelectionAction(listSelectionModel.getMinSelectionIndex());
            }
        }
    }

    protected static class WmiCatListTableModel
    extends DefaultTableModel {
        private static final int TABLE_COLUMNS = 1;
        private static final String[] COLUMN_HEADINGS = new String[]{"Category"};

        protected WmiCatListTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            if (n < 1) {
                return COLUMN_HEADINGS[n];
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

