/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagInfoPopup;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagWrapperModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMetatagWrapperView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class WmiMetatagMouseListener
extends WmiMouseInputAdapter
implements ActionListener {
    private static final int TIMER_FIRING_INTERVAL = 50;
    private static final long POPUP_DELAY_TIME = 750L;
    private Timer tagDisplayTimer = new Timer(50, this);
    private long popupTime;
    private WmiMetatagInfoPopup infoPanel = null;
    private int popupLocX;
    private int popupLocY;

    public WmiMetatagMouseListener() {
        this.tagDisplayTimer.setRepeats(true);
        this.tagDisplayTimer.stop();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        WmiMetatag wmiMetatag = WmiMetatagMouseListener.getTagUnderMouse(mouseEvent);
        if (wmiMetatag != null) {
            WmiMetadataManager wmiMetadataManager;
            WmiMathDocumentView wmiMathDocumentView = null;
            Object object = mouseEvent.getSource();
            if (object instanceof WmiView) {
                wmiMathDocumentView = ((WmiView)object).getDocumentView();
            }
            if (wmiMathDocumentView != null && (wmiMetadataManager = wmiMathDocumentView.getModel().getDocument().getMetadataManager()).getPopupVisibility()) {
                Object object2 = mouseEvent.getSource();
                WmiPositionedView wmiPositionedView = object2 instanceof WmiPositionedView ? (WmiPositionedView)object2 : null;
                Point point = null;
                if (wmiPositionedView != null) {
                    point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
                }
                if (point != null) {
                    this.infoPanel = new WmiMetatagInfoPopup((Container)wmiMathDocumentView, wmiMetatag);
                    this.infoPanel.setLocation(point.x + mouseEvent.getX() - wmiPositionedView.getHorizontalOffset(), point.y + mouseEvent.getY());
                    this.rescheduleTimer();
                }
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.infoPanel != null) {
            this.infoPanel.setVisible(false);
            this.infoPanel = null;
        }
        this.cancelTimer();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.cancelPopup();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.cancelPopup();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.rescheduleTimer();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.cancelPopup();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (System.currentTimeMillis() > this.popupTime) {
            this.tagDisplayTimer.stop();
            if (this.infoPanel != null) {
                this.infoPanel.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTimer() {
        Timer timer = this.tagDisplayTimer;
        synchronized (timer) {
            this.popupTime = System.currentTimeMillis() + 750L;
            if (!this.tagDisplayTimer.isRunning()) {
                this.tagDisplayTimer.start();
            }
        }
    }

    private void cancelPopup() {
        this.cancelTimer();
        if (this.infoPanel != null) {
            this.infoPanel.setVisibleImmediately(false);
            this.infoPanel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimer() {
        Timer timer = this.tagDisplayTimer;
        synchronized (timer) {
            this.tagDisplayTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static WmiMetatag getTagUnderMouse(MouseEvent mouseEvent) {
        boolean bl;
        WmiMetadataManager wmiMetadataManager;
        WmiMetatagWrapperModel wmiMetatagWrapperModel;
        WmiMetatagWrapperView wmiMetatagWrapperView;
        WmiMetatag wmiMetatag = null;
        Object object = mouseEvent.getSource();
        WmiMetatagWrapperView wmiMetatagWrapperView2 = wmiMetatagWrapperView = object instanceof WmiMetatagWrapperView ? (WmiMetatagWrapperView)object : null;
        if (wmiMetatagWrapperView != null && (wmiMetatagWrapperModel = (WmiMetatagWrapperModel)wmiMetatagWrapperView.getModel()) != null && (wmiMetadataManager = wmiMetatagWrapperModel.getDocument().getMetadataManager()) != null && (bl = WmiModelLock.readLock(wmiMetatagWrapperModel.getDocument(), false))) {
            try {
                wmiMetatag = wmiMetadataManager.findMetatag(wmiMetatagWrapperModel.getMetatagId());
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(wmiMetatagWrapperModel.getDocument());
            }
        }
        return wmiMetatag;
    }
}

