/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import java.awt.Font;

public class WmiFontCache {
    private Font source;
    private Font[] cache;
    private int style;

    public WmiFontCache(Font font) {
        this(font, 0);
    }

    public WmiFontCache(Font font, int n) {
        this.source = font;
        this.style = n;
        this.cache = this.createFontCacheArray();
    }

    private int fontSizeToCacheIndex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("font size cannot be less than 1");
        }
        int n2 = -1;
        if (8 <= n && n < 18) {
            n2 = n - 8;
        } else if ((n & 1) == 0) {
            n2 = (n + 2) / 2;
        }
        return n2;
    }

    private Font[] createFontCacheArray() {
        return new Font[20];
    }

    public Font getFont(int n, int n2) {
        int n3;
        Font font = null;
        if (n == this.style && (n3 = this.fontSizeToCacheIndex(n2)) >= 0 && n3 < this.cache.length && (font = this.cache[n3]) == null) {
            this.cache[n3] = font = this.source.deriveFont(n, n2);
        }
        if (font == null) {
            font = this.source.deriveFont(n, n2);
        }
        return font;
    }

    public Font getFont() {
        return this.source;
    }

    public int getStyle() {
        return this.style;
    }
}

