/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.WmiUnicodeMapper;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class WmiFontMetrics {
    public static final int LINE_LEADER = 0;
    public static final int LOWERCASE_HEIGHT = 1;
    public static final int MAXIMUM_WIDTH = 2;
    public static final int MAXIMUM_ASCENT = 3;
    public static final int MAXIMUM_DESCENT = 4;
    public static final int FONT_HEIGHT = 5;
    public static final int FONT_PROPERTY_COUNT = 6;
    public static final int CHARACTER_WIDTH = 0;
    public static final int CHARACTER_PREKERN = 1;
    public static final int CHARACTER_ADVANCE = 2;
    public static final int CHARACTER_POSTKERN = 3;
    public static final int CHARACTER_ASCENT = 4;
    public static final int CHARACTER_DESCENT = 5;
    public static final int CHARACTER_GLYPHCODE = 6;
    public static final int CHARACTER_PROPERTY_COUNT = 7;
    public static final int BASE_CHARSET_SIZE = 256;
    private static WmiFontMetricComposer metricComposer = RuntimePlatform.isMac() && !RuntimePlatform.isJava15() ? new WmiMacFontMetricComposer() : new WmiDefaultFontMetricComposer();
    public static final AffineTransform DEFAULT_TRANSFORM = new AffineTransform();
    public static final boolean USE_ANTIALIASING = RuntimePlatform.isMac() || RuntimeLocale.isJapanese();
    public static final boolean USE_FRACTIONAL_METRICS = false;
    public static final int ANTI_ALIASING_DEFAULT = 0;
    public static final int ANTI_ALIASING_ENABLED = 1;
    public static final int ANTI_ALIASING_DISABLED = 2;
    private static FontRenderContext DEFAULT_PRINT_FRC = new FontRenderContext(DEFAULT_TRANSFORM, USE_ANTIALIASING, true);
    private static FontRenderContext SCREEN_ANTI_ALIAS_DEFAULT_FRC = new FontRenderContext(DEFAULT_TRANSFORM, USE_ANTIALIASING, false);
    private static FontRenderContext SCREEN_ANTI_ALIAS_ENABLED_FRC = new FontRenderContext(DEFAULT_TRANSFORM, true, false);
    private static FontRenderContext SCREEN_ANTI_ALIAS_DISABLED_FRC = new FontRenderContext(DEFAULT_TRANSFORM, false, false);
    private static FontRenderContext DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_DEFAULT_FRC;
    public static final float LOWERCASE_HEIGHT_RATIO = 0.65f;
    private static final float LINE_LEADER_RATIO = 0.1f;
    private WmiUnicodeMapper charsetScreenMetrics = new WmiUnicodeMapper();
    private WmiUnicodeMapper charsetPrintMetrics = new WmiUnicodeMapper();
    private float[] fontScreenMetrics = new float[6];
    private float[] fontPrintMetrics = new float[6];
    protected Font font;

    protected static WmiFontMetrics createFontMetrics(Font font) {
        WmiFontMetrics wmiFontMetrics = null;
        if (font != null) {
            wmiFontMetrics = font.getName().equals("MaplePi") ? new WmiMaplePiFontMetrics(font) : new WmiFontMetrics(font);
        }
        return wmiFontMetrics;
    }

    protected WmiFontMetrics(Font font) {
        this.font = font;
        this.fontScreenMetrics = metricComposer.buildFontMetrics(font, this, DEFAULT_SCREEN_FRC);
        this.fontPrintMetrics = metricComposer.buildFontMetrics(font, this, DEFAULT_PRINT_FRC);
    }

    public static void setFontAntiAliasing(int n) {
        switch (n) {
            case 0: {
                DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_DEFAULT_FRC;
                break;
            }
            case 1: {
                DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_ENABLED_FRC;
                break;
            }
            case 2: {
                DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_DISABLED_FRC;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value for anti-aliasing:" + n);
            }
        }
    }

    public static FontRenderContext getScreenContext() {
        return DEFAULT_SCREEN_FRC;
    }

    public static FontRenderContext getPrintContext() {
        return DEFAULT_PRINT_FRC;
    }

    public static boolean isScreenContext(FontRenderContext fontRenderContext) {
        return fontRenderContext == DEFAULT_SCREEN_FRC || fontRenderContext == SCREEN_ANTI_ALIAS_DEFAULT_FRC || fontRenderContext == SCREEN_ANTI_ALIAS_ENABLED_FRC || fontRenderContext == SCREEN_ANTI_ALIAS_DISABLED_FRC;
    }

    public int getFontProperty(int n) {
        return this.getFontProperty(n, false);
    }

    public int getFontProperty(int n, boolean bl) {
        int n2 = bl ? (int)this.fontPrintMetrics[n] : (int)this.fontScreenMetrics[n];
        return n2;
    }

    public int getFontProperty(int n, FontRenderContext fontRenderContext) {
        return this.getFontProperty(n, fontRenderContext == DEFAULT_PRINT_FRC);
    }

    public float getPreciseFontProperty(int n, FontRenderContext fontRenderContext) {
        float f = WmiFontMetrics.isScreenContext(fontRenderContext) ? this.fontScreenMetrics[n] : this.fontPrintMetrics[n];
        return f;
    }

    public int getCharacterProperty(int n, char c, boolean bl) {
        return this.getCharacterProperty(n, c, bl ? DEFAULT_PRINT_FRC : DEFAULT_SCREEN_FRC);
    }

    public int getCharacterProperty(int n, char c, FontRenderContext fontRenderContext) {
        return (int)this.getPreciseCharacterProperty(n, c, fontRenderContext);
    }

    public float getPreciseCharacterProperty(int n, char c, FontRenderContext fontRenderContext) {
        float f = -1.0f;
        float[] fArray = this.getCharacterMetrics(c, fontRenderContext);
        if (fArray != null) {
            f = fArray[n];
        }
        return f;
    }

    protected float[] getCharacterMetrics(char c, FontRenderContext fontRenderContext) {
        float[] fArray;
        if (WmiFontMetrics.isScreenContext(fontRenderContext)) {
            fArray = (float[])this.charsetScreenMetrics.get(c);
            if (fArray == null) {
                fArray = this.buildCharacterMetric(c, DEFAULT_SCREEN_FRC);
                this.charsetScreenMetrics.put(c, fArray);
            }
        } else {
            fArray = (float[])this.charsetPrintMetrics.get(c);
            if (fArray == null) {
                fArray = this.buildCharacterMetric(c, DEFAULT_PRINT_FRC);
                this.charsetPrintMetrics.put(c, fArray);
            }
        }
        return fArray;
    }

    public int getStringProperty(int n, String string, boolean bl) {
        return this.getStringProperty(n, string, bl ? DEFAULT_PRINT_FRC : DEFAULT_SCREEN_FRC);
    }

    public int getStringProperty(int n, String string, FontRenderContext fontRenderContext) {
        int n2 = 0;
        int n3 = string.length();
        if (n == 2) {
            for (int i = 0; i < n3; ++i) {
                n2 += this.getCharacterProperty(n, string.charAt(i), fontRenderContext);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                int n4 = this.getCharacterProperty(n, string.charAt(i), fontRenderContext);
                n2 = Math.max(n2, n4);
            }
        }
        return n2;
    }

    private float[] buildCharacterMetric(char c, FontRenderContext fontRenderContext) {
        return metricComposer.buildCharacterMetrics(this.font, c, fontRenderContext);
    }

    private static class WmiMaplePiFontMetrics
    extends WmiFontMetrics {
        protected WmiMaplePiFontMetrics(Font font) {
            super(font);
        }

        protected float[] getCharacterMetrics(char c, FontRenderContext fontRenderContext) {
            c = WmiFontResolver.mapCharacterForFont(c, this.font);
            return super.getCharacterMetrics(c, fontRenderContext);
        }
    }

    static class WmiMacFontMetricComposer
    extends WmiDefaultFontMetricComposer {
        WmiMacFontMetricComposer() {
        }

        protected Rectangle2D getPixelBounds(GlyphVector glyphVector, GlyphMetrics glyphMetrics) {
            return this.getBounds(glyphVector, glyphMetrics);
        }

        protected void computeMetrics(float[] fArray, GlyphVector glyphVector, GlyphMetrics glyphMetrics, Rectangle2D rectangle2D) {
            super.computeMetrics(fArray, glyphVector, glyphMetrics, rectangle2D);
            fArray[4] = (float)(rectangle2D.getHeight() + rectangle2D.getMinY());
            fArray[5] = (float)(-rectangle2D.getMinY());
        }
    }

    static class WmiDefaultFontMetricComposer
    implements WmiFontMetricComposer {
        WmiDefaultFontMetricComposer() {
        }

        public float[] buildCharacterMetrics(Font font, char c, FontRenderContext fontRenderContext) {
            float[] fArray = new float[7];
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, Character.toString(c));
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
            Rectangle2D rectangle2D = this.getBounds(glyphVector, glyphMetrics);
            this.computeMetrics(fArray, glyphVector, glyphMetrics, rectangle2D);
            return fArray;
        }

        protected void computeMetrics(float[] fArray, GlyphVector glyphVector, GlyphMetrics glyphMetrics, Rectangle2D rectangle2D) {
            fArray[2] = glyphMetrics.getAdvance();
            fArray[5] = (float)(rectangle2D.getMinY() + rectangle2D.getHeight());
            fArray[4] = (float)(-rectangle2D.getY());
            fArray[0] = (float)rectangle2D.getWidth();
            fArray[6] = glyphVector.getGlyphCode(0);
            float f = (float)(-rectangle2D.getMinX());
            if (f < 0.0f) {
                f = 0.0f;
            }
            fArray[1] = f;
            f = (float)(rectangle2D.getWidth() + rectangle2D.getMinX() - (double)glyphMetrics.getAdvance());
            if (f < 0.0f) {
                f = 0.0f;
            }
            fArray[3] = f;
        }

        protected Rectangle2D getBounds(GlyphVector glyphVector, GlyphMetrics glyphMetrics) {
            return glyphMetrics.getBounds2D();
        }

        public float[] buildFontMetrics(Font font, WmiFontMetrics wmiFontMetrics, FontRenderContext fontRenderContext) {
            float[] fArray = new float[6];
            Rectangle2D rectangle2D = font.getMaxCharBounds(fontRenderContext);
            fArray[3] = (float)(-rectangle2D.getMinY());
            fArray[2] = (float)rectangle2D.getWidth();
            fArray[4] = (float)(rectangle2D.getHeight() + rectangle2D.getMinY());
            fArray[5] = (float)rectangle2D.getHeight();
            fArray[1] = 0.65f * fArray[3];
            fArray[0] = 0.1f * fArray[3];
            return fArray;
        }
    }

    public static interface WmiFontMetricComposer {
        public float[] buildCharacterMetrics(Font var1, char var2, FontRenderContext var3);

        public float[] buildFontMetrics(Font var1, WmiFontMetrics var2, FontRenderContext var3);
    }
}

