/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportAction;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import java.io.IOException;
import java.util.HashMap;

public abstract class WmiHashedExportFormatter
extends WmiExportFormatter {
    private HashMap actionTable = new HashMap();

    protected WmiHashedExportFormatter() {
        this.hashActions();
    }

    protected abstract void hashActions();

    protected void addAction(WmiModelTag wmiModelTag, WmiExportAction wmiExportAction) {
        this.actionTable.put(wmiModelTag, wmiExportAction);
    }

    protected WmiExportAction getFormatAction(WmiModelTag wmiModelTag) {
        return (WmiExportAction)this.actionTable.get(wmiModelTag);
    }

    protected boolean isModelVisible(WmiModel wmiModel) throws WmiNoReadAccessException {
        return wmiModel.isVisible();
    }

    protected void postFormat() throws IOException {
    }

    protected void preFormat() throws IOException {
    }

    public void processModel(WmiModel wmiModel) throws WmiNoReadAccessException, IOException {
        WmiModelTag wmiModelTag;
        if (this.ignoreHiddenModels() && !this.isModelVisible(wmiModel)) {
            return;
        }
        WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
        if (wmiModelTag != null) {
            boolean bl = false;
            WmiExportAction wmiExportAction = this.getFormatAction(wmiModelTag);
            if (wmiExportAction != null) {
                bl = wmiExportAction.processChildModels();
                wmiExportAction.openModel(this, wmiModel);
            } else {
                this.reportUnrecognizedTag(wmiModel);
            }
            if (bl && wmiModel instanceof WmiCompositeModel) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModel;
                for (int i = 0; i < wmiCompositeModel.getChildCount(); ++i) {
                    this.processModel(wmiCompositeModel.getChild(i));
                }
            }
            if (wmiExportAction != null) {
                wmiExportAction.closeModel(this, wmiModel);
            }
        } else {
            this.reportModelError(wmiModel, "Could not identify model tag.");
        }
    }

    protected int format() throws WmiFormatException, WmiNoReadAccessException {
        WmiModel wmiModel = this.getRootModel();
        int n = 0;
        this.reportFormatBegin();
        try {
            this.preFormat();
            this.processModel(wmiModel);
            this.postFormat();
        }
        catch (IOException iOException) {
            WmiErrorLog.log(iOException);
            n = -1;
        }
        this.reportFormatEnd();
        return n;
    }

    public void writeAttribute(Object object, Object object2) throws IOException {
        this.writeText(object.toString());
        this.writeBinary("=");
        this.writeText(object2.toString());
    }

    public void writeTextModel(WmiTextModel wmiTextModel) throws WmiNoReadAccessException, IOException {
        this.writeText(wmiTextModel.getText());
    }
}

