/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.WmiImportActionProxy;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.WmiParseObserver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public abstract class WmiHashedImportParser
implements WmiImportParser {
    private HashMap actionTable = new HashMap();
    private Stack charAttributeStack = new Stack();
    private WmiModel activeModel = null;
    private int rootLevelOffset = 0;
    private ArrayList observers = new ArrayList();
    private Stack textEncodingStack = new Stack();
    protected WmiFontAttributeSet charAttr = new WmiFontAttributeSet();
    protected WmiCompositeModel rootModel = null;

    protected WmiHashedImportParser() {
        this.hashActions();
    }

    protected abstract void hashActions();

    protected void cancelActiveModel() throws WmiNoReadAccessException {
        if (this.activeModel != null) {
            this.activeModel = this.activeModel.getParent();
        }
    }

    protected void commitChild(WmiModel wmiModel) throws WmiNoWriteAccessException {
        if (wmiModel != null && this.activeModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)this.activeModel;
            if (wmiCompositeModel == this.rootModel) {
                try {
                    wmiCompositeModel.addChild(wmiModel, this.rootLevelOffset++);
                }
                catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                    this.reportObjectError(wmiCompositeModel.getTag().toString(), null, wmiCompositeModel, wmiModelIndexOutOfBoundsException);
                }
            } else {
                wmiCompositeModel.appendChild(wmiModel);
            }
        }
    }

    public WmiModel getActiveModel() {
        return this.activeModel;
    }

    public void setActiveModel(WmiModel wmiModel) {
        this.activeModel = wmiModel;
    }

    protected String getTextEncoding() {
        String string = null;
        if (!this.textEncodingStack.empty()) {
            string = (String)this.textEncodingStack.peek();
        }
        return string;
    }

    protected boolean hasAncestor(WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        boolean bl = false;
        if (this.activeModel != null) {
            bl = this.activeModel.getTag() == wmiModelTag ? true : WmiModelUtil.findAncestorOfTag(this.activeModel, wmiModelTag) != null;
        }
        return bl;
    }

    protected boolean hasAncestor(WmiModelTag[] wmiModelTagArray) throws WmiNoReadAccessException {
        boolean bl = false;
        if (this.activeModel != null) {
            for (int i = 0; !bl && i < wmiModelTagArray.length; ++i) {
                WmiModelTag wmiModelTag = wmiModelTagArray[i];
                if (this.activeModel.getTag() != wmiModelTag) continue;
                bl = true;
            }
            if (!bl) {
                bl = WmiModelUtil.findAncestorOfTag(this.activeModel, wmiModelTagArray) != null;
            }
        }
        return bl;
    }

    protected void parserInitialization(WmiCompositeModel wmiCompositeModel, int n) {
        this.rootModel = wmiCompositeModel;
        this.rootLevelOffset = n;
        this.charAttributeStack.clear();
        this.textEncodingStack.clear();
    }

    protected void reportParseBegin() {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiParseObserver wmiParseObserver = (WmiParseObserver)this.observers.get(i);
                wmiParseObserver.parseBegin(this.getDocument());
            }
        }
    }

    protected void reportParseEnd() {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiParseObserver wmiParseObserver = (WmiParseObserver)this.observers.get(i);
                wmiParseObserver.parseEnd(this.getDocument());
            }
        }
    }

    protected void reportUnrecognizedObject(String string, Object object) {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiParseObserver wmiParseObserver = (WmiParseObserver)this.observers.get(i);
                wmiParseObserver.unrecognizedInputObject(string, object);
            }
        }
    }

    protected void reportUnsupportedObject(String string, Object object) {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiParseObserver wmiParseObserver = (WmiParseObserver)this.observers.get(i);
                wmiParseObserver.unsupportedInputObject(string, object);
            }
        }
    }

    public void addAction(WmiModelTag wmiModelTag, WmiImportActionProxy wmiImportActionProxy) {
        this.addAction(wmiModelTag.toString(), wmiImportActionProxy);
    }

    public void addAction(String string, WmiImportActionProxy wmiImportActionProxy) {
        this.actionTable.put(string, wmiImportActionProxy);
    }

    public void addAction(WmiModelTag wmiModelTag, String string, String string2) {
        this.addAction(wmiModelTag, new WmiImportActionProxy(string, string2));
    }

    public void addAction(String string, String string2, String string3) {
        this.addAction(string, new WmiImportActionProxy(string2, string3));
    }

    public void closeRootModel() {
        this.charAttributeStack.clear();
        this.textEncodingStack.clear();
        this.activeModel = null;
        this.reportParseEnd();
    }

    public WmiImportAction getParseAction(String string) {
        WmiImportAction wmiImportAction = (WmiImportAction)this.actionTable.get(string);
        if (wmiImportAction == null) {
            wmiImportAction = (WmiImportAction)this.actionTable.get(string.toLowerCase());
        }
        if (wmiImportAction == null) {
            wmiImportAction = (WmiImportAction)this.actionTable.get(string.toUpperCase());
        }
        return wmiImportAction;
    }

    public void openRootModel() {
        this.reportParseBegin();
        this.activeModel = this.rootModel;
    }

    public void closeModel(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (wmiModel == null) {
            wmiModel = this.activeModel;
        } else {
            while (this.activeModel != null && wmiModel != this.activeModel) {
                this.activeModel = this.activeModel.getParent();
            }
            if (this.activeModel == null) {
                this.reportObjectError(null, null, wmiModel, "Tried to close model that did not exist in hierarchy.");
                return;
            }
        }
        if (wmiModel != null) {
            this.activeModel = this.activeModel.getParent();
            this.commitChild(wmiModel);
        }
    }

    public String decode(String string) {
        return string;
    }

    public void defineTextContent(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (string != null) {
            if (string.length() == 0) {
                WmiTextModel wmiTextModel = new WmiTextModel(this.getDocument(), string, (WmiFontAttributeSet)this.getActiveCharAttributes().copyAttributes());
                this.commitChild(wmiTextModel);
                return;
            }
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(10, n);
                if (n2 < 0) {
                    n2 = string.length() - 1;
                }
                String string2 = string.substring(n, n2 + 1);
                WmiTextModel wmiTextModel = new WmiTextModel(this.getDocument(), string2, (WmiFontAttributeSet)this.getActiveCharAttributes().copyAttributes());
                this.commitChild(wmiTextModel);
                n = n2 + 1;
            }
        }
    }

    public void flush() {
        WmiMathDocumentModel wmiMathDocumentModel = this.getDocument();
        if (wmiMathDocumentModel != null) {
            try {
                wmiMathDocumentModel.update(null);
            }
            catch (WmiNoUpdateAccessException wmiNoUpdateAccessException) {
                this.reportObjectError(wmiMathDocumentModel.getTag().toString(), null, wmiMathDocumentModel, wmiNoUpdateAccessException);
            }
        }
    }

    public WmiFontAttributeSet getActiveCharAttributes() {
        return this.charAttr;
    }

    public WmiMathDocumentModel getDocument() {
        return this.rootModel != null ? this.rootModel.getDocument() : null;
    }

    public void openModel(WmiModel wmiModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (wmiModel != null) {
            if (this.activeModel instanceof WmiCompositeModel) {
                wmiModel.setParent((WmiCompositeModel)this.activeModel);
                this.activeModel = wmiModel;
            } else {
                this.reportObjectError(wmiModel.toString(), null, this.activeModel, "Active model is not a valid parent.");
            }
        }
    }

    public boolean parse(InputStream inputStream, WmiCompositeModel wmiCompositeModel, int n) throws WmiParseException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return this.parse(inputStreamReader, wmiCompositeModel, n);
    }

    public void popCharacterAttributes() {
        if (!this.charAttributeStack.empty()) {
            this.charAttr = (WmiFontAttributeSet)this.charAttributeStack.peek();
            this.charAttributeStack.pop();
        }
    }

    public void popTextEncoding() {
        if (!this.textEncodingStack.empty()) {
            this.textEncodingStack.pop();
        }
    }

    public WmiFontAttributeSet pushCharacterAttributes() {
        this.charAttributeStack.push(this.charAttr.copyAttributes());
        return this.getActiveCharAttributes();
    }

    public void pushTextEncoding(String string) {
        this.textEncodingStack.push(string != null ? string : this.getTextEncoding());
    }

    public boolean registerObserver(WmiParseObserver wmiParseObserver) {
        if (wmiParseObserver != null) {
            this.observers.add(wmiParseObserver);
        }
        return true;
    }

    public void reportObjectError(String string, Object object, WmiModel wmiModel, Object object2) {
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                WmiParseObserver wmiParseObserver = (WmiParseObserver)this.observers.get(i);
                wmiParseObserver.objectError(string, object, wmiModel, object2);
            }
        }
    }

    public void reportObjectWarning(int n, String string, Object object, WmiModel wmiModel, Object object2) {
        switch (n) {
            case -1: {
                this.reportObjectError(string, object, wmiModel, object2);
                break;
            }
            case -2: {
                this.reportUnrecognizedObject(string, object);
                break;
            }
            case -3: {
                this.reportUnsupportedObject(string, object);
            }
        }
    }

    public void setActiveCharAttributes(WmiAttributeSet wmiAttributeSet) {
        this.charAttr.addAttributes(wmiAttributeSet);
    }

    public boolean confirmLicense(File file) {
        return true;
    }
}

