/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.io.IOException;

public class WmiMathMLNumericExportAction
extends WmiMathMLExportAction {
    private static final String NUMERIC_PUNCTUATION_PATTERN = "[,\\.\\-\\+]";
    private static final String SCIENTIFIC_NOTATION_PATTERN = "[0-9]+e[\\+\\-" + WmiMathEntityNameMapper.getUnicodeCharacter("minus") + "]?[0-9]+";

    public void openModel(WmiExportFormatter wmiExportFormatter, WmiModel wmiModel) throws IOException {
        WmiNumericModel wmiNumericModel = (WmiNumericModel)wmiModel;
        wmiExportFormatter.writeBinary("<mn");
        try {
            wmiExportFormatter.writeText(this.exportAttributes(WmiMathAttributeSet.MATHML_ATTR_KEYS, (WmiAbstractArrayAttributeSet)((WmiMathAttributeSet)wmiNumericModel.getAttributes())));
            wmiExportFormatter.writeBinary(">");
            String string = wmiNumericModel.getTokenContents();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.toString(c).matches(NUMERIC_PUNCTUATION_PATTERN) && !string.matches(SCIENTIFIC_NOTATION_PATTERN) && WmiMathEntityNameMapper.getEntityName(c) != null) {
                    wmiExportFormatter.writeBinary("&" + WmiMathEntityNameMapper.getEntityName(c) + ";");
                    continue;
                }
                wmiExportFormatter.writeBinary(String.valueOf(c));
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void closeModel(WmiExportFormatter wmiExportFormatter, WmiModel wmiModel) throws IOException {
        wmiExportFormatter.writeBinary("</mn>");
    }
}

