/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.tests;

import com.maplesoft.client.JavaCallbackListener;
import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeAdapter;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.MapleServerSocket;
import com.maplesoft.client.SetGetHandler;
import com.maplesoft.mathdoc.controller.WmiIndexedViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPresentationFormatter;
import com.maplesoft.mathdoc.io.mathml.tests.ExampleFileFilter;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelWriter;
import com.maplesoft.mathdoc.view.WmiMathMLDocumentView;
import com.maplesoft.util.commandlineoptions.AbstractOptionHandler;
import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class WmiMathMLImportParserTestApp
extends KernelAdapter
implements KernelConnectionListener {
    private WmiMathDocumentModel doc = new WmiMathDocumentModel();
    private WmiMathMLDocumentView view;
    private static ViewTestFrame testFrame;
    private SetGetHandler setGetHandler;
    private KernelConnection kernelConnection = null;
    private static int kernelID;

    public KernelConnection getConnection() {
        return this.kernelConnection;
    }

    public int getKernelID() {
        return kernelID;
    }

    public void restart() {
        KernelProxy kernelProxy = KernelProxy.getInstance();
        kernelProxy.evaluate(this.getKernelID(), new KernelAdapter(), "restart;");
    }

    public void processConnection(KernelConnectionEvent kernelConnectionEvent) {
        if (kernelConnectionEvent.getKernelState() == 1) {
            KernelProxy kernelProxy = KernelProxy.getInstance();
            kernelProxy.evaluate(this.getKernelID(), this, "gc();");
        }
    }

    public void processDisconnection(KernelConnectionEvent kernelConnectionEvent) {
    }

    public void setConnection(KernelConnection kernelConnection) {
        this.kernelConnection = kernelConnection;
        this.kernelConnection.getInterfaceProperties().addChangeListener(new KernelInterfacePropertiesChangeAdapter());
    }

    public boolean processError(KernelEvent kernelEvent) {
        testFrame.getMathMLArea().setForeground(Color.RED);
        testFrame.getMathMLArea().append(kernelEvent.getText());
        return true;
    }

    public boolean processJava(KernelEvent kernelEvent) {
        return JavaCallbackListener.processJava(kernelEvent);
    }

    public boolean processChar(KernelEvent kernelEvent) {
        testFrame.getMathMLArea().setForeground(Color.BLACK);
        testFrame.getMathMLArea().append(kernelEvent.getDag().getChild(0).getData());
        return true;
    }

    public boolean processSet(KernelEvent kernelEvent) {
        this.setGetHandler.processSetHandler(kernelEvent);
        return true;
    }

    public boolean processGet(KernelEvent kernelEvent) {
        this.setGetHandler.processGetHandler(kernelEvent);
        return true;
    }

    public WmiMathMLImportParserTestApp() {
        this.doc.setReadOnly(true);
        WmiIndexedViewFactory wmiIndexedViewFactory = new WmiIndexedViewFactory();
        this.view = new WmiMathMLDocumentView(this.doc, wmiIndexedViewFactory);
        this.setGetHandler = new SetGetHandler(this);
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = MapleServerSocket.getCommandOptionParser();
            ((CommandOptionParser)object).addHandler(new TestSuiteDirHandler("testsuitedir"));
            ((CommandOptionParser)object).addHandler(new AutomatedHandler("auto"));
            ((CommandOptionParser)object).process(stringArray);
        }
        catch (CommandOptionException commandOptionException) {
            WmiErrorLog.log(commandOptionException);
            System.exit(-1);
        }
        object = new WmiMathMLImportParserTestApp();
        if (AutomatedHandler.automatedTesting) {
            super.performAutomatedTesting();
        } else {
            testFrame = new ViewTestFrame(((WmiMathMLImportParserTestApp)object).view, new Dimension(750, 600), (WmiMathMLImportParserTestApp)object);
        }
    }

    private void generateMathML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XMLTools:-Print(MathML:-ExportPresentation(");
        stringBuffer.append(string);
        stringBuffer.append("));");
        KernelProxy kernelProxy = KernelProxy.getInstance();
        if (kernelProxy.getKernelConnections().isEmpty()) {
            kernelProxy.createKernelConnection(this);
        }
        kernelProxy.evaluate(this.getKernelID(), this, stringBuffer.toString());
    }

    private String generateModelReport(WmiMathDocumentModel wmiMathDocumentModel) throws WmiNoReadAccessException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        WmiModelLock.readLock(wmiMathDocumentModel, false);
        WmiModelWriter wmiModelWriter = new WmiModelWriter(printStream);
        wmiModelWriter.report(wmiMathDocumentModel, true);
        WmiModelLock.readUnlock(wmiMathDocumentModel);
        return byteArrayOutputStream.toString();
    }

    private void performAutomatedTesting() {
        WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
        WmiErrorLog.setVerbosity(1);
        String[] stringArray = AutomatedHandler.getTestFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string;
                File file = new File(stringArray[i]);
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string2 = "";
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    int n2 = string.indexOf("<math>");
                    int n3 = string.indexOf("</math>");
                    if (n2 != -1 && n3 != -1) {
                        try {
                            WmiModelLock.writeLock(this.doc, false);
                            this.doc.removeChildren(0, this.doc.getChildCount());
                            String string3 = string.substring(n2, n3 + 7);
                            string3 = "<?xml version=\"1.0\" standalone=\"no\" ?>" + string3.replaceAll("&", "&amp;");
                            wmiMathMLImportParser.parse(new StringReader(string3), (WmiCompositeModel)this.doc, 0);
                            WmiModelLock.writeUnlock(this.doc);
                        }
                        catch (Exception exception) {
                            System.out.println(string2 + ": " + exception.getMessage());
                        }
                        continue;
                    }
                    int n4 = string.indexOf("testsuite");
                    if (n4 == -1) continue;
                    string2 = string.substring(string.lastIndexOf("/") + 1);
                    if (++n % 5 != 0) continue;
                    System.out.println("Test #" + n);
                }
                bufferedReader.close();
                fileReader.close();
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Could not read file " + stringArray[i]);
            }
        }
    }

    private void parseMathML(String string) {
        Object var2_2 = null;
        try {
            WmiModelLock.writeLock(this.doc, false);
            this.doc.removeChildren(0, this.doc.getChildCount());
            WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
            string = "<?xml version=\"1.0\" standalone=\"no\" ?>" + string.replaceAll("\\n", "");
            wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)this.doc, 0);
            WmiModelLock.writeUnlock(this.doc);
            WmiModelLock.readLock(this.doc, false);
            this.view.updateView();
            WmiModelLock.readUnlock(this.doc);
            testFrame.getFrame().update(testFrame.getFrame().getGraphics());
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            JOptionPane.showMessageDialog(this.view, wmiNoReadAccessException.getMessage(), "Parse Error", 0);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            JOptionPane.showMessageDialog(this.view, wmiNoWriteAccessException.getMessage(), "Parse Error", 0);
        }
        catch (WmiParseException wmiParseException) {
            JOptionPane.showMessageDialog(this.view, wmiParseException.getMessage(), "Parse Error", 0);
            wmiParseException.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            JOptionPane.showMessageDialog(this.view, wmiModelIndexOutOfBoundsException.getMessage(), "Parse Error", 0);
        }
    }

    static {
        kernelID = -999;
    }

    protected static class ViewTestFrame {
        protected static final int DEFAULT_WIDTH = 750;
        protected static final int DEFAULT_HEIGHT = 600;
        private static final int TOP_MARGIN = 50;
        private static final int LEFT_MARGIN = 100;
        private WmiMathMLDocumentView view;
        private WmiMathDocumentModel doc;
        private WmiMathMLImportParserTestApp parser;
        private JFrame frame = null;
        private JTextField inputField;
        private JTextArea mathMLArea;
        private JButton exportPButton;
        private JTextArea exportArea;

        protected ViewTestFrame(WmiMathMLDocumentView wmiMathMLDocumentView, Dimension dimension, WmiMathMLImportParserTestApp wmiMathMLImportParserTestApp) {
            this.view = wmiMathMLDocumentView;
            this.doc = (WmiMathDocumentModel)wmiMathMLDocumentView.getModel();
            this.parser = wmiMathMLImportParserTestApp;
            this.createFrame(dimension);
        }

        protected ViewTestFrame(Dimension dimension, WmiMathMLImportParserTestApp wmiMathMLImportParserTestApp) {
            this(new WmiMathMLDocumentView(), dimension, wmiMathMLImportParserTestApp);
        }

        public JFrame getFrame() {
            return this.frame;
        }

        public JTextArea getMathMLArea() {
            return this.mathMLArea;
        }

        public JTextField getInputField() {
            return this.inputField;
        }

        public WmiMathDocumentModel getDocumentModel() {
            return this.doc;
        }

        public WmiMathMLDocumentView getDocumentView() {
            return this.view;
        }

        protected void createFrame(Dimension dimension) {
            this.frame = new JFrame("MathML Parser Test");
            this.frame.addWindowListener(new ViewTestFrameWindowListener());
            JComponent jComponent = (JComponent)this.frame.getContentPane();
            JScrollPane jScrollPane = new JScrollPane(22, 31);
            JViewport jViewport = jScrollPane.getViewport();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel("1-D Math:");
            this.inputField = new JTextField(40);
            this.inputField.addKeyListener(new InputFieldListener());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 3));
            JButton jButton = new JButton("Generate MathML");
            jButton.addActionListener(new GenerateButtonListener());
            JButton jButton2 = new JButton("Load Test File...");
            jButton2.addActionListener(new LoadMathMLButtonListener());
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            jPanel.add(jLabel);
            jPanel.add(this.inputField);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            JLabel jLabel2 = new JLabel("Intermediate MathML:");
            JPanel jPanel4 = new JPanel();
            jPanel4.setMinimumSize(new Dimension(100, 200));
            JScrollPane jScrollPane2 = new JScrollPane(22, 32);
            JViewport jViewport2 = jScrollPane2.getViewport();
            this.mathMLArea = new JTextArea(10, 80);
            jViewport2.add(this.mathMLArea);
            JPanel jPanel5 = new JPanel();
            jPanel5.setMinimumSize(new Dimension(100, 200));
            JButton jButton3 = new JButton("Parse MathML");
            jButton3.addActionListener(new ParseButtonListener());
            this.exportPButton = new JButton("Export P MathML");
            this.exportPButton.addActionListener(new PresentationExportButtonListener());
            this.exportPButton.setEnabled(false);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jButton3);
            jPanel6.add(this.exportPButton);
            jPanel3.add(jLabel2);
            jPanel3.add(jPanel4);
            jPanel3.add(jScrollPane2);
            jPanel3.add(jPanel5);
            jPanel3.add(jPanel6);
            JPanel jPanel7 = new JPanel(new BorderLayout());
            jPanel7.setPreferredSize(new Dimension(100, 200));
            jPanel7.add(jScrollPane);
            jViewport.add(this.view);
            jViewport.setBackground(Color.white);
            JPanel jPanel8 = new JPanel(new BorderLayout());
            JScrollPane jScrollPane3 = new JScrollPane(22, 32);
            JViewport jViewport3 = jScrollPane3.getViewport();
            this.exportArea = new JTextArea(10, 40);
            jViewport3.add(this.exportArea);
            jViewport3.setBackground(Color.white);
            jPanel8.add(jScrollPane3);
            JPanel jPanel9 = new JPanel();
            jPanel9.setMinimumSize(new Dimension(dimension.width, 50));
            jComponent.setLayout(new BoxLayout(jComponent, 3));
            jComponent.add(jPanel);
            jComponent.add(jPanel3);
            jComponent.add(jPanel9);
            jComponent.add(jPanel7);
            jComponent.add(jPanel9);
            jComponent.add(jPanel8);
            this.frame.setDefaultCloseOperation(2);
            this.frame.setBounds(100, 50, dimension.width, dimension.height);
            this.frame.show();
        }

        public class InputFieldListener
        implements KeyListener {
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    testFrame.getMathMLArea().setText("");
                    ViewTestFrame.this.parser.generateMathML(testFrame.getInputField().getText());
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        }

        public class PresentationExportButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                WmiMathMLPresentationFormatter wmiMathMLPresentationFormatter = new WmiMathMLPresentationFormatter(ViewTestFrame.this.view);
                StringWriter stringWriter = new StringWriter();
                try {
                    WmiModelLock.readLock(ViewTestFrame.this.doc, false);
                    wmiMathMLPresentationFormatter.format(stringWriter, ViewTestFrame.this.doc);
                    WmiModelLock.readUnlock(ViewTestFrame.this.doc);
                    ViewTestFrame.this.exportArea.setText(stringWriter.toString());
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                catch (WmiFormatException wmiFormatException) {
                    WmiErrorLog.log(wmiFormatException);
                }
            }
        }

        public class ViewImageButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TestSuiteDirHandler.testSuiteFile.substring(0, TestSuiteDirHandler.testSuiteFile.indexOf(".mml")) + ".png";
                try {
                    Runtime.getRuntime().exec("mspaint \"" + string + "\"");
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(ViewTestFrame.this.view, "Cannot find image file for test case.", "View Image", 0);
                }
            }
        }

        public class ParseButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ViewTestFrame.this.parser.parseMathML(testFrame.getMathMLArea().getText());
                ViewTestFrame.this.exportPButton.setEnabled(true);
            }
        }

        public class LoadMathMLButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(TestSuiteDirHandler.testSuiteDir));
                ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
                exampleFileFilter.addExtension("mml");
                exampleFileFilter.setDescription("MathML Files");
                jFileChooser.setFileFilter(exampleFileFilter);
                int n = jFileChooser.showOpenDialog(testFrame.getFrame());
                if (n == 0) {
                    try {
                        TestSuiteDirHandler.testSuiteFile = jFileChooser.getSelectedFile().getAbsolutePath();
                        FileReader fileReader = new FileReader(jFileChooser.getSelectedFile().getAbsolutePath());
                        int n2 = 0;
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((n2 = fileReader.read()) != -1) {
                            stringBuffer.append((char)n2);
                        }
                        testFrame.getMathMLArea().setText(stringBuffer.toString());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(ViewTestFrame.this.view, fileNotFoundException.getMessage(), "File Not Found", 0);
                        bl = false;
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(ViewTestFrame.this.view, iOException.getMessage(), "I/O Exception", 0);
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
        }

        public class GenerateButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                testFrame.getMathMLArea().setText("");
                ViewTestFrame.this.parser.generateMathML(testFrame.getInputField().getText());
            }
        }

        private class ViewTestFrameWindowListener
        extends WindowAdapter {
            private ViewTestFrameWindowListener() {
            }

            public void windowActivated(WindowEvent windowEvent) {
                WmiMathMLDocumentView.setActiveDocumentView(ViewTestFrame.this.view);
            }

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        }
    }

    protected static class AutomatedHandler
    extends AbstractOptionHandler {
        protected static boolean automatedTesting = false;
        protected static String[] testFiles;

        protected AutomatedHandler(String string) {
            this.addOptionNames(new String[]{string});
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) {
            automatedTesting = true;
            String string = stringArray[1];
            testFiles = string.split(";");
        }

        public static String[] getTestFiles() {
            return testFiles;
        }

        public int numArgs() {
            return 1;
        }
    }

    protected static class TestSuiteDirHandler
    extends AbstractOptionHandler {
        protected static String testSuiteDir;
        protected static String testSuiteFile;

        protected TestSuiteDirHandler(String string) {
            this.addOptionNames(new String[]{string});
        }

        public void handle(CommandOptionParser commandOptionParser, String[] stringArray) {
            testSuiteDir = stringArray[1];
        }

        public int numArgs() {
            return 1;
        }

        static {
            testSuiteFile = "";
        }
    }
}

